/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.rtf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

abstract class AbstractFilter
extends OutputStream {
    protected char[] translationTable = latin1TranslationTable;
    protected boolean[] specialsTable = noSpecialsTable;
    static final char[] latin1TranslationTable;
    static final boolean[] noSpecialsTable;
    static final boolean[] allSpecialsTable;

    public void readFromStream(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[16384];
        while ((n = inputStream.read(byArray)) >= 0) {
            this.write(byArray, 0, n);
        }
    }

    public void readFromReader(Reader reader) throws IOException {
        int n;
        char[] cArray = new char[2048];
        while ((n = reader.read(cArray)) >= 0) {
            for (int i = 0; i < n; ++i) {
                this.write(cArray[i]);
            }
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (n < 0) {
            n += 256;
        }
        if (this.specialsTable[n]) {
            this.writeSpecial(n);
        } else {
            char c = this.translationTable[n];
            if (c != '\u0000') {
                this.write(c);
            }
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        StringBuffer stringBuffer = null;
        while (n2 > 0) {
            short s = byArray[n];
            if (s < 0) {
                s = (short)(s + 256);
            }
            if (this.specialsTable[s]) {
                if (stringBuffer != null) {
                    this.write(stringBuffer.toString());
                    stringBuffer = null;
                }
                this.writeSpecial(s);
            } else {
                char c = this.translationTable[s];
                if (c != '\u0000') {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append(c);
                }
            }
            --n2;
            ++n;
        }
        if (stringBuffer != null) {
            this.write(stringBuffer.toString());
        }
    }

    public void write(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.write(string.charAt(i));
        }
    }

    protected abstract void write(char var1) throws IOException;

    protected abstract void writeSpecial(int var1) throws IOException;

    static {
        int n;
        noSpecialsTable = new boolean[256];
        for (n = 0; n < 256; ++n) {
            AbstractFilter.noSpecialsTable[n] = false;
        }
        allSpecialsTable = new boolean[256];
        for (n = 0; n < 256; ++n) {
            AbstractFilter.allSpecialsTable[n] = true;
        }
        latin1TranslationTable = new char[256];
        for (n = 0; n < 256; ++n) {
            AbstractFilter.latin1TranslationTable[n] = (char)n;
        }
    }
}

