/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHParameterSpec;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public final class DHParameters
extends AlgorithmParametersSpi {
    private BigInteger p = BigInteger.ZERO;
    private BigInteger g = BigInteger.ZERO;
    private int l = 0;

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.p = ((DHParameterSpec)algorithmParameterSpec).getP();
        this.g = ((DHParameterSpec)algorithmParameterSpec).getG();
        this.l = ((DHParameterSpec)algorithmParameterSpec).getL();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            DerValue derValue = new DerValue(byArray);
            if (derValue.tag != 48) {
                throw new IOException("DH params parsing error");
            }
            derValue.data.reset();
            this.p = derValue.data.getBigInteger();
            this.g = derValue.data.getBigInteger();
            if (derValue.data.available() != 0) {
                this.l = derValue.data.getInteger();
            }
            if (derValue.data.available() != 0) {
                throw new IOException("DH parameter parsing error: Extra data");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Private-value length too big");
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (DHParameterSpec.class.isAssignableFrom(clazz)) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        throw new InvalidParameterSpecException("Inappropriate parameter Specification");
    }

    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.p);
        derOutputStream2.putInteger(this.g);
        if (this.l > 0) {
            derOutputStream2.putInteger(this.l);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("SunJCE Diffie-Hellman Parameters:" + string + "p:" + string + Debug.toHexString(this.p) + string + "g:" + string + Debug.toHexString(this.g));
        if (this.l != 0) {
            stringBuffer.append(string + "l:" + string + "    " + this.l);
        }
        return stringBuffer.toString();
    }
}

