/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class ChangesetQuery {
    private Integer uid = null;
    private String userName = null;
    private Bounds bounds = null;
    private Date closedAfter = null;
    private Date createdBefore = null;
    private Boolean open = null;
    private Boolean closed = null;

    public static ChangesetQuery buildFromUrlQuery(String string) throws ChangesetQueryUrlException {
        return new ChangesetQueryUrlParser().parse(string);
    }

    public ChangesetQuery forUser(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected. Got ''{1}''.", "uid", n));
        }
        this.uid = n;
        this.userName = null;
        return this;
    }

    public ChangesetQuery forUser(String string) {
        CheckParameterUtil.ensureParameterNotNull(string, "username");
        this.userName = string;
        this.uid = null;
        return this;
    }

    public boolean isRestrictedToPartiallyIdentifiedUser() {
        return this.userName != null;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isRestrictedToFullyIdentifiedUser() {
        return this.uid > 0;
    }

    public ChangesetQuery inBbox(double d, double d2, double d3, double d4) throws IllegalArgumentException {
        if (!LatLon.isValidLon(d)) {
            throw new IllegalArgumentException(I18n.tr("Illegal longitude value for parameter ''{0}'', got {1}", "minLon", d));
        }
        if (!LatLon.isValidLon(d3)) {
            throw new IllegalArgumentException(I18n.tr("Illegal longitude value for parameter ''{0}'', got {1}", "maxLon", d3));
        }
        if (!LatLon.isValidLat(d2)) {
            throw new IllegalArgumentException(I18n.tr("Illegal latitude value for parameter ''{0}'', got {1}", "minLat", d2));
        }
        if (!LatLon.isValidLat(d4)) {
            throw new IllegalArgumentException(I18n.tr("Illegal longitude value for parameter ''{0}'', got {1}", "maxLat", d4));
        }
        return this.inBbox(new LatLon(d, d2), new LatLon(d3, d4));
    }

    public ChangesetQuery inBbox(LatLon latLon, LatLon latLon2) {
        CheckParameterUtil.ensureParameterNotNull(latLon, "min");
        CheckParameterUtil.ensureParameterNotNull(latLon2, "max");
        this.bounds = new Bounds(latLon, latLon2);
        return this;
    }

    public ChangesetQuery inBbox(Bounds bounds) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(bounds, "bbox");
        this.bounds = bounds;
        return this;
    }

    public ChangesetQuery closedAfter(Date date) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(date, "d");
        this.closedAfter = date;
        return this;
    }

    public ChangesetQuery closedAfterAndCreatedBefore(Date date, Date date2) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(date, "closedAfter");
        CheckParameterUtil.ensureParameterNotNull(date2, "createdBefore");
        this.closedAfter = date;
        this.createdBefore = date2;
        return this;
    }

    public ChangesetQuery beingOpen(boolean bl) {
        this.open = bl;
        return this;
    }

    public ChangesetQuery beingClosed(boolean bl) {
        this.closed = bl;
        return this;
    }

    public String getQueryString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.uid != null) {
            stringBuffer.append("user").append("=").append(this.uid);
        } else if (this.userName != null) {
            try {
                stringBuffer.append("display_name").append("=").append(URLEncoder.encode(this.userName, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        if (this.bounds != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("&");
            }
            stringBuffer.append("bbox=").append(this.bounds.encodeAsString(","));
        }
        if (this.closedAfter != null && this.createdBefore != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("&");
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
            stringBuffer.append("time").append("=").append(simpleDateFormat.format(this.closedAfter));
            stringBuffer.append(",").append(simpleDateFormat.format(this.createdBefore));
        } else if (this.closedAfter != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("&");
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
            stringBuffer.append("time").append("=").append(simpleDateFormat.format(this.closedAfter));
        }
        if (this.open != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("&");
            }
            stringBuffer.append("open=").append(Boolean.toString(this.open));
        } else if (this.closed != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("&");
            }
            stringBuffer.append("closed=").append(Boolean.toString(this.closed));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getQueryString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangesetQueryUrlParser {
        protected int parseUid(String string) throws ChangesetQueryUrlException {
            int n;
            if (string == null || string.trim().equals("")) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "uid", string));
            }
            try {
                n = Integer.parseInt(string);
                if (n <= 0) {
                    throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "uid", string));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "uid", string));
            }
            return n;
        }

        protected boolean parseOpen(String string) throws ChangesetQueryUrlException {
            if (string == null || string.trim().equals("")) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "open", string));
            }
            if (string.equals("true")) {
                return true;
            }
            if (string.equals("false")) {
                return false;
            }
            throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "open", string));
        }

        protected boolean parseBoolean(String string, String string2) throws ChangesetQueryUrlException {
            if (string == null || string.trim().equals("")) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", string2, string));
            }
            if (string.equals("true")) {
                return true;
            }
            if (string.equals("false")) {
                return false;
            }
            throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", string2, string));
        }

        protected Date parseDate(String string, String string2) throws ChangesetQueryUrlException {
            if (string == null || string.trim().equals("")) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", string2, string));
            }
            if (string.endsWith("Z")) {
                string = string.substring(0, string.length() - 1) + "GMT+00:00";
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
            try {
                return simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", string2, string));
            }
        }

        protected Date[] parseTime(String string) throws ChangesetQueryUrlException {
            String[] stringArray = string.split(",");
            if (stringArray == null || stringArray.length == 0 || stringArray.length > 2) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "time", string));
            }
            if (stringArray.length == 1) {
                return new Date[]{this.parseDate(stringArray[0], "time")};
            }
            if (stringArray.length == 2) {
                return new Date[]{this.parseDate(stringArray[0], "time"), this.parseDate(stringArray[1], "time")};
            }
            return null;
        }

        protected ChangesetQuery crateFromMap(Map<String, String> map) throws ChangesetQueryUrlException {
            ChangesetQuery changesetQuery = new ChangesetQuery();
            for (String string : map.keySet()) {
                if (string.equals("uid")) {
                    if (map.containsKey("display_name")) {
                        throw new ChangesetQueryUrlException(I18n.tr("Cannot create a changeset query including both the query parameters ''uid'' and ''display_name''", new Object[0]));
                    }
                    changesetQuery.forUser(this.parseUid(map.get("uid")));
                    continue;
                }
                if (string.equals("display_name")) {
                    if (map.containsKey("uid")) {
                        throw new ChangesetQueryUrlException(I18n.tr("Cannot create a changeset query including both the query parameters ''uid'' and ''display_name''", new Object[0]));
                    }
                    changesetQuery.forUser(map.get("display_name"));
                    continue;
                }
                if (string.equals("open")) {
                    boolean bl = this.parseBoolean(map.get(string), "open");
                    changesetQuery.beingOpen(bl);
                    continue;
                }
                if (string.equals("closed")) {
                    boolean bl = this.parseBoolean(map.get(string), "closed");
                    changesetQuery.beingClosed(bl);
                    continue;
                }
                if (string.equals("time")) {
                    Date[] dateArray = this.parseTime(map.get(string));
                    switch (dateArray.length) {
                        case 1: {
                            changesetQuery.closedAfter(dateArray[0]);
                            break;
                        }
                        case 2: {
                            changesetQuery.closedAfterAndCreatedBefore(dateArray[0], dateArray[1]);
                        }
                    }
                    continue;
                }
                if (string.equals("bbox")) {
                    try {
                        changesetQuery.inBbox(new Bounds(map.get(string), ","));
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ChangesetQueryUrlException(illegalArgumentException);
                    }
                }
                throw new ChangesetQueryUrlException(I18n.tr("Unsupported parameter ''{0}'' in changeset query string", string));
            }
            return changesetQuery;
        }

        protected Map<String, String> createMapFromQueryString(String string) {
            String[] stringArray;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string2 : stringArray = string.split("&")) {
                String[] stringArray2 = string2.split("=");
                hashMap.put(stringArray2[0], stringArray2[1]);
            }
            return hashMap;
        }

        public ChangesetQuery parse(String string) throws ChangesetQueryUrlException {
            if (string == null) {
                return new ChangesetQuery();
            }
            if ((string = string.trim()).equals("")) {
                return new ChangesetQuery();
            }
            Map<String, String> map = this.createMapFromQueryString(string);
            return this.crateFromMap(map);
        }
    }

    public static class ChangesetQueryUrlException
    extends Exception {
        public ChangesetQueryUrlException() {
        }

        public ChangesetQueryUrlException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public ChangesetQueryUrlException(String string) {
            super(string);
        }

        public ChangesetQueryUrlException(Throwable throwable) {
            super(throwable);
        }
    }
}

