/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.conflict;

import java.util.Map;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conflict<T extends OsmPrimitive> {
    private final T my;
    private final T their;
    private final boolean isMyDeleted;
    private Map<PrimitiveId, PrimitiveId> mergedMap;

    public Conflict(T t, T t2) {
        this(t, t2, false);
    }

    public Conflict(T t, T t2, boolean bl) {
        this.my = t;
        this.their = t2;
        this.isMyDeleted = bl;
    }

    public T getMy() {
        return this.my;
    }

    public T getTheir() {
        return this.their;
    }

    public boolean isMatchingMy(OsmPrimitive osmPrimitive) {
        return this.my == osmPrimitive;
    }

    public boolean isMatchingTheir(OsmPrimitive osmPrimitive) {
        return this.their == osmPrimitive;
    }

    public boolean isParticipating(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null) {
            return false;
        }
        return osmPrimitive.getPrimitiveId().equals(((AbstractPrimitive)this.my).getPrimitiveId()) || osmPrimitive.getPrimitiveId().equals(((AbstractPrimitive)this.their).getPrimitiveId());
    }

    public boolean isParticipating(PrimitiveId primitiveId) {
        if (primitiveId == null) {
            return false;
        }
        return primitiveId.equals(((AbstractPrimitive)this.my).getPrimitiveId()) || primitiveId.equals(((AbstractPrimitive)this.their).getPrimitiveId());
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.my == null ? 0 : ((OsmPrimitive)this.my).hashCode());
        n = 31 * n + (this.their == null ? 0 : ((OsmPrimitive)this.their).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Conflict conflict = (Conflict)object;
        if (this.my != conflict.my) {
            return false;
        }
        return this.their == conflict.their;
    }

    public boolean isMyDeleted() {
        return this.isMyDeleted;
    }

    public final Map<PrimitiveId, PrimitiveId> getMergedMap() {
        return this.mergedMap;
    }

    public final void setMergedMap(Map<PrimitiveId, PrimitiveId> map) {
        this.mergedMap = map;
    }
}

