/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import sun.tools.jconsole.LabeledComponent;
import sun.tools.jconsole.OverviewPanel;
import sun.tools.jconsole.Plotter;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.TimeComboBox;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.VMPanel;

class OverviewTab
extends Tab {
    JPanel gridPanel;
    TimeComboBox timeComboBox;

    public static String getTabName() {
        return Resources.getText("Overview", new Object[0]);
    }

    public OverviewTab(VMPanel vMPanel) {
        super(vMPanel, OverviewTab.getTabName());
        this.setBorder(new EmptyBorder(4, 4, 3, 4));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 20, 5));
        jPanel.add((Component)jPanel2, "Center");
        this.timeComboBox = new TimeComboBox(new Plotter[0]);
        LabeledComponent labeledComponent = new LabeledComponent(Resources.getText("Time Range:", new Object[0]), Resources.getMnemonicInt("Time Range:"), this.timeComboBox);
        jPanel2.add(labeledComponent);
        this.gridPanel = new JPanel(new AutoGridLayout(10, 6));
        this.gridPanel.setBorder(null);
        JScrollPane jScrollPane = new JScrollPane(this.gridPanel);
        jScrollPane.setBorder(null);
        jScrollPane.setViewportBorder(null);
        this.add((Component)jScrollPane, "Center");
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        return new SwingWorker<Object, Object>(){

            @Override
            public Object doInBackground() {
                return null;
            }

            @Override
            protected void done() {
                if (OverviewTab.this.gridPanel.getComponentCount() == 0) {
                    final ArrayList<Plotter> arrayList = new ArrayList<Plotter>();
                    for (Tab tab : OverviewTab.this.vmPanel.getTabs()) {
                        OverviewPanel[] overviewPanelArray = tab.getOverviewPanels();
                        if (overviewPanelArray == null) continue;
                        for (OverviewPanel overviewPanel : overviewPanelArray) {
                            OverviewTab.this.gridPanel.add(overviewPanel);
                            Plotter plotter = overviewPanel.getPlotter();
                            if (plotter == null) continue;
                            arrayList.add(plotter);
                            OverviewTab.this.timeComboBox.addPlotter(plotter);
                        }
                    }
                    if (arrayList.size() > 0) {
                        OverviewTab.this.workerAdd(new Runnable(){

                            @Override
                            public void run() {
                                ProxyClient proxyClient = OverviewTab.this.vmPanel.getProxyClient();
                                for (Plotter plotter : arrayList) {
                                    proxyClient.addWeakPropertyChangeListener(plotter);
                                }
                            }
                        });
                    }
                    if (OverviewTab.this.getParent() instanceof JTabbedPane) {
                        Utilities.updateTransparency((JTabbedPane)OverviewTab.this.getParent());
                    }
                }
            }
        };
    }

    private class AutoGridLayout
    extends GridLayout {
        public AutoGridLayout(int n, int n2) {
            super(0, 1, n, n2);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            this.updateColumns(container);
            return super.minimumLayoutSize(container);
        }

        private void updateColumns(Container container) {
            int n;
            int n2 = OverviewTab.this.getWidth();
            int n3 = 1;
            Component[] componentArray = container.getComponents();
            int n4 = componentArray.length;
            for (n = 0; n < n4; ++n) {
                Component component = componentArray[n];
                n3 = Math.max(n3, component.getPreferredSize().width);
            }
            int n5 = container.getComponentCount();
            for (n = n4 = Math.min(n5, n2 / n3); n >= 1; --n) {
                if (n == 1) {
                    this.setColumns(n4);
                    continue;
                }
                if (n5 % n != 0) continue;
                this.setColumns(n);
                break;
            }
        }
    }
}

