/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.win32.coff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;
import sun.jvm.hotspot.debugger.DataSource;
import sun.jvm.hotspot.debugger.MappedByteBufferDataSource;
import sun.jvm.hotspot.debugger.win32.coff.AuxBfEfRecord;
import sun.jvm.hotspot.debugger.win32.coff.AuxFileRecord;
import sun.jvm.hotspot.debugger.win32.coff.AuxFunctionDefinitionRecord;
import sun.jvm.hotspot.debugger.win32.coff.AuxSectionDefinitionsRecord;
import sun.jvm.hotspot.debugger.win32.coff.AuxWeakExternalRecord;
import sun.jvm.hotspot.debugger.win32.coff.COFFException;
import sun.jvm.hotspot.debugger.win32.coff.COFFFile;
import sun.jvm.hotspot.debugger.win32.coff.COFFHeader;
import sun.jvm.hotspot.debugger.win32.coff.COFFLineNumber;
import sun.jvm.hotspot.debugger.win32.coff.COFFRelocation;
import sun.jvm.hotspot.debugger.win32.coff.COFFSymbol;
import sun.jvm.hotspot.debugger.win32.coff.COFFSymbolConstants;
import sun.jvm.hotspot.debugger.win32.coff.DataDirectory;
import sun.jvm.hotspot.debugger.win32.coff.DebugDirectory;
import sun.jvm.hotspot.debugger.win32.coff.DebugDirectoryEntry;
import sun.jvm.hotspot.debugger.win32.coff.DebugTypes;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50MemberAttributes;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSAlignSym;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSFileIndex;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSGlobalPub;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSGlobalSym;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSGlobalTypes;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSLibraries;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSMPC;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSModule;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSOffsetMap16;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSOffsetMap32;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSPreComp;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSPublic;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSPublicSym;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSSegMap;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSSegName;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSSrcLnSeg;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSSrcModule;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSStaticSym;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSSymbolBase;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSSymbols;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SSTypes;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SegDesc;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SegInfo;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SrcModFileDesc;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SrcModLineNumberMap;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50Subsection;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SubsectionDirectory;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SubsectionTypes;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50SymbolIterator;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50TypeEnums;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50TypeIterator;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50TypeLeafIndices;
import sun.jvm.hotspot.debugger.win32.coff.DebugVC50WrongNumericTypeException;
import sun.jvm.hotspot.debugger.win32.coff.ExportDirectoryTable;
import sun.jvm.hotspot.debugger.win32.coff.OptionalHeader;
import sun.jvm.hotspot.debugger.win32.coff.OptionalHeaderDataDirectories;
import sun.jvm.hotspot.debugger.win32.coff.OptionalHeaderStandardFields;
import sun.jvm.hotspot.debugger.win32.coff.OptionalHeaderWindowsSpecificFields;
import sun.jvm.hotspot.debugger.win32.coff.SectionHeader;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.memo.MemoizedObject;

public class COFFFileParser {
    private static COFFFileParser soleInstance;
    private static final int COFF_HEADER_SIZE = 20;
    private static final int SECTION_HEADER_SIZE = 40;
    private static final int SYMBOL_SIZE = 18;
    private static final int RELOCATION_SIZE = 10;
    private static final int LINE_NUMBER_SIZE = 6;
    private static final String US_ASCII = "US-ASCII";

    private COFFFileParser() {
    }

    public static COFFFileParser getParser() {
        if (soleInstance == null) {
            soleInstance = new COFFFileParser();
        }
        return soleInstance;
    }

    public COFFFile parse(String filename) throws COFFException {
        try {
            File file = new File(filename);
            FileInputStream stream = new FileInputStream(file);
            MappedByteBuffer buf = stream.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            return this.parse(new MappedByteBufferDataSource(buf));
        }
        catch (FileNotFoundException e) {
            throw new COFFException(e);
        }
        catch (IOException e) {
            throw new COFFException(e);
        }
    }

    public COFFFile parse(DataSource source) throws COFFException {
        return new COFFFileImpl(source);
    }

    class COFFFileImpl
    implements COFFFile {
        private DataSource file;
        private long filePos;
        private boolean isImage;
        private long imageHeaderOffset;
        private MemoizedObject header = new MemoizedObject(){

            public Object computeValue() {
                return new COFFHeaderImpl();
            }
        };

        COFFFileImpl(DataSource file) throws COFFException {
            this.file = file;
            this.initialize();
        }

        public boolean isImage() {
            return this.isImage;
        }

        public COFFHeader getHeader() {
            return (COFFHeaderImpl)this.header.getValue();
        }

        void initialize() throws COFFException {
            this.seek(60L);
            try {
                int peOffset = this.readInt();
                this.seek(peOffset);
                if (this.readByte() == 80 && this.readByte() == 69 && this.readByte() == 0 && this.readByte() == 0) {
                    this.isImage = true;
                    this.imageHeaderOffset = this.getFilePointer();
                }
            }
            catch (COFFException cOFFException) {
                // empty catch block
            }
        }

        byte readByteAt(long offset) throws COFFException {
            this.seek(offset);
            return this.readByte();
        }

        byte readByte() throws COFFException {
            try {
                return this.file.readByte();
            }
            catch (IOException e) {
                throw new COFFException(e.toString() + " at offset 0x" + Long.toHexString(this.filePos), e);
            }
        }

        int readBytesAt(long offset, byte[] b) throws COFFException {
            this.seek(offset);
            return this.readBytes(b);
        }

        int readBytes(byte[] b) throws COFFException {
            try {
                return this.file.read(b);
            }
            catch (IOException e) {
                throw new COFFException(e.toString() + " at offset 0x" + Long.toHexString(this.filePos), e);
            }
        }

        short readShortAt(long offset) throws COFFException {
            this.seek(offset);
            return this.readShort();
        }

        short readShort() throws COFFException {
            try {
                return this.byteSwap(this.file.readShort());
            }
            catch (IOException e) {
                throw new COFFException(e.toString() + " at offset 0x" + Long.toHexString(this.filePos), e);
            }
        }

        int readIntAt(long offset) throws COFFException {
            this.seek(offset);
            return this.readInt();
        }

        int readInt() throws COFFException {
            try {
                return this.byteSwap(this.file.readInt());
            }
            catch (IOException e) {
                throw new COFFException(e.toString() + " at offset 0x" + Long.toHexString(this.filePos), e);
            }
        }

        long readLongAt(long offset) throws COFFException {
            this.seek(offset);
            return this.readLong();
        }

        long readLong() throws COFFException {
            try {
                return this.byteSwap(this.file.readLong());
            }
            catch (IOException e) {
                throw new COFFException(e.toString() + " at offset 0x" + Long.toHexString(this.filePos), e);
            }
        }

        float readFloat() throws COFFException {
            int i = this.readInt();
            return Float.intBitsToFloat(i);
        }

        double readDouble() throws COFFException {
            long l = this.readLong();
            return Double.longBitsToDouble(l);
        }

        String readCString() throws COFFException {
            ArrayList<Byte> data = new ArrayList<Byte>();
            byte b = 0;
            while ((b = this.readByte()) != 0) {
                data.add(new Byte(b));
            }
            byte[] bytes = new byte[data.size()];
            for (int i = 0; i < data.size(); ++i) {
                bytes[i] = (Byte)data.get(i);
            }
            try {
                return new String(bytes, COFFFileParser.US_ASCII);
            }
            catch (UnsupportedEncodingException e) {
                throw new COFFException(e);
            }
        }

        void seek(long offset) throws COFFException {
            try {
                this.filePos = offset;
                this.file.seek(offset);
            }
            catch (IOException e) {
                throw new COFFException(e.toString() + " at offset 0x" + Long.toHexString(offset), e);
            }
        }

        long getFilePointer() throws COFFException {
            try {
                return this.file.getFilePointer();
            }
            catch (IOException e) {
                throw new COFFException(e);
            }
        }

        short byteSwap(short arg) {
            return (short)(arg << 8 | arg >>> 8 & 0xFF);
        }

        int byteSwap(int arg) {
            return this.byteSwap((short)arg) << 16 | this.byteSwap((short)(arg >>> 16)) & 0xFFFF;
        }

        long byteSwap(long arg) {
            return (long)this.byteSwap((int)arg) << 32 | (long)this.byteSwap((int)(arg >>> 32)) & 0xFFFFFFFFFFFFFFFFL;
        }

        public void close() throws COFFException {
            try {
                this.file.close();
            }
            catch (IOException e) {
                throw new COFFException(e);
            }
        }

        class COFFHeaderImpl
        implements COFFHeader {
            private short machine;
            private short numberOfSections;
            private int timeDateStamp;
            private int pointerToSymbolTable;
            private int numberOfSymbols;
            private short sizeOfOptionalHeader;
            private short characteristics;
            private MemoizedObject[] sectionHeaders;
            private MemoizedObject[] symbols;
            private MemoizedObject stringTable = new MemoizedObject(){

                public Object computeValue() {
                    int ptr = COFFHeaderImpl.this.getPointerToSymbolTable();
                    if (ptr == 0) {
                        return new StringTable(0);
                    }
                    return new StringTable(ptr + 18 * COFFHeaderImpl.this.getNumberOfSymbols());
                }
            };

            COFFHeaderImpl() {
                int i;
                COFFFileImpl.this.seek(COFFFileImpl.this.imageHeaderOffset);
                this.machine = COFFFileImpl.this.readShort();
                this.numberOfSections = COFFFileImpl.this.readShort();
                this.timeDateStamp = COFFFileImpl.this.readInt();
                this.pointerToSymbolTable = COFFFileImpl.this.readInt();
                this.numberOfSymbols = COFFFileImpl.this.readInt();
                this.sizeOfOptionalHeader = COFFFileImpl.this.readShort();
                this.characteristics = COFFFileImpl.this.readShort();
                this.sectionHeaders = new MemoizedObject[this.numberOfSections];
                for (i = 0; i < this.numberOfSections; ++i) {
                    final int secHdrOffset = (int)(COFFFileImpl.this.imageHeaderOffset + 20L + (long)this.sizeOfOptionalHeader + (long)(i * 40));
                    this.sectionHeaders[i] = new MemoizedObject(){

                        public Object computeValue() {
                            return new SectionHeaderImpl(secHdrOffset);
                        }
                    };
                }
                this.symbols = new MemoizedObject[this.numberOfSymbols];
                for (i = 0; i < this.numberOfSymbols; ++i) {
                    final int symbolOffset = this.pointerToSymbolTable + i * 18;
                    this.symbols[i] = new MemoizedObject(){

                        public Object computeValue() {
                            return new COFFSymbolImpl(symbolOffset);
                        }
                    };
                }
            }

            public short getMachineType() {
                return this.machine;
            }

            public short getNumberOfSections() {
                return this.numberOfSections;
            }

            public int getTimeDateStamp() {
                return this.timeDateStamp;
            }

            public int getPointerToSymbolTable() {
                return this.pointerToSymbolTable;
            }

            public int getNumberOfSymbols() {
                return this.numberOfSymbols;
            }

            public short getSizeOfOptionalHeader() {
                return this.sizeOfOptionalHeader;
            }

            public OptionalHeader getOptionalHeader() throws COFFException {
                if (this.getSizeOfOptionalHeader() == 0) {
                    return null;
                }
                return new OptionalHeaderImpl((int)(COFFFileImpl.this.imageHeaderOffset + 20L));
            }

            public short getCharacteristics() {
                return this.characteristics;
            }

            public boolean hasCharacteristic(short characteristic) {
                return (this.characteristics & characteristic) != 0;
            }

            public SectionHeader getSectionHeader(int index) {
                return (SectionHeader)this.sectionHeaders[index - 1].getValue();
            }

            public COFFSymbol getCOFFSymbol(int index) {
                return (COFFSymbol)this.symbols[index].getValue();
            }

            public int getNumberOfStrings() {
                return this.getStringTable().getNum();
            }

            public String getString(int i) {
                return this.getStringTable().get(i);
            }

            StringTable getStringTable() {
                return (StringTable)this.stringTable.getValue();
            }

            int rvaToFileOffset(int rva) {
                if (rva == 0) {
                    return 0;
                }
                for (int i = 1; i <= this.getNumberOfSections(); ++i) {
                    SectionHeader sec = this.getSectionHeader(i);
                    int va = sec.getVirtualAddress();
                    int sz = sec.getSize();
                    if (va > rva || rva >= va + sz) continue;
                    return sec.getPointerToRawData() + (rva - va);
                }
                throw new COFFException("Unable to find RVA 0x" + Integer.toHexString(rva) + " in any section");
            }

            class StringTable {
                COFFString[] strings;

                StringTable(int offset) {
                    if (offset == 0) {
                        this.strings = new COFFString[0];
                        return;
                    }
                    COFFFileImpl.this.seek(offset);
                    int length = COFFFileImpl.this.readInt();
                    byte[] data = new byte[length - 4];
                    int numBytesRead = COFFFileImpl.this.readBytes(data);
                    if (numBytesRead != data.length) {
                        throw new COFFException("Error reading string table (read " + numBytesRead + " bytes, expected to read " + data.length + ")");
                    }
                    int numStrings = 0;
                    int ptr = 0;
                    for (ptr = 0; ptr < data.length; ++ptr) {
                        if (data[ptr] != 0) continue;
                        ++numStrings;
                    }
                    this.strings = new COFFString[numStrings];
                    int lastPtr = 0;
                    ptr = 0;
                    for (int i = 0; i < numStrings; ++i) {
                        while (data[ptr] != 0) {
                            ++ptr;
                        }
                        try {
                            this.strings[i] = new COFFString(new String(data, lastPtr, ptr - lastPtr, COFFFileParser.US_ASCII), offset + ptr + 4);
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new COFFException(e);
                        }
                        lastPtr = ++ptr;
                    }
                }

                int getNum() {
                    return this.strings.length;
                }

                String get(int i) {
                    return this.strings[i].str;
                }

                String getAtOffset(int offset) {
                    int i = Arrays.binarySearch(this.strings, new COFFString(null, offset), new Comparator(){

                        public int compare(Object o1, Object o2) {
                            COFFString s1 = (COFFString)o1;
                            COFFString s2 = (COFFString)o2;
                            if (s1.offset == s2.offset) {
                                return 0;
                            }
                            if (s1.offset < s2.offset) {
                                return -1;
                            }
                            return 1;
                        }
                    });
                    if (i < 0) {
                        throw new COFFException("No string found at file offset " + offset);
                    }
                    return this.strings[i].str;
                }

                class COFFString {
                    String str;
                    int offset;

                    COFFString(String str, int offset) {
                        this.str = str;
                        this.offset = offset;
                    }
                }
            }

            class COFFLineNumberImpl
            implements COFFLineNumber {
                private int type;
                private short lineNumber;

                COFFLineNumberImpl(int offset) {
                    COFFFileImpl.this.seek(offset);
                    this.type = COFFFileImpl.this.readInt();
                    this.lineNumber = COFFFileImpl.this.readShort();
                }

                public int getType() {
                    return this.type;
                }

                public short getLineNumber() {
                    return this.lineNumber;
                }
            }

            class COFFRelocationImpl
            implements COFFRelocation {
                private int virtualAddress;
                private int symbolTableIndex;
                private short type;

                COFFRelocationImpl(int offset) {
                    COFFFileImpl.this.seek(offset);
                    this.virtualAddress = COFFFileImpl.this.readInt();
                    this.symbolTableIndex = COFFFileImpl.this.readInt();
                    this.type = COFFFileImpl.this.readShort();
                }

                public int getVirtualAddress() {
                    return this.virtualAddress;
                }

                public int getSymbolTableIndex() {
                    return this.symbolTableIndex;
                }

                public short getType() {
                    return this.type;
                }
            }

            class AuxSectionDefinitionsRecordImpl
            implements AuxSectionDefinitionsRecord {
                private int length;
                private short numberOfRelocations;
                private short numberOfLineNumbers;
                private int checkSum;
                private short number;
                private byte selection;

                AuxSectionDefinitionsRecordImpl(int offset) {
                    COFFFileImpl.this.seek(offset);
                    this.length = COFFFileImpl.this.readInt();
                    this.numberOfRelocations = COFFFileImpl.this.readShort();
                    this.numberOfLineNumbers = COFFFileImpl.this.readShort();
                    this.checkSum = COFFFileImpl.this.readInt();
                    this.number = COFFFileImpl.this.readShort();
                    this.selection = COFFFileImpl.this.readByte();
                }

                public int getLength() {
                    return this.length;
                }

                public short getNumberOfRelocations() {
                    return this.numberOfRelocations;
                }

                public short getNumberOfLineNumbers() {
                    return this.numberOfLineNumbers;
                }

                public int getCheckSum() {
                    return this.checkSum;
                }

                public short getNumber() {
                    return this.number;
                }

                public byte getSelection() {
                    return this.selection;
                }

                public int getType() {
                    return 4;
                }
            }

            class AuxFileRecordImpl
            implements AuxFileRecord {
                private String name;

                AuxFileRecordImpl(int offset) {
                    COFFFileImpl.this.seek(offset);
                    byte[] tmpName = new byte[18];
                    int numRead = COFFFileImpl.this.readBytes(tmpName);
                    if (numRead != 18) {
                        throw new COFFException("Error reading auxiliary file record at offset " + offset);
                    }
                    try {
                        this.name = new String(tmpName, COFFFileParser.US_ASCII);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new COFFException(e);
                    }
                }

                public String getName() {
                    return this.name;
                }

                public int getType() {
                    return 3;
                }
            }

            class AuxWeakExternalRecordImpl
            implements AuxWeakExternalRecord {
                private int tagIndex;
                private int characteristics;

                AuxWeakExternalRecordImpl(int offset) {
                    COFFFileImpl.this.seek(offset);
                    this.tagIndex = COFFFileImpl.this.readInt();
                    this.characteristics = COFFFileImpl.this.readInt();
                }

                public int getTagIndex() {
                    return this.tagIndex;
                }

                public int getCharacteristics() {
                    return this.characteristics;
                }

                public int getType() {
                    return 2;
                }
            }

            class AuxBfEfRecordImpl
            implements AuxBfEfRecord {
                private short lineNumber;
                private int pointerToNextFunction;

                AuxBfEfRecordImpl(int offset) {
                    COFFFileImpl.this.seek(offset);
                    COFFFileImpl.this.readInt();
                    this.lineNumber = COFFFileImpl.this.readShort();
                    COFFFileImpl.this.readInt();
                    COFFFileImpl.this.readShort();
                    this.pointerToNextFunction = COFFFileImpl.this.readInt();
                }

                public short getLineNumber() {
                    return this.lineNumber;
                }

                public int getPointerToNextFunction() {
                    return this.pointerToNextFunction;
                }

                public int getType() {
                    return 1;
                }
            }

            class AuxFunctionDefinitionRecordImpl
            implements AuxFunctionDefinitionRecord {
                private int tagIndex;
                private int totalSize;
                private int pointerToLineNumber;
                private int pointerToNextFunction;

                AuxFunctionDefinitionRecordImpl(int offset) {
                    COFFFileImpl.this.seek(offset);
                    this.tagIndex = COFFFileImpl.this.readInt();
                    this.totalSize = COFFFileImpl.this.readInt();
                    this.pointerToLineNumber = COFFFileImpl.this.readInt() - 1;
                    this.pointerToNextFunction = COFFFileImpl.this.readInt();
                }

                public int getTagIndex() {
                    return this.tagIndex;
                }

                public int getTotalSize() {
                    return this.totalSize;
                }

                public int getPointerToLineNumber() {
                    return this.pointerToLineNumber;
                }

                public int getPointerToNextFunction() {
                    return this.pointerToNextFunction;
                }

                public int getType() {
                    return 0;
                }
            }

            class COFFSymbolImpl
            implements COFFSymbol,
            COFFSymbolConstants {
                private int offset;
                private String name;
                private int value;
                private short sectionNumber;
                private short type;
                private byte storageClass;
                private byte numberOfAuxSymbols;
                private MemoizedObject auxFunctionDefinitionRecord = new MemoizedObject(){

                    public Object computeValue() {
                        return new AuxFunctionDefinitionRecordImpl(COFFSymbolImpl.this.offset + 18);
                    }
                };
                private MemoizedObject auxBfEfRecord = new MemoizedObject(){

                    public Object computeValue() {
                        return new AuxBfEfRecordImpl(COFFSymbolImpl.this.offset + 18);
                    }
                };
                private MemoizedObject auxWeakExternalRecord = new MemoizedObject(){

                    public Object computeValue() {
                        return new AuxWeakExternalRecordImpl(COFFSymbolImpl.this.offset + 18);
                    }
                };
                private MemoizedObject auxFileRecord = new MemoizedObject(){

                    public Object computeValue() {
                        return new AuxFileRecordImpl(COFFSymbolImpl.this.offset + 18);
                    }
                };
                private MemoizedObject auxSectionDefinitionsRecord = new MemoizedObject(){

                    public Object computeValue() {
                        return new AuxSectionDefinitionsRecordImpl(COFFSymbolImpl.this.offset + 18);
                    }
                };

                public COFFSymbolImpl(int offset) throws COFFException {
                    this.offset = offset;
                    COFFFileImpl.this.seek(offset);
                    byte[] tmpName = new byte[8];
                    int numRead = COFFFileImpl.this.readBytes(tmpName);
                    if (numRead != 8) {
                        throw new COFFException("Error reading name of symbol at offset " + offset);
                    }
                    if (tmpName[0] == 0 && tmpName[1] == 0 && tmpName[2] == 0 && tmpName[3] == 0) {
                        int stringOffset = tmpName[4] << 24 | tmpName[5] << 16 | tmpName[6] << 8 | tmpName[7];
                        this.name = COFFHeaderImpl.this.getStringTable().getAtOffset(stringOffset);
                    }
                    this.value = COFFFileImpl.this.readInt();
                    this.sectionNumber = COFFFileImpl.this.readShort();
                    this.type = COFFFileImpl.this.readShort();
                    this.storageClass = COFFFileImpl.this.readByte();
                    this.numberOfAuxSymbols = COFFFileImpl.this.readByte();
                }

                public int getOffset() {
                    return this.offset;
                }

                public String getName() {
                    return this.name;
                }

                public int getValue() {
                    return this.value;
                }

                public short getSectionNumber() {
                    return this.sectionNumber;
                }

                public short getType() {
                    return this.type;
                }

                public byte getStorageClass() {
                    return this.storageClass;
                }

                public byte getNumberOfAuxSymbols() {
                    return this.numberOfAuxSymbols;
                }

                public boolean isFunctionDefinition() {
                    return this.getStorageClass() == 2 && this.getType() >>> 8 == 2 && this.getSectionNumber() > 0;
                }

                public AuxFunctionDefinitionRecord getAuxFunctionDefinitionRecord() {
                    return (AuxFunctionDefinitionRecord)this.auxFunctionDefinitionRecord.getValue();
                }

                public boolean isBfOrEfSymbol() {
                    return (this.getName().equals(".bf") || this.getName().equals(".ef")) && this.getStorageClass() == 101;
                }

                public AuxBfEfRecord getAuxBfEfRecord() {
                    return (AuxBfEfRecord)this.auxBfEfRecord.getValue();
                }

                public boolean isWeakExternal() {
                    return this.getStorageClass() == 2 && this.getSectionNumber() == 0 && this.getValue() == 0;
                }

                public AuxWeakExternalRecord getAuxWeakExternalRecord() {
                    return (AuxWeakExternalRecord)this.auxWeakExternalRecord.getValue();
                }

                public boolean isFile() {
                    return this.getName().equals(".file") && this.getStorageClass() == 103;
                }

                public AuxFileRecord getAuxFileRecord() {
                    return (AuxFileRecord)this.auxFileRecord.getValue();
                }

                public boolean isSectionDefinition() {
                    return this.getName().charAt(0) == '.' && this.getStorageClass() == 3;
                }

                public AuxSectionDefinitionsRecord getAuxSectionDefinitionsRecord() {
                    return (AuxSectionDefinitionsRecord)this.auxSectionDefinitionsRecord.getValue();
                }
            }

            class SectionHeaderImpl
            implements SectionHeader {
                private String name;
                private int virtualSize;
                private int virtualAddress;
                private int sizeOfRawData;
                private int pointerToRawData;
                private int pointerToRelocations;
                private int pointerToLineNumbers;
                private short numberOfRelocations;
                private short numberOfLineNumbers;
                private int characteristics;
                private MemoizedObject[] relocations;
                private MemoizedObject[] lineNumbers;

                public SectionHeaderImpl(int offset) throws COFFException {
                    int i;
                    COFFFileImpl.this.seek(offset);
                    byte[] tmpName = new byte[8];
                    int numRead = COFFFileImpl.this.readBytes(tmpName);
                    if (numRead != 8) {
                        throw new COFFException("Error reading name of section header at offset " + offset);
                    }
                    if (tmpName[0] == 47) {
                        int index = 0;
                        try {
                            index = Integer.parseInt(new String(tmpName, 1, tmpName.length - 1, COFFFileParser.US_ASCII));
                        }
                        catch (NumberFormatException e) {
                            throw new COFFException("Error parsing string table index of name of section header at offset " + offset);
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new COFFException(e);
                        }
                        this.name = COFFHeaderImpl.this.getStringTable().get(index);
                    } else {
                        try {
                            int length;
                            for (length = 0; length < tmpName.length && tmpName[length] != 0; ++length) {
                            }
                            this.name = new String(tmpName, 0, length, COFFFileParser.US_ASCII);
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new COFFException(e);
                        }
                    }
                    this.virtualSize = COFFFileImpl.this.readInt();
                    this.virtualAddress = COFFFileImpl.this.readInt();
                    this.sizeOfRawData = COFFFileImpl.this.readInt();
                    this.pointerToRawData = COFFFileImpl.this.readInt();
                    this.pointerToRelocations = COFFFileImpl.this.readInt();
                    this.pointerToLineNumbers = COFFFileImpl.this.readInt();
                    this.numberOfRelocations = COFFFileImpl.this.readShort();
                    this.numberOfLineNumbers = COFFFileImpl.this.readShort();
                    this.characteristics = COFFFileImpl.this.readInt();
                    this.relocations = new MemoizedObject[this.numberOfRelocations];
                    for (i = 0; i < this.numberOfRelocations; ++i) {
                        final int relocOffset = this.pointerToRelocations + i * 10;
                        this.relocations[i] = new MemoizedObject(){

                            public Object computeValue() {
                                return new COFFRelocationImpl(relocOffset);
                            }
                        };
                    }
                    this.lineNumbers = new MemoizedObject[this.numberOfLineNumbers];
                    for (i = 0; i < this.numberOfLineNumbers; ++i) {
                        final int lineNoOffset = this.pointerToLineNumbers + i * 6;
                        this.lineNumbers[i] = new MemoizedObject(){

                            public Object computeValue() {
                                return new COFFLineNumberImpl(lineNoOffset);
                            }
                        };
                    }
                }

                public String getName() {
                    return this.name;
                }

                public int getSize() {
                    return this.virtualSize;
                }

                public int getVirtualAddress() {
                    return this.virtualAddress;
                }

                public int getSizeOfRawData() {
                    return this.sizeOfRawData;
                }

                public int getPointerToRawData() {
                    return this.pointerToRawData;
                }

                public int getPointerToRelocations() {
                    return this.pointerToRelocations;
                }

                public int getPointerToLineNumbers() {
                    return this.pointerToLineNumbers;
                }

                public short getNumberOfRelocations() {
                    return this.numberOfRelocations;
                }

                public short getNumberOfLineNumbers() {
                    return this.numberOfLineNumbers;
                }

                public int getSectionFlags() {
                    return this.characteristics;
                }

                public boolean hasSectionFlag(int flag) {
                    return (this.characteristics & flag) != 0;
                }

                public COFFRelocation getCOFFRelocation(int index) {
                    return (COFFRelocation)this.relocations[index].getValue();
                }

                public COFFLineNumber getCOFFLineNumber(int index) {
                    return (COFFLineNumber)((Object)this.lineNumbers[index]);
                }
            }

            class DebugVC50Impl
            implements DebugVC50,
            DebugVC50TypeLeafIndices {
                private int lfaBase;
                private int subsectionDirectoryOffset;
                private MemoizedObject subsectionDirectory;

                DebugVC50Impl(int offset) {
                    this.lfaBase = offset;
                    COFFFileImpl.this.seek(offset);
                    COFFFileImpl.this.readInt();
                    this.subsectionDirectoryOffset = this.globalOffset(COFFFileImpl.this.readInt());
                    this.verify();
                    this.subsectionDirectory = new MemoizedObject(){

                        public Object computeValue() {
                            return new DebugVC50SubsectionDirectoryImpl(DebugVC50Impl.this.getSubsectionDirectoryOffset());
                        }
                    };
                }

                public int getSubsectionDirectoryOffset() {
                    return this.subsectionDirectoryOffset;
                }

                public DebugVC50SubsectionDirectory getSubsectionDirectory() {
                    return (DebugVC50SubsectionDirectory)this.subsectionDirectory.getValue();
                }

                private int globalOffset(int offset) {
                    return offset + this.lfaBase;
                }

                private void verify() {
                    COFFFileImpl.this.seek(this.subsectionDirectoryOffset);
                    short headerLength = COFFFileImpl.this.readShort();
                    short entryLength = COFFFileImpl.this.readShort();
                    int numEntries = COFFFileImpl.this.readInt();
                    int endOffset = this.subsectionDirectoryOffset + headerLength + numEntries * entryLength;
                    COFFFileImpl.this.seek(endOffset);
                    if (COFFFileImpl.this.readByte() == 78 && COFFFileImpl.this.readByte() == 66 && COFFFileImpl.this.readByte() == 49 && COFFFileImpl.this.readByte() == 49) {
                        return;
                    }
                    throw new COFFException("Did not find NB11 signature at end of debug info");
                }

                private int numericLeafLengthAt(int absoluteOffset) throws DebugVC50WrongNumericTypeException {
                    COFFFileImpl.this.seek(absoluteOffset);
                    int leaf = COFFFileImpl.this.readShort() & 0xFFFF;
                    if (leaf < 32768) {
                        return 2;
                    }
                    switch (leaf) {
                        case 32768: {
                            return 3;
                        }
                        case 32769: 
                        case 32770: {
                            return 4;
                        }
                        case 32771: 
                        case 32772: {
                            return 6;
                        }
                        case 32773: {
                            return 6;
                        }
                        case 32774: {
                            return 10;
                        }
                        case 32775: {
                            return 12;
                        }
                        case 32776: {
                            return 18;
                        }
                        case 32777: 
                        case 32778: {
                            return 18;
                        }
                        case 32779: {
                            return 8;
                        }
                        case 32780: {
                            return 10;
                        }
                        case 32781: {
                            return 18;
                        }
                        case 32782: {
                            return 26;
                        }
                        case 32783: {
                            return 66;
                        }
                        case 32784: {
                            return 4 + this.readIntNumericLeafAt(absoluteOffset + 2);
                        }
                    }
                    throw new DebugVC50WrongNumericTypeException("Illegal numeric leaf index " + leaf + " at offset " + absoluteOffset);
                }

                private int readIntNumericLeafAt(int absoluteOffset) throws DebugVC50WrongNumericTypeException {
                    COFFFileImpl.this.seek(absoluteOffset);
                    int leaf = COFFFileImpl.this.readShort() & 0xFFFF;
                    if (leaf < 32768) {
                        return leaf;
                    }
                    switch (leaf) {
                        case 32768: {
                            return COFFFileImpl.this.readByte() & 0xFF;
                        }
                        case 32769: 
                        case 32770: {
                            return COFFFileImpl.this.readShort() & 0xFFFF;
                        }
                        case 32771: 
                        case 32772: {
                            return COFFFileImpl.this.readInt();
                        }
                    }
                    throw new DebugVC50WrongNumericTypeException("Illegal numeric leaf index " + leaf);
                }

                private long readLongNumericLeafAt(int absoluteOffset) throws DebugVC50WrongNumericTypeException {
                    COFFFileImpl.this.seek(absoluteOffset);
                    int leaf = COFFFileImpl.this.readShort() & 0xFFFF;
                    if (leaf < 32768) {
                        return leaf;
                    }
                    switch (leaf) {
                        case 32768: {
                            return COFFFileImpl.this.readByte() & 0xFF;
                        }
                        case 32769: 
                        case 32770: {
                            return COFFFileImpl.this.readShort() & 0xFFFF;
                        }
                        case 32771: 
                        case 32772: {
                            return COFFFileImpl.this.readInt() & 0xFFFFFFFF;
                        }
                        case 32777: 
                        case 32778: {
                            return COFFFileImpl.this.readLong();
                        }
                    }
                    throw new DebugVC50WrongNumericTypeException("Illegal numeric leaf index " + leaf);
                }

                private float readFloatNumericLeafAt(int absoluteOffset) throws DebugVC50WrongNumericTypeException {
                    COFFFileImpl.this.seek(absoluteOffset);
                    int leaf = COFFFileImpl.this.readShort() & 0xFFFF;
                    if (leaf != 32773) {
                        throw new DebugVC50WrongNumericTypeException("Illegal numeric leaf index " + leaf);
                    }
                    return COFFFileImpl.this.readFloat();
                }

                private double readDoubleNumericLeafAt(int absoluteOffset) throws DebugVC50WrongNumericTypeException {
                    COFFFileImpl.this.seek(absoluteOffset);
                    int leaf = COFFFileImpl.this.readShort() & 0xFFFF;
                    if (leaf != 32774) {
                        throw new DebugVC50WrongNumericTypeException("Illegal numeric leaf index " + leaf);
                    }
                    return COFFFileImpl.this.readDouble();
                }

                private int lengthPrefixedStringLengthAt(int absoluteOffset) {
                    COFFFileImpl.this.seek(absoluteOffset);
                    int len = COFFFileImpl.this.readByte() & 0xFF;
                    return 1 + len;
                }

                private String readLengthPrefixedStringAt(int absoluteOffset) {
                    COFFFileImpl.this.seek(absoluteOffset);
                    int len = COFFFileImpl.this.readByte() & 0xFF;
                    byte[] res = new byte[len];
                    int numRead = COFFFileImpl.this.readBytes(res);
                    if (numRead != len) {
                        throw new COFFException("Error reading length prefixed string in symbol at offset " + absoluteOffset);
                    }
                    try {
                        return new String(res, COFFFileParser.US_ASCII);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new COFFException(e);
                    }
                }

                private int unbiasTypeIndex(int index) {
                    return index - 4096;
                }

                private int biasTypeIndex(int index) {
                    return index + 4096;
                }

                class DebugVC50TypeIteratorImpl
                implements DebugVC50TypeIterator,
                DebugVC50TypeLeafIndices,
                DebugVC50MemberAttributes,
                DebugVC50TypeEnums {
                    private DebugVC50SSGlobalTypes parent;
                    private int base;
                    private int numTypes;
                    private int typeIndex;
                    private int typeRecordOffset;
                    private int typeStringOffset;
                    private int typeRecordSize;
                    private int typeStringLeaf;

                    DebugVC50TypeIteratorImpl(DebugVC50SSGlobalTypes parent, int base, int numTypes) {
                        this(parent, base, numTypes, 0, base);
                    }

                    private DebugVC50TypeIteratorImpl(DebugVC50SSGlobalTypes parent, int base, int numTypes, int curType, int offset) {
                        this.parent = parent;
                        this.base = base;
                        this.numTypes = numTypes;
                        this.typeIndex = curType;
                        if (!this.done()) {
                            this.typeRecordOffset = offset;
                            this.loadTypeRecord();
                        }
                    }

                    public boolean done() {
                        return this.typeIndex == this.numTypes;
                    }

                    public void next() throws NoSuchElementException {
                        if (this.done()) {
                            throw new NoSuchElementException();
                        }
                        ++this.typeIndex;
                        if (!this.done()) {
                            this.typeRecordOffset = this.parent.getTypeOffset(this.typeIndex);
                            this.loadTypeRecord();
                        }
                    }

                    public short getLength() {
                        return (short)this.typeRecordSize;
                    }

                    public int getTypeIndex() {
                        return DebugVC50Impl.this.biasTypeIndex(this.typeIndex);
                    }

                    public int getNumTypes() {
                        return this.numTypes;
                    }

                    public boolean typeStringDone() {
                        return this.typeStringOffset - this.typeRecordOffset - 2 >= this.typeRecordSize;
                    }

                    public void typeStringNext() throws NoSuchElementException {
                        if (this.typeStringDone()) {
                            throw new NoSuchElementException();
                        }
                        this.typeStringOffset += this.typeStringLength();
                        this.loadTypeString();
                    }

                    public int typeStringLeaf() {
                        return this.typeStringLeaf;
                    }

                    public int typeStringOffset() {
                        return this.typeStringOffset;
                    }

                    public int getModifierIndex() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readInt();
                    }

                    public short getModifierAttribute() {
                        this.typeSeek(6);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getPointerType() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getPointerAttributes() {
                        this.typeSeek(6);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getPointerBasedOnTypeIndex() {
                        this.typeSeek(10);
                        return COFFFileImpl.this.readInt();
                    }

                    public String getPointerBasedOnTypeName() {
                        return this.readLengthPrefixedStringAt(14);
                    }

                    public int getPointerToMemberClass() {
                        this.typeSeek(10);
                        return COFFFileImpl.this.readInt();
                    }

                    public short getPointerToMemberFormat() {
                        this.typeSeek(14);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getArrayElementType() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getArrayIndexType() {
                        this.typeSeek(6);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getArrayLength() throws DebugVC50WrongNumericTypeException {
                        return this.readIntNumericLeafAt(10);
                    }

                    public String getArrayName() {
                        return this.readLengthPrefixedStringAt(10 + this.numericLeafLengthAt(10));
                    }

                    public short getClassCount() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readShort();
                    }

                    public short getClassProperty() {
                        this.typeSeek(4);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getClassFieldList() {
                        this.typeSeek(6);
                        return COFFFileImpl.this.readInt();
                    }

                    public DebugVC50TypeIterator getClassFieldListIterator() {
                        int index = DebugVC50Impl.this.unbiasTypeIndex(this.getClassFieldList());
                        int offset = this.parent.getTypeOffset(index);
                        return new DebugVC50TypeIteratorImpl(this.parent, this.base, this.numTypes, index, offset);
                    }

                    public int getClassDerivationList() {
                        this.typeSeek(10);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getClassVShape() {
                        this.typeSeek(14);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getClassSize() throws DebugVC50WrongNumericTypeException {
                        return this.readIntNumericLeafAt(18);
                    }

                    public String getClassName() {
                        return this.readLengthPrefixedStringAt(18 + this.numericLeafLengthAt(18));
                    }

                    public short getUnionCount() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readShort();
                    }

                    public short getUnionProperty() {
                        this.typeSeek(4);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getUnionFieldList() {
                        this.typeSeek(6);
                        return COFFFileImpl.this.readInt();
                    }

                    public DebugVC50TypeIterator getUnionFieldListIterator() {
                        int index = DebugVC50Impl.this.unbiasTypeIndex(this.getUnionFieldList());
                        int offset = this.parent.getTypeOffset(index);
                        return new DebugVC50TypeIteratorImpl(this.parent, this.base, this.numTypes, index, offset);
                    }

                    public int getUnionSize() throws DebugVC50WrongNumericTypeException {
                        return this.readIntNumericLeafAt(10);
                    }

                    public String getUnionName() {
                        return this.readLengthPrefixedStringAt(10 + this.numericLeafLengthAt(10));
                    }

                    public short getEnumCount() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readShort();
                    }

                    public short getEnumProperty() {
                        this.typeSeek(4);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getEnumType() {
                        this.typeSeek(6);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getEnumFieldList() {
                        this.typeSeek(10);
                        return COFFFileImpl.this.readInt();
                    }

                    public DebugVC50TypeIterator getEnumFieldListIterator() {
                        int index = DebugVC50Impl.this.unbiasTypeIndex(this.getEnumFieldList());
                        int offset = this.parent.getTypeOffset(index);
                        return new DebugVC50TypeIteratorImpl(this.parent, this.base, this.numTypes, index, offset);
                    }

                    public String getEnumName() {
                        return this.readLengthPrefixedStringAt(14);
                    }

                    public int getProcedureReturnType() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readInt();
                    }

                    public byte getProcedureCallingConvention() {
                        this.typeSeek(6);
                        return COFFFileImpl.this.readByte();
                    }

                    public short getProcedureNumberOfParameters() {
                        this.typeSeek(8);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getProcedureArgumentList() {
                        this.typeSeek(10);
                        return COFFFileImpl.this.readInt();
                    }

                    public DebugVC50TypeIterator getProcedureArgumentListIterator() {
                        int index = DebugVC50Impl.this.unbiasTypeIndex(this.getProcedureArgumentList());
                        int offset = this.parent.getTypeOffset(index);
                        return new DebugVC50TypeIteratorImpl(this.parent, this.base, this.numTypes, index, offset);
                    }

                    public int getMFunctionReturnType() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getMFunctionContainingClass() {
                        this.typeSeek(6);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getMFunctionThis() {
                        this.typeSeek(10);
                        return COFFFileImpl.this.readInt();
                    }

                    public byte getMFunctionCallingConvention() {
                        this.typeSeek(14);
                        return COFFFileImpl.this.readByte();
                    }

                    public short getMFunctionNumberOfParameters() {
                        this.typeSeek(16);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getMFunctionArgumentList() {
                        this.typeSeek(18);
                        return COFFFileImpl.this.readInt();
                    }

                    public DebugVC50TypeIterator getMFunctionArgumentListIterator() {
                        int index = DebugVC50Impl.this.unbiasTypeIndex(this.getMFunctionArgumentList());
                        int offset = this.parent.getTypeOffset(index);
                        return new DebugVC50TypeIteratorImpl(this.parent, this.base, this.numTypes, index, offset);
                    }

                    public int getMFunctionThisAdjust() {
                        this.typeSeek(22);
                        return COFFFileImpl.this.readInt();
                    }

                    public short getVTShapeCount() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getVTShapeDescriptor(int i) {
                        this.typeSeek(4 + i / 2);
                        int val = COFFFileImpl.this.readByte() & 0xFF;
                        if (i % 2 != 0) {
                            val >>= 4;
                        }
                        return val;
                    }

                    public int getBasicArrayType() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readInt();
                    }

                    public short getLabelAddressMode() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getDimArrayType() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getDimArrayDimInfo() {
                        this.typeSeek(6);
                        return COFFFileImpl.this.readInt();
                    }

                    public String getDimArrayName() {
                        return this.readLengthPrefixedStringAt(10);
                    }

                    public int getVFTPathCount() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getVFTPathBase(int i) {
                        this.typeSeek(6 + 4 * i);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getSkipIndex() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getArgListCount() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getArgListType(int i) {
                        this.typeSeek(6 + 4 * i);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getDefaultArgType() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readInt();
                    }

                    public String getDefaultArgExpression() {
                        return this.readLengthPrefixedStringAt(6);
                    }

                    public int getDerivedCount() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getDerivedType(int i) {
                        this.typeSeek(6);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getBitfieldFieldType() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readInt();
                    }

                    public byte getBitfieldLength() {
                        this.typeSeek(6);
                        return COFFFileImpl.this.readByte();
                    }

                    public byte getBitfieldPosition() {
                        this.typeSeek(7);
                        return COFFFileImpl.this.readByte();
                    }

                    public short getMListAttribute() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getMListLength() {
                        return (this.getLength() - 6 - (this.isMListIntroducingVirtual() ? 4 : 0)) / 4;
                    }

                    public int getMListType(int i) {
                        this.typeSeek(6 + 4 * i);
                        return COFFFileImpl.this.readInt();
                    }

                    public boolean isMListIntroducingVirtual() {
                        return this.isIntroducingVirtual(this.getMListAttribute());
                    }

                    public int getMListVtabOffset() {
                        this.typeSeek(6 + 4 * this.getMListLength());
                        return COFFFileImpl.this.readInt();
                    }

                    public DebugVC50SymbolIterator getRefSym() {
                        this.typeSeek(2);
                        int len = COFFFileImpl.this.readShort() & 0xFFFF;
                        return new DebugVC50SymbolIteratorImpl(this.typeStringOffset + 2, len);
                    }

                    public short getBClassAttribute() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getBClassType() {
                        this.typeSeek(4);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getBClassOffset() throws DebugVC50WrongNumericTypeException {
                        return this.readIntNumericLeafAt(8);
                    }

                    public short getVBClassAttribute() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getVBClassBaseClassType() {
                        this.typeSeek(4);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getVBClassVirtualBaseClassType() {
                        this.typeSeek(8);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getVBClassVBPOff() throws DebugVC50WrongNumericTypeException {
                        return this.readIntNumericLeafAt(12);
                    }

                    public int getVBClassVBOff() throws DebugVC50WrongNumericTypeException {
                        return this.readIntNumericLeafAt(12 + this.numericLeafLengthAt(12));
                    }

                    public short getIVBClassAttribute() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getIVBClassBType() {
                        this.typeSeek(4);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getIVBClassVBPType() {
                        this.typeSeek(8);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getIVBClassVBPOff() throws DebugVC50WrongNumericTypeException {
                        return this.readIntNumericLeafAt(12);
                    }

                    public int getIVBClassVBOff() throws DebugVC50WrongNumericTypeException {
                        return this.readIntNumericLeafAt(12 + this.numericLeafLengthAt(12));
                    }

                    public short getEnumerateAttribute() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readShort();
                    }

                    public long getEnumerateValue() {
                        return this.readIntNumericLeafAt(4);
                    }

                    public String getEnumerateName() {
                        return this.readLengthPrefixedStringAt(4 + this.numericLeafLengthAt(4));
                    }

                    public int getFriendFcnType() {
                        this.typeSeek(4);
                        return COFFFileImpl.this.readInt();
                    }

                    public String getFriendFcnName() {
                        return this.readLengthPrefixedStringAt(8);
                    }

                    public int getIndexValue() {
                        this.typeSeek(4);
                        return COFFFileImpl.this.readInt();
                    }

                    public DebugVC50TypeIterator getIndexIterator() {
                        int index = DebugVC50Impl.this.unbiasTypeIndex(this.getIndexValue());
                        int offset = this.parent.getTypeOffset(index);
                        return new DebugVC50TypeIteratorImpl(this.parent, this.base, this.numTypes, index, offset);
                    }

                    public short getMemberAttribute() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getMemberType() {
                        this.typeSeek(4);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getMemberOffset() throws DebugVC50WrongNumericTypeException {
                        return this.readIntNumericLeafAt(8);
                    }

                    public String getMemberName() {
                        return this.readLengthPrefixedStringAt(8 + this.numericLeafLengthAt(8));
                    }

                    public short getStaticAttribute() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getStaticType() {
                        this.typeSeek(4);
                        return COFFFileImpl.this.readInt();
                    }

                    public String getStaticName() {
                        return this.readLengthPrefixedStringAt(8);
                    }

                    public short getMethodCount() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getMethodList() {
                        this.typeSeek(4);
                        return COFFFileImpl.this.readInt();
                    }

                    public String getMethodName() {
                        return this.readLengthPrefixedStringAt(8);
                    }

                    public int getNestedType() {
                        this.typeSeek(4);
                        return COFFFileImpl.this.readInt();
                    }

                    public String getNestedName() {
                        return this.readLengthPrefixedStringAt(8);
                    }

                    public int getVFuncTabType() {
                        this.typeSeek(4);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getFriendClsType() {
                        this.typeSeek(4);
                        return COFFFileImpl.this.readInt();
                    }

                    public short getOneMethodAttribute() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getOneMethodType() {
                        this.typeSeek(4);
                        return COFFFileImpl.this.readInt();
                    }

                    public boolean isOneMethodIntroducingVirtual() {
                        return this.isIntroducingVirtual(this.getOneMethodAttribute());
                    }

                    public int getOneMethodVBaseOff() {
                        this.typeSeek(8);
                        return COFFFileImpl.this.readInt();
                    }

                    public String getOneMethodName() {
                        int baseLen = 8 + (this.isOneMethodIntroducingVirtual() ? 4 : 0);
                        return this.readLengthPrefixedStringAt(baseLen);
                    }

                    public int getVFuncOffType() {
                        this.typeSeek(4);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getVFuncOffOffset() {
                        this.typeSeek(8);
                        return COFFFileImpl.this.readInt();
                    }

                    public short getNestedExAttribute() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getNestedExType() {
                        this.typeSeek(4);
                        return COFFFileImpl.this.readInt();
                    }

                    public String getNestedExName() {
                        return this.readLengthPrefixedStringAt(8);
                    }

                    public short getMemberModifyAttribute() {
                        this.typeSeek(2);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getMemberModifyType() {
                        this.typeSeek(4);
                        return COFFFileImpl.this.readInt();
                    }

                    public String getMemberModifyName() {
                        return this.readLengthPrefixedStringAt(8);
                    }

                    public short getNumericTypeAt(int byteOffset) {
                        this.typeSeek(byteOffset);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getNumericLengthAt(int byteOffset) throws DebugVC50WrongNumericTypeException {
                        return this.numericLeafLengthAt(byteOffset);
                    }

                    public int getNumericIntAt(int byteOffset) throws DebugVC50WrongNumericTypeException {
                        return this.readIntNumericLeafAt(byteOffset);
                    }

                    public long getNumericLongAt(int byteOffset) throws DebugVC50WrongNumericTypeException {
                        throw new RuntimeException("Unimplemented");
                    }

                    public float getNumericFloatAt(int byteOffset) throws DebugVC50WrongNumericTypeException {
                        throw new RuntimeException("Unimplemented");
                    }

                    public double getNumericDoubleAt(int byteOffset) throws DebugVC50WrongNumericTypeException {
                        throw new RuntimeException("Unimplemented");
                    }

                    public byte[] getNumericDataAt(int byteOffset) throws DebugVC50WrongNumericTypeException {
                        throw new RuntimeException("Unimplemented");
                    }

                    private void loadTypeRecord() {
                        COFFFileImpl.this.seek(this.typeRecordOffset);
                        this.typeRecordSize = COFFFileImpl.this.readShort() & 0xFFFF;
                        this.typeStringOffset = this.typeRecordOffset + 2;
                        this.loadTypeString();
                    }

                    private void loadTypeString() {
                        COFFFileImpl.this.seek(this.typeStringOffset);
                        int lo = COFFFileImpl.this.readByte() & 0xFF;
                        if (lo >= 240) {
                            this.typeStringLeaf = lo;
                        } else {
                            int hi = COFFFileImpl.this.readByte() & 0xFF;
                            this.typeStringLeaf = hi << 8 | lo;
                        }
                    }

                    private void typeSeek(int offset) {
                        COFFFileImpl.this.seek(this.typeStringOffset + offset);
                    }

                    private int typeStringLength() {
                        if (this.typeStringLeaf >= 240 && this.typeStringLeaf <= 255) {
                            return this.typeStringLeaf - 240;
                        }
                        switch (this.typeStringLeaf) {
                            case 4097: {
                                return 8;
                            }
                            case 4098: {
                                int extraLen = 0;
                                int attr = (this.getPointerAttributes() & 0x1F) >> 0;
                                int mode = (this.getPointerAttributes() & 0xE0) >> 5;
                                if (attr == 8) {
                                    extraLen = 4 + this.numericLeafLengthAt(this.typeStringOffset + 14);
                                } else if (mode == 2 || mode == 3) {
                                    extraLen = 6;
                                }
                                return 10 + extraLen;
                            }
                            case 4099: {
                                int temp = 10 + this.numericLeafLengthAt(10);
                                return temp + this.lengthPrefixedStringLengthAt(temp);
                            }
                            case 4100: 
                            case 4101: {
                                int temp = 18 + this.numericLeafLengthAt(18);
                                return temp + this.lengthPrefixedStringLengthAt(temp);
                            }
                            case 4102: {
                                int temp = 10 + this.numericLeafLengthAt(10);
                                return temp + this.lengthPrefixedStringLengthAt(temp);
                            }
                            case 4103: {
                                return 14 + this.lengthPrefixedStringLengthAt(14);
                            }
                            case 4104: {
                                return 14;
                            }
                            case 4105: {
                                return 26;
                            }
                            case 10: {
                                return 4 + (this.getVTShapeCount() + 1) / 2;
                            }
                            case 12: 
                            case 4106: {
                                throw new COFFException("COBOL symbols unimplemented");
                            }
                            case 4107: {
                                return 6;
                            }
                            case 14: {
                                return 4;
                            }
                            case 15: {
                                return 2;
                            }
                            case 16: {
                                return 2;
                            }
                            case 4108: {
                                return 10 + this.lengthPrefixedStringLengthAt(10);
                            }
                            case 4109: {
                                return 6 + 4 * this.getVFTPathCount();
                            }
                            case 4110: {
                                return 14 + this.lengthPrefixedStringLengthAt(14);
                            }
                            case 20: {
                                return 6;
                            }
                            case 4111: {
                                throw new COFFException("OEM symbols unimplemented");
                            }
                            case 22: {
                                return 10 + this.lengthPrefixedStringLengthAt(10);
                            }
                            case 4608: {
                                return 6 + this.numericLeafLengthAt(6);
                            }
                            case 4609: {
                                return 6 + 4 * this.getArgListCount();
                            }
                            case 4610: {
                                return 6 + this.lengthPrefixedStringLengthAt(6);
                            }
                            case 4611: {
                                return 2;
                            }
                            case 4612: {
                                return 6 + 4 * this.getDerivedCount();
                            }
                            case 4613: {
                                return 8;
                            }
                            case 4614: {
                                return 6 + 4 * this.getMListLength() + (this.isMListIntroducingVirtual() ? 4 : 0);
                            }
                            case 4615: 
                            case 4616: 
                            case 4617: 
                            case 4618: {
                                throw new COFFException("LF_DIMCONU, LF_DIMCONLU, LF_DIMVARU, and LF_DIMVARLU unsupported");
                            }
                            case 524: {
                                COFFFileImpl.this.seek(this.typeStringOffset + 2);
                                return 4 + COFFFileImpl.this.readShort();
                            }
                            case 5120: {
                                return 8 + this.numericLeafLengthAt(8);
                            }
                            case 5121: 
                            case 5122: {
                                int temp = 12 + this.numericLeafLengthAt(12);
                                return temp + this.numericLeafLengthAt(temp);
                            }
                            case 1027: {
                                int temp = 4 + this.numericLeafLengthAt(4);
                                return temp + this.lengthPrefixedStringLengthAt(temp);
                            }
                            case 5123: {
                                return 8 + this.lengthPrefixedStringLengthAt(8);
                            }
                            case 5124: {
                                return 8;
                            }
                            case 5125: {
                                int temp = 8 + this.numericLeafLengthAt(8);
                                return temp + this.lengthPrefixedStringLengthAt(temp);
                            }
                            case 5126: {
                                return 8 + this.lengthPrefixedStringLengthAt(8);
                            }
                            case 5127: {
                                return 8 + this.lengthPrefixedStringLengthAt(8);
                            }
                            case 5128: {
                                return 8 + this.lengthPrefixedStringLengthAt(8);
                            }
                            case 5129: {
                                return 8;
                            }
                            case 5130: {
                                return 8;
                            }
                            case 5131: {
                                int baseLen = 8 + (this.isOneMethodIntroducingVirtual() ? 4 : 0);
                                return baseLen + this.lengthPrefixedStringLengthAt(baseLen);
                            }
                            case 5132: {
                                return 12;
                            }
                            case 5133: {
                                return 8 + this.lengthPrefixedStringLengthAt(8);
                            }
                            case 5134: {
                                return 8 + this.lengthPrefixedStringLengthAt(8);
                            }
                            case 32768: 
                            case 32769: 
                            case 32770: 
                            case 32771: 
                            case 32772: 
                            case 32773: 
                            case 32774: 
                            case 32775: 
                            case 32776: 
                            case 32777: 
                            case 32778: 
                            case 32779: 
                            case 32780: 
                            case 32781: 
                            case 32782: 
                            case 32783: 
                            case 32784: {
                                throw new RuntimeException("Unexpected numeric leaf " + this.typeStringLeaf + "in type string");
                            }
                        }
                        throw new COFFException("Unrecognized leaf " + this.typeStringLeaf + " in type string at offset " + this.typeStringOffset);
                    }

                    private boolean isIntroducingVirtual(int mprop) {
                        int masked = mprop & 0x1C;
                        return masked == 16 || masked == 24;
                    }

                    private int numericLeafLengthAt(int offset) {
                        return DebugVC50Impl.this.numericLeafLengthAt(this.typeStringOffset + offset);
                    }

                    private int readIntNumericLeafAt(int offset) {
                        return DebugVC50Impl.this.readIntNumericLeafAt(this.typeStringOffset + offset);
                    }

                    private int lengthPrefixedStringLengthAt(int offset) {
                        return DebugVC50Impl.this.lengthPrefixedStringLengthAt(this.typeStringOffset + offset);
                    }

                    private String readLengthPrefixedStringAt(int offset) {
                        return DebugVC50Impl.this.readLengthPrefixedStringAt(this.typeStringOffset + offset);
                    }
                }

                class DebugVC50SymbolIteratorImpl
                implements DebugVC50SymbolIterator {
                    private int base;
                    private int size;
                    private int pos;
                    private int curSymSize;
                    private int curSymType;
                    private static final int HEADER_SIZE = 4;

                    DebugVC50SymbolIteratorImpl(int base, int size) {
                        this(base, size, base);
                    }

                    private DebugVC50SymbolIteratorImpl(int base, int size, int pos) {
                        this.base = base;
                        this.size = size;
                        this.pos = pos;
                        COFFFileImpl.this.seek(pos);
                        this.curSymSize = COFFFileImpl.this.readShort() & 0xFFFF;
                        this.curSymType = COFFFileImpl.this.readShort() & 0xFFFF;
                    }

                    public boolean done() {
                        return this.pos == this.base + this.size;
                    }

                    public void next() throws NoSuchElementException {
                        if (this.done()) {
                            throw new NoSuchElementException("No more symbols");
                        }
                        this.pos += this.curSymSize + 2;
                        COFFFileImpl.this.seek(this.pos);
                        this.curSymSize = COFFFileImpl.this.readShort() & 0xFFFF;
                        this.curSymType = COFFFileImpl.this.readShort() & 0xFFFF;
                    }

                    public short getLength() {
                        return (short)this.curSymSize;
                    }

                    public int getType() {
                        return this.curSymType;
                    }

                    public int getOffset() {
                        return this.pos + 4;
                    }

                    public byte getCompilerTargetProcessor() {
                        this.symSeek(0);
                        return COFFFileImpl.this.readByte();
                    }

                    public int getCompilerFlags() {
                        this.symSeek(1);
                        int res = 0;
                        for (int i = 0; i < 3; ++i) {
                            int b = COFFFileImpl.this.readByte() & 0xFF;
                            res = res << 8 | b;
                        }
                        return res;
                    }

                    public String getComplierVersion() {
                        return this.readLengthPrefixedStringAt(4);
                    }

                    public int getRegisterSymbolType() {
                        this.symSeek(0);
                        return COFFFileImpl.this.readInt();
                    }

                    public short getRegisterEnum() {
                        this.symSeek(4);
                        return COFFFileImpl.this.readShort();
                    }

                    public String getRegisterSymbolName() {
                        return this.readLengthPrefixedStringAt(6);
                    }

                    public int getConstantType() {
                        this.symSeek(0);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getConstantValueAsInt() throws DebugVC50WrongNumericTypeException {
                        return this.readIntNumericLeafAt(4);
                    }

                    public long getConstantValueAsLong() throws DebugVC50WrongNumericTypeException {
                        return this.readLongNumericLeafAt(4);
                    }

                    public float getConstantValueAsFloat() throws DebugVC50WrongNumericTypeException {
                        return this.readFloatNumericLeafAt(4);
                    }

                    public double getConstantValueAsDouble() throws DebugVC50WrongNumericTypeException {
                        return this.readDoubleNumericLeafAt(4);
                    }

                    public String getConstantName() {
                        return this.readLengthPrefixedStringAt(4 + this.numericLeafLengthAt(4));
                    }

                    public int getUDTType() {
                        this.symSeek(0);
                        return COFFFileImpl.this.readInt();
                    }

                    public String getUDTName() {
                        return this.readLengthPrefixedStringAt(4);
                    }

                    public int getSearchSymbolOffset() {
                        this.symSeek(0);
                        return COFFFileImpl.this.readInt();
                    }

                    public short getSearchSegment() {
                        this.symSeek(4);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getObjectCodeViewSignature() {
                        this.symSeek(0);
                        return COFFFileImpl.this.readInt();
                    }

                    public String getObjectName() {
                        return this.readLengthPrefixedStringAt(4);
                    }

                    public int getManyRegType() {
                        this.symSeek(0);
                        return COFFFileImpl.this.readInt();
                    }

                    public byte getManyRegCount() {
                        this.symSeek(4);
                        return COFFFileImpl.this.readByte();
                    }

                    public byte getManyRegRegister(int i) {
                        this.symSeek(5 + i);
                        return COFFFileImpl.this.readByte();
                    }

                    public String getManyRegName() {
                        return this.readLengthPrefixedStringAt(5 + this.getManyRegCount());
                    }

                    public short getReturnFlags() {
                        this.symSeek(0);
                        return COFFFileImpl.this.readShort();
                    }

                    public byte getReturnStyle() {
                        this.symSeek(2);
                        return COFFFileImpl.this.readByte();
                    }

                    public byte getReturnRegisterCount() {
                        this.symSeek(3);
                        return COFFFileImpl.this.readByte();
                    }

                    public byte getReturnRegister(int i) {
                        this.symSeek(4 + i);
                        return COFFFileImpl.this.readByte();
                    }

                    public void advanceToEntryThisSymbol() {
                        COFFFileImpl.this.seek(this.pos + 4);
                        short tmpSymSize = COFFFileImpl.this.readShort();
                        short tmpSymType = COFFFileImpl.this.readShort();
                        if (Assert.ASSERTS_ENABLED) {
                            Assert.that(this.pos + this.curSymSize + 2 == this.pos + 4 + tmpSymSize, "advanceToEntryThisSymbol needs more work");
                        }
                        this.pos += 4;
                        this.curSymSize = tmpSymSize;
                        this.curSymType = tmpSymType;
                    }

                    public int getBPRelOffset() {
                        this.symSeek(0);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getBPRelType() {
                        this.symSeek(4);
                        return COFFFileImpl.this.readInt();
                    }

                    public String getBPRelName() {
                        return this.readLengthPrefixedStringAt(8);
                    }

                    public int getLGDataType() {
                        this.symSeek(0);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getLGDataOffset() {
                        this.symSeek(4);
                        return COFFFileImpl.this.readInt();
                    }

                    public short getLGDataSegment() {
                        this.symSeek(8);
                        return COFFFileImpl.this.readShort();
                    }

                    public String getLGDataName() {
                        return this.readLengthPrefixedStringAt(10);
                    }

                    public DebugVC50SymbolIterator getLGProcParent() {
                        int offs = this.getLGProcParentOffset();
                        if (offs == 0) {
                            return null;
                        }
                        return new DebugVC50SymbolIteratorImpl(this.base, this.size, offs);
                    }

                    public int getLGProcParentOffset() {
                        this.symSeek(0);
                        int offs = COFFFileImpl.this.readInt();
                        if (offs == 0) {
                            return 0;
                        }
                        return this.base + offs;
                    }

                    public DebugVC50SymbolIterator getLGProcEnd() {
                        int offs = this.getLGProcEndOffset();
                        return new DebugVC50SymbolIteratorImpl(this.base, this.size, offs);
                    }

                    public int getLGProcEndOffset() {
                        this.symSeek(4);
                        int offs = COFFFileImpl.this.readInt();
                        if (Assert.ASSERTS_ENABLED) {
                            Assert.that(offs != 0, "should not have null end offset for procedure symbols");
                        }
                        return this.base + offs;
                    }

                    public DebugVC50SymbolIterator getLGProcNext() {
                        int offs = this.getLGProcNextOffset();
                        if (offs == 0) {
                            return null;
                        }
                        return new DebugVC50SymbolIteratorImpl(this.base, this.size, offs);
                    }

                    public int getLGProcNextOffset() {
                        this.symSeek(8);
                        int offs = COFFFileImpl.this.readInt();
                        if (offs == 0) {
                            return 0;
                        }
                        return this.base + offs;
                    }

                    public int getLGProcLength() {
                        this.symSeek(12);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getLGProcDebugStart() {
                        this.symSeek(16);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getLGProcDebugEnd() {
                        this.symSeek(20);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getLGProcType() {
                        this.symSeek(24);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getLGProcOffset() {
                        this.symSeek(28);
                        return COFFFileImpl.this.readInt();
                    }

                    public short getLGProcSegment() {
                        this.symSeek(32);
                        return COFFFileImpl.this.readShort();
                    }

                    public byte getLGProcFlags() {
                        this.symSeek(34);
                        return COFFFileImpl.this.readByte();
                    }

                    public String getLGProcName() {
                        return this.readLengthPrefixedStringAt(35);
                    }

                    public DebugVC50SymbolIterator getThunkParent() {
                        int offs = this.getThunkParentOffset();
                        if (offs == 0) {
                            return null;
                        }
                        return new DebugVC50SymbolIteratorImpl(this.base, this.size, offs);
                    }

                    public int getThunkParentOffset() {
                        this.symSeek(0);
                        int offs = COFFFileImpl.this.readInt();
                        if (offs == 0) {
                            return 0;
                        }
                        return this.base + offs;
                    }

                    public DebugVC50SymbolIterator getThunkEnd() {
                        this.symSeek(4);
                        int offs = COFFFileImpl.this.readInt();
                        return new DebugVC50SymbolIteratorImpl(this.base, this.size, offs);
                    }

                    public int getThunkEndOffset() {
                        this.symSeek(4);
                        int offs = COFFFileImpl.this.readInt();
                        if (Assert.ASSERTS_ENABLED) {
                            Assert.that(offs != 0, "should not have null end offset for thunk symbols");
                        }
                        return this.base + offs;
                    }

                    public DebugVC50SymbolIterator getThunkNext() {
                        int offs = this.getThunkNextOffset();
                        if (offs == 0) {
                            return null;
                        }
                        return new DebugVC50SymbolIteratorImpl(this.base, this.size, this.base + offs);
                    }

                    public int getThunkNextOffset() {
                        this.symSeek(8);
                        int offs = COFFFileImpl.this.readInt();
                        if (offs == 0) {
                            return 0;
                        }
                        return this.base + offs;
                    }

                    public int getThunkOffset() {
                        this.symSeek(12);
                        return COFFFileImpl.this.readInt();
                    }

                    public short getThunkSegment() {
                        this.symSeek(16);
                        return COFFFileImpl.this.readShort();
                    }

                    public short getThunkLength() {
                        this.symSeek(18);
                        return COFFFileImpl.this.readShort();
                    }

                    public byte getThunkType() {
                        this.symSeek(20);
                        return COFFFileImpl.this.readByte();
                    }

                    public String getThunkName() {
                        return this.readLengthPrefixedStringAt(21);
                    }

                    public short getThunkAdjustorThisDelta() {
                        this.symSeek(21 + this.lengthPrefixedStringLengthAt(21));
                        return COFFFileImpl.this.readShort();
                    }

                    public String getThunkAdjustorTargetName() {
                        return this.readLengthPrefixedStringAt(23 + this.lengthPrefixedStringLengthAt(21));
                    }

                    public short getThunkVCallDisplacement() {
                        this.symSeek(21 + this.lengthPrefixedStringLengthAt(21));
                        return COFFFileImpl.this.readShort();
                    }

                    public int getThunkPCodeOffset() {
                        this.symSeek(21 + this.lengthPrefixedStringLengthAt(21));
                        return COFFFileImpl.this.readInt();
                    }

                    public short getThunkPCodeSegment() {
                        this.symSeek(25 + this.lengthPrefixedStringLengthAt(21));
                        return COFFFileImpl.this.readShort();
                    }

                    public DebugVC50SymbolIterator getBlockParent() {
                        int offs = this.getBlockParentOffset();
                        if (offs == 0) {
                            return null;
                        }
                        return new DebugVC50SymbolIteratorImpl(this.base, this.size, offs);
                    }

                    public int getBlockParentOffset() {
                        this.symSeek(0);
                        int offs = COFFFileImpl.this.readInt();
                        if (offs == 0) {
                            return 0;
                        }
                        return this.base + offs;
                    }

                    public DebugVC50SymbolIterator getBlockEnd() {
                        this.symSeek(4);
                        int offs = COFFFileImpl.this.readInt();
                        return new DebugVC50SymbolIteratorImpl(this.base, this.size, offs);
                    }

                    public int getBlockEndOffset() {
                        this.symSeek(4);
                        int offs = COFFFileImpl.this.readInt();
                        if (Assert.ASSERTS_ENABLED) {
                            Assert.that(offs != 0, "should not have null end offset for block symbols");
                        }
                        return this.base + offs;
                    }

                    public int getBlockLength() {
                        this.symSeek(8);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getBlockOffset() {
                        this.symSeek(12);
                        return COFFFileImpl.this.readInt();
                    }

                    public short getBlockSegment() {
                        this.symSeek(16);
                        return COFFFileImpl.this.readShort();
                    }

                    public String getBlockName() {
                        return this.readLengthPrefixedStringAt(18);
                    }

                    public int getLabelOffset() {
                        this.symSeek(0);
                        return COFFFileImpl.this.readInt();
                    }

                    public short getLabelSegment() {
                        this.symSeek(4);
                        return COFFFileImpl.this.readShort();
                    }

                    public byte getLabelFlags() {
                        this.symSeek(6);
                        return COFFFileImpl.this.readByte();
                    }

                    public String getLabelName() {
                        return this.readLengthPrefixedStringAt(7);
                    }

                    public int getChangeOffset() {
                        this.symSeek(0);
                        return COFFFileImpl.this.readInt();
                    }

                    public short getChangeSegment() {
                        this.symSeek(4);
                        return COFFFileImpl.this.readShort();
                    }

                    public short getChangeModel() {
                        this.symSeek(6);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getVTableRoot() {
                        this.symSeek(0);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getVTablePath() {
                        this.symSeek(4);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getVTableOffset() {
                        this.symSeek(8);
                        return COFFFileImpl.this.readInt();
                    }

                    public short getVTableSegment() {
                        this.symSeek(12);
                        return COFFFileImpl.this.readShort();
                    }

                    public int getRegRelOffset() {
                        this.symSeek(0);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getRegRelType() {
                        this.symSeek(4);
                        return COFFFileImpl.this.readInt();
                    }

                    public short getRegRelRegister() {
                        this.symSeek(8);
                        return COFFFileImpl.this.readShort();
                    }

                    public String getRegRelName() {
                        return this.readLengthPrefixedStringAt(10);
                    }

                    public int getLThreadType() {
                        this.symSeek(0);
                        return COFFFileImpl.this.readInt();
                    }

                    public int getLThreadOffset() {
                        this.symSeek(4);
                        return COFFFileImpl.this.readInt();
                    }

                    public short getLThreadSegment() {
                        this.symSeek(8);
                        return COFFFileImpl.this.readShort();
                    }

                    public String getLThreadName() {
                        return this.readLengthPrefixedStringAt(10);
                    }

                    private void symSeek(int offsetInSym) {
                        COFFFileImpl.this.seek(this.pos + 4 + offsetInSym);
                    }

                    private int numericLeafLengthAt(int offsetInSym) {
                        return DebugVC50Impl.this.numericLeafLengthAt(this.pos + 4 + offsetInSym);
                    }

                    private int readIntNumericLeafAt(int offsetInSym) {
                        return DebugVC50Impl.this.readIntNumericLeafAt(this.pos + 4 + offsetInSym);
                    }

                    private long readLongNumericLeafAt(int offsetInSym) {
                        return DebugVC50Impl.this.readLongNumericLeafAt(this.pos + 4 + offsetInSym);
                    }

                    private float readFloatNumericLeafAt(int offsetInSym) {
                        return DebugVC50Impl.this.readFloatNumericLeafAt(this.pos + 4 + offsetInSym);
                    }

                    private double readDoubleNumericLeafAt(int offsetInSym) {
                        return DebugVC50Impl.this.readDoubleNumericLeafAt(this.pos + 4 + offsetInSym);
                    }

                    private int lengthPrefixedStringLengthAt(int offsetInSym) {
                        return DebugVC50Impl.this.lengthPrefixedStringLengthAt(this.pos + 4 + offsetInSym);
                    }

                    private String readLengthPrefixedStringAt(int offsetInSym) {
                        return DebugVC50Impl.this.readLengthPrefixedStringAt(this.pos + 4 + offsetInSym);
                    }
                }

                class DebugVC50SSStaticSymImpl
                extends DebugVC50SSSymbolBaseImpl
                implements DebugVC50SSStaticSym {
                    DebugVC50SSStaticSymImpl(short ssType, short iMod, int ssSize, int offset) {
                        super(ssType, iMod, ssSize, offset);
                    }
                }

                class DebugVC50SSFileIndexImpl
                extends DebugVC50SubsectionImpl
                implements DebugVC50SSFileIndex {
                    private int offset;
                    private short cMod;
                    private short cRef;
                    private MemoizedObject modStart;
                    private MemoizedObject cRefCnt;
                    private MemoizedObject nameRef;
                    private MemoizedObject names;

                    DebugVC50SSFileIndexImpl(short ssType, short iMod, int ssSize, final int offset) {
                        super(ssType, iMod, ssSize, offset);
                        this.offset = offset;
                        COFFFileImpl.this.seek(offset);
                        this.cMod = COFFFileImpl.this.readShort();
                        this.cRef = COFFFileImpl.this.readShort();
                        this.modStart = new MemoizedObject(){

                            public Object computeValue() {
                                short[] vals = new short[DebugVC50SSFileIndexImpl.this.cMod];
                                COFFFileImpl.this.seek(4 + offset);
                                for (int i = 0; i < DebugVC50SSFileIndexImpl.this.cMod; ++i) {
                                    vals[i] = COFFFileImpl.this.readShort();
                                }
                                return vals;
                            }
                        };
                        this.cRefCnt = new MemoizedObject(){

                            public Object computeValue() {
                                short[] vals = new short[DebugVC50SSFileIndexImpl.this.cMod];
                                COFFFileImpl.this.seek(4 + offset + 2 * DebugVC50SSFileIndexImpl.this.cMod);
                                for (int i = 0; i < DebugVC50SSFileIndexImpl.this.cMod; ++i) {
                                    vals[i] = COFFFileImpl.this.readShort();
                                }
                                return vals;
                            }
                        };
                        this.nameRef = new MemoizedObject(){

                            public Object computeValue() {
                                int[] vals = new int[DebugVC50SSFileIndexImpl.this.cRef];
                                COFFFileImpl.this.seek(4 + offset + 4 * DebugVC50SSFileIndexImpl.this.cMod);
                                for (int i = 0; i < DebugVC50SSFileIndexImpl.this.cMod; ++i) {
                                    vals[i] = COFFFileImpl.this.readInt();
                                }
                                return vals;
                            }
                        };
                        this.names = new MemoizedObject(){

                            public Object computeValue() {
                                String[] vals = new String[DebugVC50SSFileIndexImpl.this.cRef];
                                for (int i = 0; i < DebugVC50SSFileIndexImpl.this.cRef; ++i) {
                                    vals[i] = COFFFileImpl.this.readCString();
                                }
                                return vals;
                            }
                        };
                    }

                    public short getNumModules() {
                        return this.cMod;
                    }

                    public short getNumReferences() {
                        return this.cRef;
                    }

                    public short[] getModStart() {
                        return (short[])this.modStart.getValue();
                    }

                    public short[] getRefCount() {
                        return (short[])this.cRefCnt.getValue();
                    }

                    public int[] getNameRef() {
                        return (int[])this.nameRef.getValue();
                    }

                    public String[] getNames() {
                        return (String[])this.names.getValue();
                    }
                }

                class DebugVC50SSOffsetMap32Impl
                extends DebugVC50SubsectionImpl
                implements DebugVC50SSOffsetMap32 {
                    DebugVC50SSOffsetMap32Impl(short ssType, short iMod, int ssSize, int offset) {
                        super(ssType, iMod, ssSize, offset);
                    }
                }

                class DebugVC50SSOffsetMap16Impl
                extends DebugVC50SubsectionImpl
                implements DebugVC50SSOffsetMap16 {
                    DebugVC50SSOffsetMap16Impl(short ssType, short iMod, int ssSize, int offset) {
                        super(ssType, iMod, ssSize, offset);
                    }
                }

                class DebugVC50SSPreCompImpl
                extends DebugVC50SubsectionImpl
                implements DebugVC50SSPreComp {
                    DebugVC50SSPreCompImpl(short ssType, short iMod, int ssSize, int offset) {
                        super(ssType, iMod, ssSize, offset);
                    }
                }

                class DebugVC50SSSegNameImpl
                extends DebugVC50SubsectionImpl
                implements DebugVC50SSSegName {
                    private int offset;
                    private int size;
                    private MemoizedObject names;

                    DebugVC50SSSegNameImpl(short ssType, short iMod, int ssSize, int offset) {
                        super(ssType, iMod, ssSize, offset);
                        this.offset = offset;
                        this.size = ssSize;
                        COFFFileImpl.this.seek(offset);
                        this.names = new MemoizedObject(){

                            public Object computeValue() {
                                String s;
                                ArrayList<String> data = new ArrayList<String>();
                                for (int i = 0; i < DebugVC50SSSegNameImpl.this.size; i += s.length()) {
                                    s = COFFFileImpl.this.readCString();
                                    data.add(s);
                                }
                                String[] res = new String[data.size()];
                                res = data.toArray(res);
                                return res;
                            }
                        };
                    }

                    public String getSegName(int i) {
                        return ((String[])this.names.getValue())[i];
                    }
                }

                class DebugVC50SegDescImpl
                implements DebugVC50SegDesc {
                    private short flags;
                    private short ovl;
                    private short group;
                    private short frame;
                    private short iSegName;
                    private short iClassName;
                    private int offset;
                    private int cbSeg;

                    DebugVC50SegDescImpl(int offset) {
                        COFFFileImpl.this.seek(offset);
                        this.flags = COFFFileImpl.this.readShort();
                        this.ovl = COFFFileImpl.this.readShort();
                        this.group = COFFFileImpl.this.readShort();
                        this.frame = COFFFileImpl.this.readShort();
                        this.iSegName = COFFFileImpl.this.readShort();
                        this.iClassName = COFFFileImpl.this.readShort();
                        offset = COFFFileImpl.this.readInt();
                        this.cbSeg = COFFFileImpl.this.readInt();
                    }

                    public short getFlags() {
                        return this.flags;
                    }

                    public short getOverlayNum() {
                        return this.ovl;
                    }

                    public short getGroup() {
                        return this.group;
                    }

                    public short getFrame() {
                        return this.frame;
                    }

                    public short getName() {
                        return this.iSegName;
                    }

                    public short getClassName() {
                        return this.iClassName;
                    }

                    public int getOffset() {
                        return this.offset;
                    }

                    public int getSize() {
                        return this.cbSeg;
                    }
                }

                class DebugVC50SSSegMapImpl
                extends DebugVC50SubsectionImpl
                implements DebugVC50SSSegMap {
                    private short cSeg;
                    private short cSegLog;
                    private MemoizedObject segDescs;

                    DebugVC50SSSegMapImpl(short ssType, short iMod, int ssSize, final int offset) {
                        super(ssType, iMod, ssSize, offset);
                        COFFFileImpl.this.seek(offset);
                        this.cSeg = COFFFileImpl.this.readShort();
                        this.cSegLog = COFFFileImpl.this.readShort();
                        this.segDescs = new MemoizedObject(){

                            public Object computeValue() {
                                DebugVC50SegDesc[] descs = new DebugVC50SegDesc[DebugVC50SSSegMapImpl.this.cSeg];
                                for (int i = 0; i < DebugVC50SSSegMapImpl.this.cSeg; ++i) {
                                    descs[i] = new DebugVC50SegDescImpl(offset + 4 + 20 * i);
                                }
                                return descs;
                            }
                        };
                    }

                    public short getNumSegDesc() {
                        return this.cSeg;
                    }

                    public short getNumLogicalSegDesc() {
                        return this.cSegLog;
                    }

                    public DebugVC50SegDesc getSegDesc(int i) {
                        return ((DebugVC50SegDesc[])this.segDescs.getValue())[i];
                    }
                }

                class DebugVC50SSMPCImpl
                extends DebugVC50SubsectionImpl
                implements DebugVC50SSMPC {
                    DebugVC50SSMPCImpl(short ssType, short iMod, int ssSize, int offset) {
                        super(ssType, iMod, ssSize, offset);
                    }
                }

                class DebugVC50SSGlobalTypesImpl
                extends DebugVC50SubsectionImpl
                implements DebugVC50SSGlobalTypes {
                    private int offset;
                    private int cType;

                    DebugVC50SSGlobalTypesImpl(short ssType, short iMod, int ssSize, int offset) {
                        super(ssType, iMod, ssSize, offset);
                        this.offset = offset;
                        COFFFileImpl.this.seek(offset);
                        COFFFileImpl.this.readInt();
                        this.cType = COFFFileImpl.this.readInt();
                    }

                    public int getNumTypes() {
                        return this.cType;
                    }

                    public int getTypeOffset(int i) {
                        COFFFileImpl.this.seek(this.offset + 4 * (i + 2));
                        return COFFFileImpl.this.readInt() + this.offsetOfFirstType();
                    }

                    public DebugVC50TypeIterator getTypeIterator() {
                        return new DebugVC50TypeIteratorImpl(this, this.offsetOfFirstType(), this.cType);
                    }

                    private int offsetOfFirstType() {
                        return this.offset + 4 * (this.getNumTypes() + 2);
                    }
                }

                class DebugVC50SSGlobalPubImpl
                extends DebugVC50SSSymbolBaseImpl
                implements DebugVC50SSGlobalPub {
                    DebugVC50SSGlobalPubImpl(short ssType, short iMod, int ssSize, int offset) {
                        super(ssType, iMod, ssSize, offset);
                    }
                }

                class DebugVC50SSGlobalSymImpl
                extends DebugVC50SSSymbolBaseImpl
                implements DebugVC50SSGlobalSym {
                    DebugVC50SSGlobalSymImpl(short ssType, short iMod, int ssSize, int offset) {
                        super(ssType, iMod, ssSize, offset);
                    }
                }

                class DebugVC50SSSymbolBaseImpl
                extends DebugVC50SubsectionImpl
                implements DebugVC50SSSymbolBase {
                    private int offset;
                    private short symHash;
                    private short addrHash;
                    private int cbSymbol;
                    private int cbSymHash;
                    private int cbAddrHash;
                    private static final int HEADER_SIZE = 16;

                    DebugVC50SSSymbolBaseImpl(short ssType, short iMod, int ssSize, int offset) {
                        super(ssType, iMod, ssSize, offset);
                        this.offset = offset;
                        COFFFileImpl.this.seek(offset);
                        this.symHash = COFFFileImpl.this.readShort();
                        this.addrHash = COFFFileImpl.this.readShort();
                        this.cbSymbol = COFFFileImpl.this.readInt();
                        this.cbSymHash = COFFFileImpl.this.readInt();
                        this.cbAddrHash = COFFFileImpl.this.readInt();
                    }

                    public short getSymHashIndex() {
                        return this.symHash;
                    }

                    public short getAddrHashIndex() {
                        return this.addrHash;
                    }

                    public int getSymTabSize() {
                        return this.cbSymbol;
                    }

                    public int getSymHashSize() {
                        return this.cbSymHash;
                    }

                    public int getAddrHashSize() {
                        return this.cbAddrHash;
                    }

                    public DebugVC50SymbolIterator getSymbolIterator() {
                        return new DebugVC50SymbolIteratorImpl(this.offset + 16, this.cbSymbol);
                    }
                }

                class DebugVC50SSLibrariesImpl
                extends DebugVC50SubsectionImpl
                implements DebugVC50SSLibraries {
                    DebugVC50SSLibrariesImpl(short ssType, short iMod, int ssSize, int offset) {
                        super(ssType, iMod, ssSize, offset);
                    }
                }

                class DebugVC50SrcModLineNumberMapImpl
                implements DebugVC50SrcModLineNumberMap {
                    private short seg;
                    private short cPair;
                    private MemoizedObject offsets;
                    private MemoizedObject lineNumbers;

                    DebugVC50SrcModLineNumberMapImpl(final int offset) {
                        COFFFileImpl.this.seek(offset);
                        this.seg = COFFFileImpl.this.readShort();
                        this.cPair = COFFFileImpl.this.readShort();
                        this.offsets = new MemoizedObject(){

                            public Object computeValue() {
                                COFFFileImpl.this.seek(offset + 4);
                                int[] res = new int[DebugVC50SrcModLineNumberMapImpl.this.getNumSourceLinePairs()];
                                for (int i = 0; i < DebugVC50SrcModLineNumberMapImpl.this.getNumSourceLinePairs(); ++i) {
                                    res[i] = COFFFileImpl.this.readInt();
                                }
                                return res;
                            }
                        };
                        this.lineNumbers = new MemoizedObject(){

                            public Object computeValue() {
                                COFFFileImpl.this.seek(offset + 4 * (DebugVC50SrcModLineNumberMapImpl.this.getNumSourceLinePairs() + 1));
                                short[] res = new short[DebugVC50SrcModLineNumberMapImpl.this.getNumSourceLinePairs()];
                                for (int i = 0; i < DebugVC50SrcModLineNumberMapImpl.this.getNumSourceLinePairs(); ++i) {
                                    res[i] = COFFFileImpl.this.readShort();
                                }
                                return res;
                            }
                        };
                    }

                    public int getSegment() {
                        return this.seg;
                    }

                    public int getNumSourceLinePairs() {
                        return this.cPair;
                    }

                    public int getCodeOffset(int i) {
                        return ((int[])this.offsets.getValue())[i];
                    }

                    public int getLineNumber(int i) {
                        return ((short[])this.lineNumbers.getValue())[i] & 0xFFFF;
                    }
                }

                class DebugVC50SrcModFileDescImpl
                implements DebugVC50SrcModFileDesc {
                    private short cSeg;
                    private MemoizedObject baseSrcLn;
                    private MemoizedObject segOffsets;
                    private MemoizedObject name;

                    DebugVC50SrcModFileDescImpl(final int offset, final int baseOffset) {
                        COFFFileImpl.this.seek(offset);
                        this.cSeg = COFFFileImpl.this.readShort();
                        this.baseSrcLn = new MemoizedObject(){

                            public Object computeValue() {
                                COFFFileImpl.this.seek(offset + 4);
                                int[] offsets = new int[DebugVC50SrcModFileDescImpl.this.getNumCodeSegments()];
                                for (int i = 0; i < DebugVC50SrcModFileDescImpl.this.getNumCodeSegments(); ++i) {
                                    offsets[i] = baseOffset + COFFFileImpl.this.readInt();
                                }
                                DebugVC50SrcModLineNumberMapImpl[] res = new DebugVC50SrcModLineNumberMapImpl[DebugVC50SrcModFileDescImpl.this.getNumCodeSegments()];
                                for (int i = 0; i < DebugVC50SrcModFileDescImpl.this.getNumCodeSegments(); ++i) {
                                    res[i] = new DebugVC50SrcModLineNumberMapImpl(offsets[i]);
                                }
                                return res;
                            }
                        };
                        this.segOffsets = new MemoizedObject(){

                            public Object computeValue() {
                                COFFFileImpl.this.seek(offset + 4 * (DebugVC50SrcModFileDescImpl.this.getNumCodeSegments() + 1));
                                int[] res = new int[2 * DebugVC50SrcModFileDescImpl.this.getNumCodeSegments()];
                                for (int i = 0; i < 2 * DebugVC50SrcModFileDescImpl.this.getNumCodeSegments(); ++i) {
                                    res[i] = COFFFileImpl.this.readInt();
                                }
                                return res;
                            }
                        };
                        this.name = new MemoizedObject(){

                            public Object computeValue() {
                                COFFFileImpl.this.seek(offset + 4 + 12 * DebugVC50SrcModFileDescImpl.this.getNumCodeSegments());
                                int cbName = COFFFileImpl.this.readByte() & 0xFF;
                                byte[] res = new byte[cbName];
                                COFFFileImpl.this.readBytes(res);
                                try {
                                    return new String(res, COFFFileParser.US_ASCII);
                                }
                                catch (UnsupportedEncodingException e) {
                                    throw new COFFException(e);
                                }
                            }
                        };
                    }

                    public int getNumCodeSegments() {
                        return this.cSeg & 0xFFFF;
                    }

                    public DebugVC50SrcModLineNumberMap getLineNumberMap(int i) {
                        return ((DebugVC50SrcModLineNumberMapImpl[])this.baseSrcLn.getValue())[i];
                    }

                    public int getSegmentStartOffset(int i) {
                        return ((int[])this.segOffsets.getValue())[2 * i];
                    }

                    public int getSegmentEndOffset(int i) {
                        return ((int[])this.segOffsets.getValue())[2 * i + 1];
                    }

                    public String getSourceFileName() {
                        return (String)this.name.getValue();
                    }
                }

                class DebugVC50SSSrcModuleImpl
                extends DebugVC50SubsectionImpl
                implements DebugVC50SSSrcModule {
                    private int offset;
                    private short cFile;
                    private short cSeg;
                    private MemoizedObject baseSrcFiles;
                    private MemoizedObject segOffsets;
                    private MemoizedObject segs;

                    DebugVC50SSSrcModuleImpl(short ssType, short iMod, int ssSize, final int offset) {
                        super(ssType, iMod, ssSize, offset);
                        this.offset = offset;
                        COFFFileImpl.this.seek(offset);
                        this.cFile = COFFFileImpl.this.readShort();
                        this.cSeg = COFFFileImpl.this.readShort();
                        this.baseSrcFiles = new MemoizedObject(){

                            public Object computeValue() {
                                int[] offsets = new int[DebugVC50SSSrcModuleImpl.this.getNumSourceFiles()];
                                COFFFileImpl.this.seek(offset + 4);
                                for (int i = 0; i < DebugVC50SSSrcModuleImpl.this.getNumSourceFiles(); ++i) {
                                    offsets[i] = offset + COFFFileImpl.this.readInt();
                                }
                                DebugVC50SrcModFileDescImpl[] res = new DebugVC50SrcModFileDescImpl[offsets.length];
                                for (int i = 0; i < res.length; ++i) {
                                    res[i] = new DebugVC50SrcModFileDescImpl(offsets[i], offset);
                                }
                                return res;
                            }
                        };
                        this.segOffsets = new MemoizedObject(){

                            public Object computeValue() {
                                COFFFileImpl.this.seek(offset + 4 * (DebugVC50SSSrcModuleImpl.this.getNumSourceFiles() + 1));
                                int[] res = new int[2 * DebugVC50SSSrcModuleImpl.this.getNumCodeSegments()];
                                for (int i = 0; i < 2 * DebugVC50SSSrcModuleImpl.this.getNumCodeSegments(); ++i) {
                                    res[i] = COFFFileImpl.this.readInt();
                                }
                                return res;
                            }
                        };
                        this.segs = new MemoizedObject(){

                            public Object computeValue() {
                                COFFFileImpl.this.seek(offset + 4 * (DebugVC50SSSrcModuleImpl.this.getNumSourceFiles() + 1) + 8 * DebugVC50SSSrcModuleImpl.this.getNumCodeSegments());
                                short[] res = new short[DebugVC50SSSrcModuleImpl.this.getNumCodeSegments()];
                                for (int i = 0; i < DebugVC50SSSrcModuleImpl.this.getNumCodeSegments(); ++i) {
                                    res[i] = COFFFileImpl.this.readShort();
                                }
                                return res;
                            }
                        };
                    }

                    public int getNumSourceFiles() {
                        return this.cFile & 0xFFFF;
                    }

                    public int getNumCodeSegments() {
                        return this.cSeg & 0xFFFF;
                    }

                    public DebugVC50SrcModFileDesc getSourceFileDesc(int i) {
                        return ((DebugVC50SrcModFileDescImpl[])this.baseSrcFiles.getValue())[i];
                    }

                    public int getSegmentStartOffset(int i) {
                        return ((int[])this.segOffsets.getValue())[2 * i];
                    }

                    public int getSegmentEndOffset(int i) {
                        return ((int[])this.segOffsets.getValue())[2 * i + 1];
                    }

                    public int getSegment(int i) {
                        return ((short[])this.segs.getValue())[i] & 0xFFFF;
                    }
                }

                class DebugVC50SSSrcLnSegImpl
                extends DebugVC50SubsectionImpl
                implements DebugVC50SSSrcLnSeg {
                    DebugVC50SSSrcLnSegImpl(short ssType, short iMod, int ssSize, int offset) {
                        super(ssType, iMod, ssSize, offset);
                    }
                }

                class DebugVC50SSAlignSymImpl
                extends DebugVC50SubsectionImpl
                implements DebugVC50SSAlignSym {
                    private int offset;

                    DebugVC50SSAlignSymImpl(short ssType, short iMod, int ssSize, int offset) {
                        super(ssType, iMod, ssSize, offset);
                        this.offset = offset;
                    }

                    public DebugVC50SymbolIterator getSymbolIterator() {
                        return new DebugVC50SymbolIteratorImpl(this.offset, this.getSubsectionSize());
                    }
                }

                class DebugVC50SSSymbolsImpl
                extends DebugVC50SubsectionImpl
                implements DebugVC50SSSymbols {
                    DebugVC50SSSymbolsImpl(short ssType, short iMod, int ssSize, int offset) {
                        super(ssType, iMod, ssSize, offset);
                    }
                }

                class DebugVC50SSPublicSymImpl
                extends DebugVC50SubsectionImpl
                implements DebugVC50SSPublicSym {
                    DebugVC50SSPublicSymImpl(short ssType, short iMod, int ssSize, int offset) {
                        super(ssType, iMod, ssSize, offset);
                    }
                }

                class DebugVC50SSPublicImpl
                extends DebugVC50SubsectionImpl
                implements DebugVC50SSPublic {
                    DebugVC50SSPublicImpl(short ssType, short iMod, int ssSize, int offset) {
                        super(ssType, iMod, ssSize, offset);
                    }
                }

                class DebugVC50SSTypesImpl
                extends DebugVC50SubsectionImpl
                implements DebugVC50SSTypes {
                    DebugVC50SSTypesImpl(short ssType, short iMod, int ssSize, int offset) {
                        super(ssType, iMod, ssSize, offset);
                    }
                }

                class DebugVC50SegInfoImpl
                implements DebugVC50SegInfo {
                    private short seg;
                    private int offset;
                    private int cbSeg;

                    DebugVC50SegInfoImpl(int offset) {
                        COFFFileImpl.this.seek(offset);
                        this.seg = COFFFileImpl.this.readShort();
                        COFFFileImpl.this.readShort();
                        offset = COFFFileImpl.this.readInt();
                        this.cbSeg = COFFFileImpl.this.readInt();
                    }

                    public short getSegment() {
                        return this.seg;
                    }

                    public int getOffset() {
                        return this.offset;
                    }

                    public int getSegmentCodeSize() {
                        return this.cbSeg;
                    }
                }

                class DebugVC50SSModuleImpl
                extends DebugVC50SubsectionImpl
                implements DebugVC50SSModule {
                    private int offset;
                    private short ovlNumber;
                    private short iLib;
                    private short cSeg;
                    private short style;
                    private MemoizedObject segInfo;
                    private MemoizedObject name;
                    private static final int HEADER_SIZE = 8;
                    private static final int SEG_INFO_SIZE = 12;

                    DebugVC50SSModuleImpl(short ssType, short iMod, int ssSize, final int offset) {
                        super(ssType, iMod, ssSize, offset);
                        this.offset = offset;
                        COFFFileImpl.this.seek(offset);
                        this.ovlNumber = COFFFileImpl.this.readShort();
                        this.iLib = COFFFileImpl.this.readShort();
                        this.cSeg = COFFFileImpl.this.readShort();
                        this.style = COFFFileImpl.this.readShort();
                        this.segInfo = new MemoizedObject(){

                            public Object computeValue() {
                                int base = offset + 8;
                                DebugVC50SegInfo[] res = new DebugVC50SegInfo[DebugVC50SSModuleImpl.this.cSeg];
                                for (int i = 0; i < DebugVC50SSModuleImpl.this.cSeg; ++i) {
                                    res[i] = new DebugVC50SegInfoImpl(base);
                                    base += 12;
                                }
                                return res;
                            }
                        };
                        this.name = new MemoizedObject(){

                            public Object computeValue() {
                                return DebugVC50Impl.this.readLengthPrefixedStringAt(offset + (8 + DebugVC50SSModuleImpl.this.cSeg * 12));
                            }
                        };
                    }

                    public short getOverlayNumber() {
                        return this.ovlNumber;
                    }

                    public short getLibrariesIndex() {
                        return this.iLib;
                    }

                    public short getNumCodeSegments() {
                        return this.cSeg;
                    }

                    public short getDebuggingStyle() {
                        return this.style;
                    }

                    public DebugVC50SegInfo getSegInfo(int i) {
                        return ((DebugVC50SegInfo[])this.segInfo.getValue())[i];
                    }

                    public String getName() {
                        return (String)this.name.getValue();
                    }
                }

                class DebugVC50SubsectionImpl
                implements DebugVC50Subsection {
                    private short ssType;
                    private short iMod;
                    private int ssSize;

                    DebugVC50SubsectionImpl(short ssType, short iMod, int ssSize, int offset) {
                        this.ssType = ssType;
                        this.iMod = iMod;
                        this.ssSize = ssSize;
                    }

                    public short getSubsectionType() {
                        return this.ssType;
                    }

                    public short getSubsectionModuleIndex() {
                        return this.iMod;
                    }

                    public int getSubsectionSize() {
                        return this.ssSize;
                    }
                }

                class DebugVC50SubsectionDirectoryImpl
                implements DebugVC50SubsectionDirectory,
                DebugVC50SubsectionTypes {
                    private int offset;
                    private short dirHeaderLength;
                    private short dirEntryLength;
                    private int numEntries;

                    DebugVC50SubsectionDirectoryImpl(int offset) {
                        this.offset = offset;
                        COFFFileImpl.this.seek(offset);
                        this.dirHeaderLength = COFFFileImpl.this.readShort();
                        this.dirEntryLength = COFFFileImpl.this.readShort();
                        this.numEntries = COFFFileImpl.this.readInt();
                    }

                    public short getHeaderLength() {
                        return this.dirHeaderLength;
                    }

                    public short getEntryLength() {
                        return this.dirEntryLength;
                    }

                    public int getNumEntries() {
                        return this.numEntries;
                    }

                    public DebugVC50Subsection getSubsection(int i) {
                        COFFFileImpl.this.seek(this.offset + this.dirHeaderLength + i * this.dirEntryLength);
                        short ssType = COFFFileImpl.this.readShort();
                        short iMod = COFFFileImpl.this.readShort();
                        int lfo = DebugVC50Impl.this.globalOffset(COFFFileImpl.this.readInt());
                        int cb = COFFFileImpl.this.readInt();
                        switch (ssType) {
                            case 288: {
                                return new DebugVC50SSModuleImpl(ssType, iMod, cb, lfo);
                            }
                            case 289: {
                                return new DebugVC50SSTypesImpl(ssType, iMod, cb, lfo);
                            }
                            case 290: {
                                return new DebugVC50SSPublicImpl(ssType, iMod, cb, lfo);
                            }
                            case 291: {
                                return new DebugVC50SSPublicSymImpl(ssType, iMod, cb, lfo);
                            }
                            case 292: {
                                return new DebugVC50SSSymbolsImpl(ssType, iMod, cb, lfo);
                            }
                            case 293: {
                                return new DebugVC50SSAlignSymImpl(ssType, iMod, cb, lfo);
                            }
                            case 294: {
                                return new DebugVC50SSSrcLnSegImpl(ssType, iMod, cb, lfo);
                            }
                            case 295: {
                                return new DebugVC50SSSrcModuleImpl(ssType, iMod, cb, lfo);
                            }
                            case 296: {
                                return new DebugVC50SSLibrariesImpl(ssType, iMod, cb, lfo);
                            }
                            case 297: {
                                return new DebugVC50SSGlobalSymImpl(ssType, iMod, cb, lfo);
                            }
                            case 298: {
                                return new DebugVC50SSGlobalPubImpl(ssType, iMod, cb, lfo);
                            }
                            case 299: {
                                return new DebugVC50SSGlobalTypesImpl(ssType, iMod, cb, lfo);
                            }
                            case 300: {
                                return new DebugVC50SSMPCImpl(ssType, iMod, cb, lfo);
                            }
                            case 301: {
                                return new DebugVC50SSSegMapImpl(ssType, iMod, cb, lfo);
                            }
                            case 302: {
                                return new DebugVC50SSSegNameImpl(ssType, iMod, cb, lfo);
                            }
                            case 303: {
                                return new DebugVC50SSPreCompImpl(ssType, iMod, cb, lfo);
                            }
                            case 304: {
                                return null;
                            }
                            case 305: {
                                return new DebugVC50SSOffsetMap16Impl(ssType, iMod, cb, lfo);
                            }
                            case 306: {
                                return new DebugVC50SSOffsetMap32Impl(ssType, iMod, cb, lfo);
                            }
                            case 307: {
                                return new DebugVC50SSFileIndexImpl(ssType, iMod, cb, lfo);
                            }
                            case 308: {
                                return new DebugVC50SSStaticSymImpl(ssType, iMod, cb, lfo);
                            }
                        }
                        throw new COFFException("Unknown section type " + ssType);
                    }
                }
            }

            class DebugDirectoryEntryImpl
            implements DebugDirectoryEntry,
            DebugTypes {
                private int characteristics;
                private int timeDateStamp;
                private short majorVersion;
                private short minorVersion;
                private int type;
                private int sizeOfData;
                private int addressOfRawData;
                private int pointerToRawData;

                DebugDirectoryEntryImpl(int offset) {
                    COFFFileImpl.this.seek(offset);
                    this.characteristics = COFFFileImpl.this.readInt();
                    this.timeDateStamp = COFFFileImpl.this.readInt();
                    this.majorVersion = COFFFileImpl.this.readShort();
                    this.minorVersion = COFFFileImpl.this.readShort();
                    this.type = COFFFileImpl.this.readInt();
                    this.sizeOfData = COFFFileImpl.this.readInt();
                    this.addressOfRawData = COFFFileImpl.this.readInt();
                    this.pointerToRawData = COFFFileImpl.this.readInt();
                }

                public int getCharacteristics() {
                    return this.characteristics;
                }

                public int getTimeDateStamp() {
                    return this.timeDateStamp;
                }

                public short getMajorVersion() {
                    return this.majorVersion;
                }

                public short getMinorVersion() {
                    return this.minorVersion;
                }

                public int getType() {
                    return this.type;
                }

                public int getSizeOfData() {
                    return this.sizeOfData;
                }

                public int getAddressOfRawData() {
                    return this.addressOfRawData;
                }

                public int getPointerToRawData() {
                    return this.pointerToRawData;
                }

                public DebugVC50 getDebugVC50() {
                    try {
                        if (this.getType() != 2) {
                            return null;
                        }
                        int offset = this.getPointerToRawData();
                        COFFFileImpl.this.seek(offset);
                        if (COFFFileImpl.this.readByte() == 78 && COFFFileImpl.this.readByte() == 66 && COFFFileImpl.this.readByte() == 49 && COFFFileImpl.this.readByte() == 49) {
                            return new DebugVC50Impl(offset);
                        }
                    }
                    catch (COFFException e) {
                        e.printStackTrace();
                    }
                    return null;
                }

                public byte getRawDataByte(int i) {
                    if (i < 0 || i >= this.getSizeOfData()) {
                        throw new IndexOutOfBoundsException();
                    }
                    COFFFileImpl.this.seek(this.getPointerToRawData() + i);
                    return COFFFileImpl.this.readByte();
                }
            }

            class DebugDirectoryImpl
            implements DebugDirectory {
                private int offset;
                private int size;
                private int numEntries;
                private static final int DEBUG_DIRECTORY_ENTRY_SIZE = 28;

                DebugDirectoryImpl(int offset, int size) {
                    this.offset = offset;
                    this.size = size;
                    if (size % 28 != 0) {
                        throw new COFFException("Corrupt DebugDirectory at offset 0x" + Integer.toHexString(offset));
                    }
                    this.numEntries = size / 28;
                }

                public int getNumEntries() {
                    return this.numEntries;
                }

                public DebugDirectoryEntry getEntry(int i) {
                    if (i < 0 || i >= this.getNumEntries()) {
                        throw new IndexOutOfBoundsException();
                    }
                    return new DebugDirectoryEntryImpl(this.offset + i * 28);
                }
            }

            class ExportNameTable {
                private MemoizedObject[] names;

                ExportNameTable(final int[] exportNamePointerTable) {
                    this.names = new MemoizedObject[exportNamePointerTable.length];
                    int i = 0;
                    while (i < exportNamePointerTable.length) {
                        final int idx = i++;
                        this.names[idx] = new MemoizedObject(){

                            public Object computeValue() {
                                COFFFileImpl.this.seek(exportNamePointerTable[idx]);
                                return COFFFileImpl.this.readCString();
                            }
                        };
                    }
                }

                String get(int i) {
                    return (String)this.names[i].getValue();
                }
            }

            class ExportDirectoryTableImpl
            implements ExportDirectoryTable {
                private int exportDataDirRVA;
                private int offset;
                private int size;
                private int exportFlags;
                private int timeDateStamp;
                private short majorVersion;
                private short minorVersion;
                private int nameRVA;
                private int ordinalBase;
                private int addressTableEntries;
                private int numberOfNamePointers;
                private int exportAddressTableRVA;
                private int namePointerTableRVA;
                private int ordinalTableRVA;
                private MemoizedObject dllName;
                private MemoizedObject exportNameTable;
                private MemoizedObject exportNamePointerTable;
                private MemoizedObject exportOrdinalTable;
                private MemoizedObject exportAddressTable;

                ExportDirectoryTableImpl(int exportDataDirRVA, int size) {
                    this.exportDataDirRVA = exportDataDirRVA;
                    this.offset = COFFHeaderImpl.this.rvaToFileOffset(exportDataDirRVA);
                    this.size = size;
                    COFFFileImpl.this.seek(this.offset);
                    this.exportFlags = COFFFileImpl.this.readInt();
                    this.timeDateStamp = COFFFileImpl.this.readInt();
                    this.majorVersion = COFFFileImpl.this.readShort();
                    this.minorVersion = COFFFileImpl.this.readShort();
                    this.nameRVA = COFFFileImpl.this.readInt();
                    this.ordinalBase = COFFFileImpl.this.readInt();
                    this.addressTableEntries = COFFFileImpl.this.readInt();
                    this.numberOfNamePointers = COFFFileImpl.this.readInt();
                    this.exportAddressTableRVA = COFFFileImpl.this.readInt();
                    this.namePointerTableRVA = COFFFileImpl.this.readInt();
                    this.ordinalTableRVA = COFFFileImpl.this.readInt();
                    this.dllName = new MemoizedObject(){

                        public Object computeValue() {
                            COFFFileImpl.this.seek(COFFHeaderImpl.this.rvaToFileOffset(ExportDirectoryTableImpl.this.getNameRVA()));
                            return COFFFileImpl.this.readCString();
                        }
                    };
                    this.exportNamePointerTable = new MemoizedObject(){

                        public Object computeValue() {
                            int i;
                            int[] pointers = new int[ExportDirectoryTableImpl.this.getNumberOfNamePointers()];
                            COFFFileImpl.this.seek(COFFHeaderImpl.this.rvaToFileOffset(ExportDirectoryTableImpl.this.getNamePointerTableRVA()));
                            for (i = 0; i < pointers.length; ++i) {
                                pointers[i] = COFFFileImpl.this.readInt();
                            }
                            for (i = 0; i < pointers.length; ++i) {
                                pointers[i] = COFFHeaderImpl.this.rvaToFileOffset(pointers[i]);
                            }
                            return pointers;
                        }
                    };
                    this.exportNameTable = new MemoizedObject(){

                        public Object computeValue() {
                            return new ExportNameTable(ExportDirectoryTableImpl.this.getExportNamePointerTable());
                        }
                    };
                    this.exportOrdinalTable = new MemoizedObject(){

                        public Object computeValue() {
                            short[] ordinals = new short[ExportDirectoryTableImpl.this.getNumberOfNamePointers()];
                            COFFFileImpl.this.seek(COFFHeaderImpl.this.rvaToFileOffset(ExportDirectoryTableImpl.this.getOrdinalTableRVA()));
                            for (int i = 0; i < ordinals.length; ++i) {
                                ordinals[i] = COFFFileImpl.this.readShort();
                            }
                            return ordinals;
                        }
                    };
                    this.exportAddressTable = new MemoizedObject(){

                        public Object computeValue() {
                            int[] addresses = new int[ExportDirectoryTableImpl.this.getNumberOfAddressTableEntries()];
                            COFFFileImpl.this.seek(COFFHeaderImpl.this.rvaToFileOffset(ExportDirectoryTableImpl.this.getExportAddressTableRVA()));
                            for (int i = 0; i < addresses.length; ++i) {
                                addresses[i] = COFFFileImpl.this.readInt();
                            }
                            return addresses;
                        }
                    };
                }

                public int getExportFlags() {
                    return this.exportFlags;
                }

                public int getTimeDateStamp() {
                    return this.timeDateStamp;
                }

                public short getMajorVersion() {
                    return this.majorVersion;
                }

                public short getMinorVersion() {
                    return this.minorVersion;
                }

                public int getNameRVA() {
                    return this.nameRVA;
                }

                public String getDLLName() {
                    return (String)this.dllName.getValue();
                }

                public int getOrdinalBase() {
                    return this.ordinalBase;
                }

                public int getNumberOfAddressTableEntries() {
                    return this.addressTableEntries;
                }

                public int getNumberOfNamePointers() {
                    return this.numberOfNamePointers;
                }

                public int getExportAddressTableRVA() {
                    return this.exportAddressTableRVA;
                }

                public int getNamePointerTableRVA() {
                    return this.namePointerTableRVA;
                }

                public int getOrdinalTableRVA() {
                    return this.ordinalTableRVA;
                }

                public String getExportName(int i) {
                    return this.getExportNameTable().get(i);
                }

                public short getExportOrdinal(int i) {
                    return this.getExportOrdinalTable()[i];
                }

                public boolean isExportAddressForwarder(short ordinal) {
                    int addr = this.getExportAddress(ordinal);
                    return this.exportDataDirRVA <= addr && addr < this.exportDataDirRVA + this.size;
                }

                public String getExportAddressForwarder(short ordinal) {
                    COFFFileImpl.this.seek(COFFHeaderImpl.this.rvaToFileOffset(this.getExportAddress(ordinal)));
                    return COFFFileImpl.this.readCString();
                }

                public int getExportAddress(short ordinal) {
                    return this.getExportAddressTable()[ordinal];
                }

                private ExportNameTable getExportNameTable() {
                    return (ExportNameTable)this.exportNameTable.getValue();
                }

                private int[] getExportNamePointerTable() {
                    return (int[])this.exportNamePointerTable.getValue();
                }

                private short[] getExportOrdinalTable() {
                    return (short[])this.exportOrdinalTable.getValue();
                }

                private int[] getExportAddressTable() {
                    return (int[])this.exportAddressTable.getValue();
                }
            }

            class DataDirectoryImpl
            implements DataDirectory {
                int rva;
                int size;

                DataDirectoryImpl(int offset) {
                    COFFFileImpl.this.seek(offset);
                    this.rva = COFFFileImpl.this.readInt();
                    this.size = COFFFileImpl.this.readInt();
                }

                public int getRVA() {
                    return this.rva;
                }

                public int getSize() {
                    return this.size;
                }
            }

            class OptionalHeaderDataDirectoriesImpl
            implements OptionalHeaderDataDirectories {
                private int numberOfRvaAndSizes;
                private MemoizedObject[] dataDirectories;
                private MemoizedObject exportDirectoryTable;
                private MemoizedObject debugDirectory;
                private static final int DATA_DIRECTORY_SIZE = 8;

                OptionalHeaderDataDirectoriesImpl(int offset, int numberOfRvaAndSizes) {
                    this.numberOfRvaAndSizes = numberOfRvaAndSizes;
                    this.dataDirectories = new MemoizedObject[numberOfRvaAndSizes];
                    for (int i = 0; i < numberOfRvaAndSizes; ++i) {
                        final int dirOffset = offset + i * 8;
                        this.dataDirectories[i] = new MemoizedObject(){

                            public Object computeValue() {
                                return new DataDirectoryImpl(dirOffset);
                            }
                        };
                    }
                    this.exportDirectoryTable = new MemoizedObject(){

                        public Object computeValue() {
                            DataDirectory dir = OptionalHeaderDataDirectoriesImpl.this.getExportTable();
                            if (dir.getRVA() == 0 || dir.getSize() == 0) {
                                return null;
                            }
                            return new ExportDirectoryTableImpl(dir.getRVA(), dir.getSize());
                        }
                    };
                    this.debugDirectory = new MemoizedObject(){

                        public Object computeValue() {
                            DataDirectory dir = OptionalHeaderDataDirectoriesImpl.this.getDebug();
                            if (dir.getRVA() == 0 || dir.getSize() == 0) {
                                return null;
                            }
                            return new DebugDirectoryImpl(COFFHeaderImpl.this.rvaToFileOffset(dir.getRVA()), dir.getSize());
                        }
                    };
                }

                public DataDirectory getExportTable() throws COFFException {
                    return (DataDirectory)this.dataDirectories[this.checkIndex(0)].getValue();
                }

                public DataDirectory getImportTable() throws COFFException {
                    return (DataDirectory)this.dataDirectories[this.checkIndex(1)].getValue();
                }

                public DataDirectory getResourceTable() throws COFFException {
                    return (DataDirectory)this.dataDirectories[this.checkIndex(2)].getValue();
                }

                public DataDirectory getExceptionTable() throws COFFException {
                    return (DataDirectory)this.dataDirectories[this.checkIndex(3)].getValue();
                }

                public DataDirectory getCertificateTable() throws COFFException {
                    return (DataDirectory)this.dataDirectories[this.checkIndex(4)].getValue();
                }

                public DataDirectory getBaseRelocationTable() throws COFFException {
                    return (DataDirectory)this.dataDirectories[this.checkIndex(5)].getValue();
                }

                public DataDirectory getDebug() throws COFFException {
                    return (DataDirectory)this.dataDirectories[this.checkIndex(6)].getValue();
                }

                public DataDirectory getArchitecture() throws COFFException {
                    return (DataDirectory)this.dataDirectories[this.checkIndex(7)].getValue();
                }

                public DataDirectory getGlobalPtr() throws COFFException {
                    return (DataDirectory)this.dataDirectories[this.checkIndex(8)].getValue();
                }

                public DataDirectory getTLSTable() throws COFFException {
                    return (DataDirectory)this.dataDirectories[this.checkIndex(9)].getValue();
                }

                public DataDirectory getLoadConfigTable() throws COFFException {
                    return (DataDirectory)this.dataDirectories[this.checkIndex(10)].getValue();
                }

                public DataDirectory getBoundImportTable() throws COFFException {
                    return (DataDirectory)this.dataDirectories[this.checkIndex(11)].getValue();
                }

                public DataDirectory getImportAddressTable() throws COFFException {
                    return (DataDirectory)this.dataDirectories[this.checkIndex(12)].getValue();
                }

                public DataDirectory getDelayImportDescriptor() throws COFFException {
                    return (DataDirectory)this.dataDirectories[this.checkIndex(13)].getValue();
                }

                public DataDirectory getCOMPlusRuntimeHeader() throws COFFException {
                    return (DataDirectory)this.dataDirectories[this.checkIndex(14)].getValue();
                }

                public ExportDirectoryTable getExportDirectoryTable() throws COFFException {
                    return (ExportDirectoryTable)this.exportDirectoryTable.getValue();
                }

                public DebugDirectory getDebugDirectory() throws COFFException {
                    return (DebugDirectory)this.debugDirectory.getValue();
                }

                private int checkIndex(int index) throws COFFException {
                    if (index < 0 || index >= this.dataDirectories.length) {
                        throw new COFFException("Directory " + index + " unavailable (only " + this.numberOfRvaAndSizes + " tables present)");
                    }
                    return index;
                }
            }

            class OptionalHeaderWindowsSpecificFieldsImpl
            implements OptionalHeaderWindowsSpecificFields {
                private long imageBase;
                private int sectionAlignment;
                private int fileAlignment;
                private short majorOperatingSystemVersion;
                private short minorOperatingSystemVersion;
                private short majorImageVersion;
                private short minorImageVersion;
                private short majorSubsystemVersion;
                private short minorSubsystemVersion;
                private int sizeOfImage;
                private int sizeOfHeaders;
                private int checkSum;
                private short subsystem;
                private short dllCharacteristics;
                private long sizeOfStackReserve;
                private long sizeOfStackCommit;
                private long sizeOfHeapReserve;
                private long sizeOfHeapCommit;
                private int loaderFlags;
                private int numberOfRvaAndSizes;

                OptionalHeaderWindowsSpecificFieldsImpl(int offset, boolean isPE32Plus) {
                    COFFFileImpl.this.seek(offset);
                    this.imageBase = !isPE32Plus ? this.maskInt(COFFFileImpl.this.readInt()) : COFFFileImpl.this.readLong();
                    this.sectionAlignment = COFFFileImpl.this.readInt();
                    this.fileAlignment = COFFFileImpl.this.readInt();
                    this.majorOperatingSystemVersion = COFFFileImpl.this.readShort();
                    this.minorOperatingSystemVersion = COFFFileImpl.this.readShort();
                    this.majorImageVersion = COFFFileImpl.this.readShort();
                    this.minorImageVersion = COFFFileImpl.this.readShort();
                    this.majorSubsystemVersion = COFFFileImpl.this.readShort();
                    this.minorSubsystemVersion = COFFFileImpl.this.readShort();
                    COFFFileImpl.this.readInt();
                    this.sizeOfImage = COFFFileImpl.this.readInt();
                    this.sizeOfHeaders = COFFFileImpl.this.readInt();
                    this.checkSum = COFFFileImpl.this.readInt();
                    this.subsystem = COFFFileImpl.this.readShort();
                    this.dllCharacteristics = COFFFileImpl.this.readShort();
                    if (!isPE32Plus) {
                        this.sizeOfStackReserve = this.maskInt(COFFFileImpl.this.readInt());
                        this.sizeOfStackCommit = this.maskInt(COFFFileImpl.this.readInt());
                        this.sizeOfHeapReserve = this.maskInt(COFFFileImpl.this.readInt());
                        this.sizeOfHeapCommit = this.maskInt(COFFFileImpl.this.readInt());
                    } else {
                        this.sizeOfStackReserve = COFFFileImpl.this.readLong();
                        this.sizeOfStackCommit = COFFFileImpl.this.readLong();
                        this.sizeOfHeapReserve = COFFFileImpl.this.readLong();
                        this.sizeOfHeapCommit = COFFFileImpl.this.readLong();
                    }
                    this.loaderFlags = COFFFileImpl.this.readInt();
                    this.numberOfRvaAndSizes = COFFFileImpl.this.readInt();
                }

                public long getImageBase() {
                    return this.imageBase;
                }

                public int getSectionAlignment() {
                    return this.sectionAlignment;
                }

                public int getFileAlignment() {
                    return this.fileAlignment;
                }

                public short getMajorOperatingSystemVersion() {
                    return this.majorOperatingSystemVersion;
                }

                public short getMinorOperatingSystemVersion() {
                    return this.minorOperatingSystemVersion;
                }

                public short getMajorImageVersion() {
                    return this.majorImageVersion;
                }

                public short getMinorImageVersion() {
                    return this.minorImageVersion;
                }

                public short getMajorSubsystemVersion() {
                    return this.majorSubsystemVersion;
                }

                public short getMinorSubsystemVersion() {
                    return this.minorSubsystemVersion;
                }

                public int getSizeOfImage() {
                    return this.sizeOfImage;
                }

                public int getSizeOfHeaders() {
                    return this.sizeOfHeaders;
                }

                public int getCheckSum() {
                    return this.checkSum;
                }

                public short getSubsystem() {
                    return this.subsystem;
                }

                public short getDLLCharacteristics() {
                    return this.dllCharacteristics;
                }

                public long getSizeOfStackReserve() {
                    return this.sizeOfStackReserve;
                }

                public long getSizeOfStackCommit() {
                    return this.sizeOfStackCommit;
                }

                public long getSizeOfHeapReserve() {
                    return this.sizeOfHeapReserve;
                }

                public long getSizeOfHeapCommit() {
                    return this.sizeOfHeapCommit;
                }

                public int getLoaderFlags() {
                    return this.loaderFlags;
                }

                public int getNumberOfRvaAndSizes() {
                    return this.numberOfRvaAndSizes;
                }

                private long maskInt(long arg) {
                    return arg & 0xFFFFFFFFL;
                }
            }

            class OptionalHeaderStandardFieldsImpl
            implements OptionalHeaderStandardFields {
                private boolean isPE32Plus;
                private byte majorLinkerVersion;
                private byte minorLinkerVersion;
                private int sizeOfCode;
                private int sizeOfInitializedData;
                private int sizeOfUninitializedData;
                private int addressOfEntryPoint;
                private int baseOfCode;
                private int baseOfData;

                OptionalHeaderStandardFieldsImpl(int offset, boolean isPE32Plus) {
                    this.isPE32Plus = isPE32Plus;
                    COFFFileImpl.this.seek(offset);
                    this.majorLinkerVersion = COFFFileImpl.this.readByte();
                    this.minorLinkerVersion = COFFFileImpl.this.readByte();
                    this.sizeOfCode = COFFFileImpl.this.readInt();
                    this.sizeOfInitializedData = COFFFileImpl.this.readInt();
                    this.sizeOfUninitializedData = COFFFileImpl.this.readInt();
                    this.addressOfEntryPoint = COFFFileImpl.this.readInt();
                    this.baseOfCode = COFFFileImpl.this.readInt();
                    if (!isPE32Plus) {
                        this.baseOfData = COFFFileImpl.this.readInt();
                    }
                }

                public byte getMajorLinkerVersion() {
                    return this.majorLinkerVersion;
                }

                public byte getMinorLinkerVersion() {
                    return this.minorLinkerVersion;
                }

                public int getSizeOfCode() {
                    return this.sizeOfCode;
                }

                public int getSizeOfInitializedData() {
                    return this.sizeOfInitializedData;
                }

                public int getSizeOfUninitializedData() {
                    return this.sizeOfUninitializedData;
                }

                public int getAddressOfEntryPoint() {
                    return this.addressOfEntryPoint;
                }

                public int getBaseOfCode() {
                    return this.baseOfCode;
                }

                public int getBaseOfData() throws COFFException {
                    if (this.isPE32Plus) {
                        throw new COFFException("Not present in PE32+ files");
                    }
                    return this.baseOfData;
                }
            }

            class OptionalHeaderImpl
            implements OptionalHeader {
                private short magic;
                private MemoizedObject standardFields;
                private MemoizedObject windowsSpecificFields;
                private MemoizedObject dataDirectories;
                private static final int STANDARD_FIELDS_OFFSET = 2;
                private static final int PE32_WINDOWS_SPECIFIC_FIELDS_OFFSET = 28;
                private static final int PE32_DATA_DIRECTORIES_OFFSET = 96;
                private static final int PE32_PLUS_WINDOWS_SPECIFIC_FIELDS_OFFSET = 24;
                private static final int PE32_PLUS_DATA_DIRECTORIES_OFFSET = 112;

                OptionalHeaderImpl(int offset) {
                    COFFFileImpl.this.seek(offset);
                    this.magic = COFFFileImpl.this.readShort();
                    final boolean isPE32Plus = this.magic == 523;
                    final int standardFieldsOffset = offset + 2;
                    final int windowsSpecificFieldsOffset = offset + (isPE32Plus ? 24 : 28);
                    final int dataDirectoriesOffset = offset + (isPE32Plus ? 112 : 96);
                    this.standardFields = new MemoizedObject(){

                        public Object computeValue() {
                            return new OptionalHeaderStandardFieldsImpl(standardFieldsOffset, isPE32Plus);
                        }
                    };
                    this.windowsSpecificFields = new MemoizedObject(){

                        public Object computeValue() {
                            return new OptionalHeaderWindowsSpecificFieldsImpl(windowsSpecificFieldsOffset, isPE32Plus);
                        }
                    };
                    this.dataDirectories = new MemoizedObject(){

                        public Object computeValue() {
                            return new OptionalHeaderDataDirectoriesImpl(dataDirectoriesOffset, OptionalHeaderImpl.this.getWindowsSpecificFields().getNumberOfRvaAndSizes());
                        }
                    };
                }

                public short getMagicNumber() {
                    return this.magic;
                }

                public OptionalHeaderStandardFields getStandardFields() {
                    return (OptionalHeaderStandardFields)this.standardFields.getValue();
                }

                public OptionalHeaderWindowsSpecificFields getWindowsSpecificFields() {
                    return (OptionalHeaderWindowsSpecificFields)this.windowsSpecificFields.getValue();
                }

                public OptionalHeaderDataDirectories getDataDirectories() {
                    return (OptionalHeaderDataDirectories)this.dataDirectories.getValue();
                }
            }
        }
    }
}

