/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class UndoManager
extends CompoundEdit
implements UndoableEditListener {
    int indexOfNextAdd = 0;
    int limit = 100;

    public UndoManager() {
        this.edits.ensureCapacity(this.limit);
    }

    public synchronized int getLimit() {
        return this.limit;
    }

    public synchronized void discardAllEdits() {
        Enumeration enumeration = this.edits.elements();
        while (enumeration.hasMoreElements()) {
            UndoableEdit undoableEdit = (UndoableEdit)enumeration.nextElement();
            undoableEdit.die();
        }
        this.edits = new Vector();
        this.indexOfNextAdd = 0;
    }

    protected void trimForLimit() {
        int n;
        if (this.limit >= 0 && (n = this.edits.size()) > this.limit) {
            int n2 = this.limit / 2;
            int n3 = this.indexOfNextAdd - 1 + n2;
            int n4 = this.indexOfNextAdd - 1 - n2;
            if (n3 - n4 + 1 > this.limit) {
                ++n4;
            }
            if (n4 < 0) {
                n3 -= n4;
                n4 = 0;
            }
            if (n3 >= n) {
                int n5 = n - n3 - 1;
                n3 += n5;
                n4 += n5;
            }
            this.trimEdits(n3 + 1, n - 1);
            this.trimEdits(0, n4 - 1);
        }
    }

    protected void trimEdits(int n, int n2) {
        if (n <= n2) {
            for (int i = n2; n <= i; --i) {
                UndoableEdit undoableEdit = (UndoableEdit)this.edits.elementAt(i);
                undoableEdit.die();
                this.edits.removeElementAt(i);
            }
            if (this.indexOfNextAdd > n2) {
                this.indexOfNextAdd -= n2 - n + 1;
            } else if (this.indexOfNextAdd >= n) {
                this.indexOfNextAdd = n;
            }
        }
    }

    public synchronized void setLimit(int n) {
        if (!this.inProgress) {
            throw new RuntimeException("Attempt to call UndoManager.setLimit() after UndoManager.end() has been called");
        }
        this.limit = n;
        this.trimForLimit();
    }

    protected UndoableEdit editToBeUndone() {
        int n = this.indexOfNextAdd;
        while (n > 0) {
            UndoableEdit undoableEdit;
            if (!(undoableEdit = (UndoableEdit)this.edits.elementAt(--n)).isSignificant()) continue;
            return undoableEdit;
        }
        return null;
    }

    protected UndoableEdit editToBeRedone() {
        int n = this.edits.size();
        int n2 = this.indexOfNextAdd;
        while (n2 < n) {
            UndoableEdit undoableEdit;
            if (!(undoableEdit = (UndoableEdit)this.edits.elementAt(n2++)).isSignificant()) continue;
            return undoableEdit;
        }
        return null;
    }

    protected void undoTo(UndoableEdit undoableEdit) throws CannotUndoException {
        boolean bl = false;
        while (!bl) {
            UndoableEdit undoableEdit2 = (UndoableEdit)this.edits.elementAt(--this.indexOfNextAdd);
            undoableEdit2.undo();
            bl = undoableEdit2 == undoableEdit;
        }
    }

    protected void redoTo(UndoableEdit undoableEdit) throws CannotRedoException {
        boolean bl = false;
        while (!bl) {
            UndoableEdit undoableEdit2 = (UndoableEdit)this.edits.elementAt(this.indexOfNextAdd++);
            undoableEdit2.redo();
            bl = undoableEdit2 == undoableEdit;
        }
    }

    public synchronized void undoOrRedo() throws CannotRedoException, CannotUndoException {
        if (this.indexOfNextAdd == this.edits.size()) {
            this.undo();
        } else {
            this.redo();
        }
    }

    public synchronized boolean canUndoOrRedo() {
        if (this.indexOfNextAdd == this.edits.size()) {
            return this.canUndo();
        }
        return this.canRedo();
    }

    @Override
    public synchronized void undo() throws CannotUndoException {
        if (this.inProgress) {
            UndoableEdit undoableEdit = this.editToBeUndone();
            if (undoableEdit == null) {
                throw new CannotUndoException();
            }
            this.undoTo(undoableEdit);
        } else {
            super.undo();
        }
    }

    @Override
    public synchronized boolean canUndo() {
        if (this.inProgress) {
            UndoableEdit undoableEdit = this.editToBeUndone();
            return undoableEdit != null && undoableEdit.canUndo();
        }
        return super.canUndo();
    }

    @Override
    public synchronized void redo() throws CannotRedoException {
        if (this.inProgress) {
            UndoableEdit undoableEdit = this.editToBeRedone();
            if (undoableEdit == null) {
                throw new CannotRedoException();
            }
            this.redoTo(undoableEdit);
        } else {
            super.redo();
        }
    }

    @Override
    public synchronized boolean canRedo() {
        if (this.inProgress) {
            UndoableEdit undoableEdit = this.editToBeRedone();
            return undoableEdit != null && undoableEdit.canRedo();
        }
        return super.canRedo();
    }

    @Override
    public synchronized boolean addEdit(UndoableEdit undoableEdit) {
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
        boolean bl = super.addEdit(undoableEdit);
        if (this.inProgress) {
            bl = true;
        }
        this.indexOfNextAdd = this.edits.size();
        this.trimForLimit();
        return bl;
    }

    @Override
    public synchronized void end() {
        super.end();
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
    }

    public synchronized String getUndoOrRedoPresentationName() {
        if (this.indexOfNextAdd == this.edits.size()) {
            return this.getUndoPresentationName();
        }
        return this.getRedoPresentationName();
    }

    @Override
    public synchronized String getUndoPresentationName() {
        if (this.inProgress) {
            if (this.canUndo()) {
                return this.editToBeUndone().getUndoPresentationName();
            }
            return UIManager.getString("AbstractUndoableEdit.undoText");
        }
        return super.getUndoPresentationName();
    }

    @Override
    public synchronized String getRedoPresentationName() {
        if (this.inProgress) {
            if (this.canRedo()) {
                return this.editToBeRedone().getRedoPresentationName();
            }
            return UIManager.getString("AbstractUndoableEdit.redoText");
        }
        return super.getRedoPresentationName();
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.addEdit(undoableEditEvent.getEdit());
    }

    @Override
    public String toString() {
        return super.toString() + " limit: " + this.limit + " indexOfNextAdd: " + this.indexOfNextAdd;
    }
}

