/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessController;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PolicySpi;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Provider;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.Enumeration;
import java.util.WeakHashMap;
import sun.security.jca.GetInstance;
import sun.security.provider.PolicyFile;
import sun.security.util.Debug;
import sun.security.util.SecurityConstants;

public abstract class Policy {
    public static final PermissionCollection UNSUPPORTED_EMPTY_COLLECTION = new UnsupportedEmptyCollection();
    private static Policy policy;
    private static final Debug debug;
    private WeakHashMap<ProtectionDomain.Key, PermissionCollection> pdMapping;

    static boolean isSet() {
        return policy != null;
    }

    private static void checkPermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("createPolicy." + string));
        }
    }

    public static Policy getPolicy() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.GET_POLICY_PERMISSION);
        }
        return Policy.getPolicyNoCheck();
    }

    static synchronized Policy getPolicyNoCheck() {
        block5: {
            if (policy == null) {
                String string = null;
                string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return Security.getProperty("policy.provider");
                    }
                });
                if (string == null) {
                    string = "sun.security.provider.PolicyFile";
                }
                try {
                    policy = (Policy)Class.forName(string).newInstance();
                }
                catch (Exception exception) {
                    policy = new PolicyFile();
                    final String string2 = string;
                    Policy policy = AccessController.doPrivileged(new PrivilegedAction<Policy>(){

                        @Override
                        public Policy run() {
                            try {
                                ClassLoader classLoader = null;
                                for (ClassLoader classLoader2 = ClassLoader.getSystemClassLoader(); classLoader2 != null; classLoader2 = classLoader2.getParent()) {
                                    classLoader = classLoader2;
                                }
                                return classLoader != null ? (Policy)Class.forName(string2, true, classLoader).newInstance() : null;
                            }
                            catch (Exception exception) {
                                if (debug != null) {
                                    debug.println("policy provider " + string2 + " not available");
                                    exception.printStackTrace();
                                }
                                return null;
                            }
                        }
                    });
                    if (policy != null) {
                        Policy.policy = policy;
                    }
                    if (debug == null) break block5;
                    debug.println("using sun.security.provider.PolicyFile");
                }
            }
        }
        return policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPolicy(Policy policy) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (policy != null) {
            Policy.initPolicy(policy);
        }
        Class<Policy> clazz = Policy.class;
        synchronized (Policy.class) {
            Policy.policy = policy;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initPolicy(final Policy policy) {
        ProtectionDomain protectionDomain = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return policy.getClass().getProtectionDomain();
            }
        });
        PermissionCollection permissionCollection = null;
        Object object = policy;
        synchronized (object) {
            if (policy.pdMapping == null) {
                policy.pdMapping = new WeakHashMap();
            }
        }
        if (protectionDomain.getCodeSource() != null) {
            if (Policy.isSet()) {
                permissionCollection = Policy.policy.getPermissions(protectionDomain);
            }
            if (permissionCollection == null) {
                permissionCollection = new Permissions();
                permissionCollection.add(SecurityConstants.ALL_PERMISSION);
            }
            object = policy.pdMapping;
            synchronized (object) {
                policy.pdMapping.put(protectionDomain.key, permissionCollection);
            }
        }
    }

    public static Policy getInstance(String string, Parameters parameters) throws NoSuchAlgorithmException {
        Policy.checkPermission(string);
        try {
            GetInstance.Instance instance = GetInstance.getInstance("Policy", PolicySpi.class, string, parameters);
            return new PolicyDelegate((PolicySpi)instance.impl, instance.provider, string, parameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return Policy.handleException(noSuchAlgorithmException);
        }
    }

    public static Policy getInstance(String string, Parameters parameters, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Policy.checkPermission(string);
        try {
            GetInstance.Instance instance = GetInstance.getInstance("Policy", PolicySpi.class, string, (Object)parameters, string2);
            return new PolicyDelegate((PolicySpi)instance.impl, instance.provider, string, parameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return Policy.handleException(noSuchAlgorithmException);
        }
    }

    public static Policy getInstance(String string, Parameters parameters, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Policy.checkPermission(string);
        try {
            GetInstance.Instance instance = GetInstance.getInstance("Policy", PolicySpi.class, string, (Object)parameters, provider);
            return new PolicyDelegate((PolicySpi)instance.impl, instance.provider, string, parameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return Policy.handleException(noSuchAlgorithmException);
        }
    }

    private static Policy handleException(NoSuchAlgorithmException noSuchAlgorithmException) throws NoSuchAlgorithmException {
        Throwable throwable = noSuchAlgorithmException.getCause();
        if (throwable instanceof IllegalArgumentException) {
            throw (IllegalArgumentException)throwable;
        }
        throw noSuchAlgorithmException;
    }

    public Provider getProvider() {
        return null;
    }

    public String getType() {
        return null;
    }

    public Parameters getParameters() {
        return null;
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        return UNSUPPORTED_EMPTY_COLLECTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        PermissionCollection permissionCollection = null;
        if (protectionDomain == null) {
            return new Permissions();
        }
        if (this.pdMapping == null) {
            Policy.initPolicy(this);
        }
        Object object = this.pdMapping;
        synchronized (object) {
            permissionCollection = this.pdMapping.get(protectionDomain.key);
        }
        if (permissionCollection != null) {
            object = new Permissions();
            PermissionCollection permissionCollection2 = permissionCollection;
            synchronized (permissionCollection2) {
                Enumeration<Permission> enumeration = permissionCollection.elements();
                while (enumeration.hasMoreElements()) {
                    ((Permissions)object).add(enumeration.nextElement());
                }
            }
            return object;
        }
        permissionCollection = this.getPermissions(protectionDomain.getCodeSource());
        if (permissionCollection == null || permissionCollection == UNSUPPORTED_EMPTY_COLLECTION) {
            permissionCollection = new Permissions();
        }
        this.addStaticPerms(permissionCollection, protectionDomain.getPermissions());
        return permissionCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStaticPerms(PermissionCollection permissionCollection, PermissionCollection permissionCollection2) {
        if (permissionCollection2 != null) {
            PermissionCollection permissionCollection3 = permissionCollection2;
            synchronized (permissionCollection3) {
                Enumeration<Permission> enumeration = permissionCollection2.elements();
                while (enumeration.hasMoreElements()) {
                    permissionCollection.add(enumeration.nextElement());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        PermissionCollection permissionCollection;
        if (this.pdMapping == null) {
            Policy.initPolicy(this);
        }
        WeakHashMap<ProtectionDomain.Key, PermissionCollection> weakHashMap = this.pdMapping;
        synchronized (weakHashMap) {
            permissionCollection = this.pdMapping.get(protectionDomain.key);
        }
        if (permissionCollection != null) {
            return permissionCollection.implies(permission);
        }
        permissionCollection = this.getPermissions(protectionDomain);
        if (permissionCollection == null) {
            return false;
        }
        weakHashMap = this.pdMapping;
        synchronized (weakHashMap) {
            this.pdMapping.put(protectionDomain.key, permissionCollection);
        }
        return permissionCollection.implies(permission);
    }

    public void refresh() {
    }

    static {
        debug = Debug.getInstance("policy");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnsupportedEmptyCollection
    extends PermissionCollection {
        private Permissions perms = new Permissions();

        public UnsupportedEmptyCollection() {
            this.perms.setReadOnly();
        }

        @Override
        public void add(Permission permission) {
            this.perms.add(permission);
        }

        @Override
        public boolean implies(Permission permission) {
            return this.perms.implies(permission);
        }

        @Override
        public Enumeration<Permission> elements() {
            return this.perms.elements();
        }
    }

    public static interface Parameters {
    }

    private static class PolicyDelegate
    extends Policy {
        private PolicySpi spi;
        private Provider p;
        private String type;
        private Parameters params;

        private PolicyDelegate(PolicySpi policySpi, Provider provider, String string, Parameters parameters) {
            this.spi = policySpi;
            this.p = provider;
            this.type = string;
            this.params = parameters;
        }

        public String getType() {
            return this.type;
        }

        public Parameters getParameters() {
            return this.params;
        }

        public Provider getProvider() {
            return this.p;
        }

        public PermissionCollection getPermissions(CodeSource codeSource) {
            return this.spi.engineGetPermissions(codeSource);
        }

        public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
            return this.spi.engineGetPermissions(protectionDomain);
        }

        public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
            return this.spi.engineImplies(protectionDomain, permission);
        }

        public void refresh() {
            this.spi.engineRefresh();
        }
    }
}

