/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;

public class TemporaryPlacesRegistry {
    private final Project myProject;
    private final List<TemporaryPlace> myTempPlaces = new CopyOnWriteArrayList<TemporaryPlace>();

    public static TemporaryPlacesRegistry getInstance(Project project) {
        return (TemporaryPlacesRegistry)ServiceManager.getService((Project)project, TemporaryPlacesRegistry.class);
    }

    public TemporaryPlacesRegistry(Project project) {
        this.myProject = project;
    }

    public List<TemporaryPlace> getTempInjectionsSafe() {
        List placesToRemove = ContainerUtil.findAll(this.myTempPlaces, (Condition)new Condition<TemporaryPlace>(){

            public boolean value(TemporaryPlace place) {
                return place.elementPointer.getElement() == null;
            }
        });
        if (!placesToRemove.isEmpty()) {
            this.myTempPlaces.removeAll(placesToRemove);
        }
        return this.myTempPlaces;
    }

    public List<TemporaryPlace> getTempInjectionsSafe(final PsiLanguageInjectionHost host) {
        return ContainerUtil.findAll(this.getTempInjectionsSafe(), (Condition)new Condition<TemporaryPlace>(){

            public boolean value(TemporaryPlace pair) {
                return pair.elementPointer.getElement() == host;
            }
        });
    }

    public void removeHostWithUndo(Project project, PsiLanguageInjectionHost host) {
        List<TemporaryPlace> places = this.getTempInjectionsSafe(host);
        if (places.isEmpty()) {
            return;
        }
        Configuration.replaceInjectionsWithUndo(project, Collections.emptyList(), places, Collections.emptyList(), new PairProcessor<List<TemporaryPlace>, List<TemporaryPlace>>(){

            public boolean process(List<TemporaryPlace> add, List<TemporaryPlace> remove) {
                TemporaryPlacesRegistry.this.myTempPlaces.addAll(add);
                TemporaryPlacesRegistry.this.myTempPlaces.removeAll(remove);
                return true;
            }
        });
    }

    public void addHostWithUndo(PsiLanguageInjectionHost host, InjectedLanguage language) {
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)this.myProject);
        SmartPsiElementPointer pointer = manager.createSmartPsiElementPointer((PsiElement)host);
        TemporaryPlace place = new TemporaryPlace(language, (SmartPsiElementPointer<PsiLanguageInjectionHost>)pointer);
        if (this.myTempPlaces.contains(place)) {
            return;
        }
        Configuration.replaceInjectionsWithUndo(this.myProject, Collections.singletonList(place), Collections.emptyList(), Collections.emptyList(), new PairProcessor<List<TemporaryPlace>, List<TemporaryPlace>>(){

            public boolean process(List<TemporaryPlace> add, List<TemporaryPlace> remove) {
                TemporaryPlacesRegistry.this.myTempPlaces.addAll(add);
                TemporaryPlacesRegistry.this.myTempPlaces.removeAll(remove);
                return true;
            }
        });
    }

    public static class TemporaryPlace {
        final InjectedLanguage language;
        final SmartPsiElementPointer<PsiLanguageInjectionHost> elementPointer;

        public TemporaryPlace(InjectedLanguage language, SmartPsiElementPointer<PsiLanguageInjectionHost> elementPointer) {
            this.language = language;
            this.elementPointer = elementPointer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemporaryPlace place = (TemporaryPlace)o;
            if (!this.elementPointer.equals(place.elementPointer)) {
                return false;
            }
            return this.language.equals(place.language);
        }

        public int hashCode() {
            int result = this.language.hashCode();
            result = 31 * result + this.elementPointer.hashCode();
            return result;
        }
    }
}

