/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.FileContentUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectLanguageAction
implements IntentionAction {
    @NonNls
    private static final String INJECT_LANGUAGE_FAMILY = "Inject Language";

    @NotNull
    public String getText() {
        if (INJECT_LANGUAGE_FAMILY == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/InjectLanguageAction.getText must not return null");
        }
        return INJECT_LANGUAGE_FAMILY;
    }

    @NotNull
    public String getFamilyName() {
        if (INJECT_LANGUAGE_FAMILY == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/InjectLanguageAction.getFamilyName must not return null");
        }
        return INJECT_LANGUAGE_FAMILY;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/InjectLanguageAction.isAvailable must not be null");
        }
        PsiLanguageInjectionHost host = InjectLanguageAction.findInjectionHost(editor, file);
        if (host == null) {
            return false;
        }
        List injectedPsi = InjectedLanguageUtil.getInjectedPsiFiles((PsiElement)host);
        return injectedPsi == null || injectedPsi.isEmpty();
    }

    @Nullable
    protected static PsiLanguageInjectionHost findInjectionHost(Editor editor, PsiFile file) {
        TextRange textRange;
        if (editor instanceof EditorWindow) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), PsiLanguageInjectionHost.class, (boolean)false);
        if (host == null) {
            return null;
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)host);
        if (manipulator == null) {
            return null;
        }
        if (file.getFileType() != StdFileTypes.XML && (textRange = manipulator.getRangeInElement((PsiElement)host)).getStartOffset() == 0) {
            return null;
        }
        return host;
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/InjectLanguageAction.invoke must not be null");
        }
        InjectLanguageAction.doChooseLanguageToInject(new Processor<String>(){

            public boolean process(final String languageId) {
                if (project.isDisposed()) {
                    return false;
                }
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        InjectLanguageAction.invokeImpl(project, editor, file, languageId);
                    }
                });
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeImpl(Project project, Editor editor, PsiFile file, String languageId) {
        PsiLanguageInjectionHost host = InjectLanguageAction.findInjectionHost(editor, file);
        if (host == null) {
            return;
        }
        if (InjectLanguageAction.defaultFunctionalityWorked(host, languageId)) {
            return;
        }
        Language language = InjectedLanguage.findLanguageById(languageId);
        try {
            for (LanguageInjectionSupport support : (LanguageInjectionSupport[])Extensions.getExtensions(LanguageInjectionSupport.EP_NAME)) {
                if (!support.addInjectionInPlace(language, host)) continue;
                return;
            }
            TemporaryPlacesRegistry.getInstance(project).addHostWithUndo(host, InjectedLanguage.create(languageId));
        }
        finally {
            FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
        }
    }

    private static boolean defaultFunctionalityWorked(PsiLanguageInjectionHost host, String languageId) {
        return Configuration.getInstance().setHostInjectionEnabled(host, Collections.singleton(languageId), true);
    }

    private static boolean doChooseLanguageToInject(final Processor<String> onChosen) {
        Object[] langIds = InjectedLanguage.getAvailableLanguageIDs();
        Arrays.sort(langIds);
        final JList<Object> list = new JList<Object>(langIds);
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                String aValue = (String)value;
                Language language = InjectedLanguage.findLanguageById(aValue);
                assert (language != null);
                FileType ft = language.getAssociatedFileType();
                this.setIcon(ft != null ? ft.getIcon() : new EmptyIcon(16));
                this.setText(value + (ft != null ? " (" + ft.getDescription() + ")" : ""));
                return this;
            }
        });
        new PopupChooserBuilder(list).setItemChoosenCallback(new Runnable(){

            @Override
            public void run() {
                String string = (String)list.getSelectedValue();
                onChosen.process((Object)string);
            }
        }).setFilteringEnabled((Function)new Function<Object, String>(){

            public String fun(Object o) {
                return (String)o;
            }
        }).createPopup().showInBestPositionFor(DataManager.getInstance().getDataContext());
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static boolean doEditConfigurable(Project project, Configurable configurable) {
        return true;
    }
}

