/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters.values;

import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomBundle;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NumberValueConverter
extends Converter<String> {
    private final Class myNumberClass;
    private final boolean myAllowEmpty;

    public NumberValueConverter(@NotNull Class numberClass, boolean allowEmpty) {
        if (numberClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/converters/values/NumberValueConverter.<init> must not be null");
        }
        this.myNumberClass = numberClass;
        this.myAllowEmpty = allowEmpty;
    }

    @Override
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        if (this.myAllowEmpty && s.trim().length() == 0) {
            return s;
        }
        return NumberValueConverter.parseNumber(s, this.myNumberClass) == null ? null : s;
    }

    @Override
    public String toString(@Nullable String s, ConvertContext context) {
        return null;
    }

    @Override
    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        if (s == null) {
            return super.getErrorMessage(s, context);
        }
        return s.trim().length() == 0 ? DomBundle.message("value.converter.format.exception.empty.string", this.myNumberClass.getName()) : DomBundle.message("value.converter.format.exception", s, this.myNumberClass.getName());
    }

    @Nullable
    public static Number parseNumber(@NotNull String text, @NotNull Class targetClass) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/converters/values/NumberValueConverter.parseNumber must not be null");
        }
        if (targetClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/converters/values/NumberValueConverter.parseNumber must not be null");
        }
        try {
            String trimmed = text.trim();
            if (targetClass.equals(Byte.class) || targetClass.equals(Byte.TYPE)) {
                return Byte.decode(trimmed);
            }
            if (targetClass.equals(Short.class) || targetClass.equals(Short.TYPE)) {
                return Short.decode(trimmed);
            }
            if (targetClass.equals(Integer.class) || targetClass.equals(Integer.TYPE)) {
                return Integer.decode(trimmed);
            }
            if (targetClass.equals(Long.class) || targetClass.equals(Long.TYPE)) {
                return Long.decode(trimmed);
            }
            if (targetClass.equals(BigInteger.class)) {
                return NumberValueConverter.decodeBigInteger(trimmed);
            }
            if (targetClass.equals(Float.class) || targetClass.equals(Float.TYPE)) {
                return Float.valueOf(trimmed);
            }
            if (targetClass.equals(Double.class) || targetClass.equals(Double.TYPE)) {
                return Double.valueOf(trimmed);
            }
            if (targetClass.equals(BigDecimal.class) || targetClass.equals(Number.class)) {
                return new BigDecimal(trimmed);
            }
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return null;
    }

    private static BigInteger decodeBigInteger(String value) {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (value.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (value.startsWith("0x", index) || value.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (value.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (value.startsWith("0", index) && value.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        BigInteger result = new BigInteger(value.substring(index), radix);
        return negative ? result.negate() : result;
    }
}

