/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Pass;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.ActionButton;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;

class ActionPanel
extends NonOpaquePanel {
    private final ActionGroup myGroup;
    private final List<ActionButton> myButtons = new ArrayList<ActionButton>();
    private final TabInfo myTabInfo;
    private final JBTabsImpl myTabs;
    private boolean myAutoHide;
    private final int myGap = 2;

    public ActionPanel(JBTabsImpl tabs, TabInfo tabInfo, Pass<MouseEvent> pass) {
        this.myTabs = tabs;
        this.myTabInfo = tabInfo;
        this.myGroup = tabInfo.getTabLabelActions() != null ? tabInfo.getTabLabelActions() : new DefaultActionGroup();
        AnAction[] children = this.myGroup.getChildren(null);
        NonOpaquePanel wrapper = new NonOpaquePanel(new FlowLayout(2, 0, 0));
        wrapper.add(Box.createHorizontalStrut(2));
        for (AnAction each : children) {
            ActionButton eachButton = new ActionButton(this.myTabs, tabInfo, each, tabInfo.getTabActionPlace(), pass, tabs.getTabActionsMouseDeadzone());
            this.myButtons.add(eachButton);
            wrapper.add(eachButton.getComponent());
        }
        this.setLayout(new GridBagLayout());
        this.add(wrapper);
    }

    public boolean update() {
        boolean changed = false;
        for (ActionButton each : this.myButtons) {
            changed |= each.update();
            each.setMouseDeadZone(this.myTabs.getTabActionsMouseDeadzone());
        }
        return changed;
    }

    public boolean isAutoHide() {
        return this.myAutoHide;
    }

    public void setAutoHide(boolean autoHide) {
        this.myAutoHide = autoHide;
        for (ActionButton each : this.myButtons) {
            each.setAutoHide(this.myAutoHide);
        }
    }

    public void toggleShowActtions(boolean show) {
        for (ActionButton each : this.myButtons) {
            each.toggleShowActions(show);
        }
    }
}

