/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorNotifications
extends AbstractProjectComponent {
    private static final ExtensionPointName<Provider> EXTENSION_POINT_NAME = new ExtensionPointName("com.intellij.editorNotificationProvider");
    private final NotNullLazyValue<Provider[]> PROVIDERS = new NotNullLazyValue<Provider[]>(){

        @NotNull
        protected Provider[] compute() {
            Provider[] providerArray = (Provider[])Extensions.getExtensions((ExtensionPointName)EXTENSION_POINT_NAME, (AreaInstance)EditorNotifications.this.myProject);
            if (providerArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ui/EditorNotifications$1.compute must not return null");
            }
            return providerArray;
        }
    };
    private final FileEditorManager myFileEditorManager;

    public static EditorNotifications getInstance(Project project) {
        return project.getComponent(EditorNotifications.class);
    }

    public EditorNotifications(Project project, FileEditorManager fileEditorManager) {
        super(project);
        this.myFileEditorManager = fileEditorManager;
        project.getMessageBus().connect((Disposable)project).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            @Override
            public void fileOpened(FileEditorManager source, VirtualFile file) {
                EditorNotifications.this.updateNotifications(file);
            }
        });
    }

    public void updateNotifications(final VirtualFile file) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                FileEditor[] editors;
                for (FileEditor editor : editors = EditorNotifications.this.myFileEditorManager.getAllEditors(file)) {
                    for (Provider provider : (Provider[])EditorNotifications.this.PROVIDERS.getValue()) {
                        Object component = provider.createNotificationPanel(file);
                        Key key = provider.getKey();
                        EditorNotifications.this.updateNotification(editor, (Key<? extends JComponent>)key, component);
                    }
                }
            }
        });
    }

    public void updateAllNotifications() {
        VirtualFile[] files;
        for (VirtualFile file : files = this.myFileEditorManager.getOpenFiles()) {
            this.updateNotifications(file);
        }
    }

    private void updateNotification(FileEditor editor, Key<? extends JComponent> key, @Nullable JComponent component) {
        JComponent old = (JComponent)editor.getUserData(key);
        if (old != null) {
            this.myFileEditorManager.removeTopComponent(editor, old);
        }
        if (component != null) {
            this.myFileEditorManager.addTopComponent(editor, component);
            editor.putUserData(key, component);
        } else {
            editor.putUserData(key, null);
        }
    }

    public static interface Provider<T extends JComponent> {
        public Key<T> getKey();

        @Nullable
        public T createNotificationPanel(VirtualFile var1);
    }
}

