/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.WalkingState;
import org.jetbrains.annotations.NotNull;

public abstract class PsiWalkingState
extends WalkingState<PsiElement> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.PsiWalkingState");
    private final PsiElementVisitor myVisitor;

    protected PsiWalkingState(PsiElementVisitor delegate) {
        super(PsiTreeGuide.instance);
        this.myVisitor = delegate;
    }

    @Override
    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiWalkingState.visit must not be null");
        }
        element.accept(this.myVisitor);
    }

    @Override
    public void elementStarted(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiWalkingState.elementStarted must not be null");
        }
        if (!this.startedWalking && element instanceof PsiCompiledElement) {
            LOG.error(element + "; Do not use walking visitor inside compiled PSI since getNextSibling() is too slow there");
        }
        super.elementStarted(element);
    }

    private static class PsiTreeGuide
    implements WalkingState.TreeGuide<PsiElement> {
        private static final PsiTreeGuide instance = new PsiTreeGuide();

        private PsiTreeGuide() {
        }

        @Override
        public PsiElement getNextSibling(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiWalkingState$PsiTreeGuide.getNextSibling must not be null");
            }
            return element.getNextSibling();
        }

        @Override
        public PsiElement getPrevSibling(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiWalkingState$PsiTreeGuide.getPrevSibling must not be null");
            }
            return element.getPrevSibling();
        }

        @Override
        public PsiElement getFirstChild(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiWalkingState$PsiTreeGuide.getFirstChild must not be null");
            }
            return element.getFirstChild();
        }

        @Override
        public PsiElement getParent(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiWalkingState$PsiTreeGuide.getParent must not be null");
            }
            return element.getParent();
        }
    }
}

