/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleTimerTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;

public class SimpleTimer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.util.SimpleTimer");
    private final Timer ourTimer;
    private static final SimpleTimer ourInstance = new SimpleTimer();
    private static final String THREAD_NAME = "SimpleTimer";
    private long myNextScheduledTime = Long.MAX_VALUE;
    private TimerTask myNextProcessingTask;
    private final Map<Long, ArrayList<SimpleTimerTask>> myTime2Task = new TreeMap<Long, ArrayList<SimpleTimerTask>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleTimer() {
        Thread thread = Thread.currentThread();
        int currentPrio = thread.getPriority();
        try {
            thread.setPriority(2);
            this.ourTimer = new Timer(THREAD_NAME, true);
        }
        finally {
            thread.setPriority(currentPrio);
        }
    }

    public static SimpleTimer getInstance() {
        return ourInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleTimerTask setUp(Runnable runnable, long delay) {
        Map<Long, ArrayList<SimpleTimerTask>> map = this.myTime2Task;
        synchronized (map) {
            long current = System.currentTimeMillis();
            long targetTime = current + delay;
            SimpleTimerTask result = new SimpleTimerTask(targetTime, runnable, this);
            ArrayList<SimpleTimerTask> tasks = this.myTime2Task.get(targetTime);
            if (tasks == null) {
                tasks = new ArrayList(2);
                this.myTime2Task.put(targetTime, tasks);
            }
            tasks.add(result);
            if (targetTime < this.myNextScheduledTime) {
                if (this.myNextProcessingTask != null) {
                    this.myNextProcessingTask.cancel();
                }
                this.scheduleNext(delay, targetTime);
            }
            return result;
        }
    }

    private void scheduleNext(long delay, long targetTime) {
        this.myNextScheduledTime = targetTime;
        this.myNextProcessingTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    SimpleTimer.this.processNext();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        this.ourTimer.schedule(this.myNextProcessingTask, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNext() {
        Ref tasks = new Ref();
        Map<Long, ArrayList<SimpleTimerTask>> map = this.myTime2Task;
        synchronized (map) {
            long current = System.currentTimeMillis();
            Iterator<Long> times = this.myTime2Task.keySet().iterator();
            if (times.hasNext()) {
                Long time = times.next();
                tasks.set(this.myTime2Task.get(time));
                times.remove();
            }
            if (!times.hasNext()) {
                this.myNextScheduledTime = Long.MAX_VALUE;
                this.myNextProcessingTask = null;
            } else {
                Long nextEffectiveTime = null;
                while (times.hasNext()) {
                    Long nextTime = times.next();
                    if (nextTime <= current) {
                        ((ArrayList)tasks.get()).addAll((Collection)this.myTime2Task.get(nextTime));
                        times.remove();
                        continue;
                    }
                    nextEffectiveTime = nextTime;
                    break;
                }
                if (nextEffectiveTime == null) {
                    this.myNextProcessingTask = null;
                    this.myNextScheduledTime = Long.MAX_VALUE;
                } else {
                    this.scheduleNext(nextEffectiveTime - current, nextEffectiveTime);
                }
            }
        }
        ArrayList toRun = (ArrayList)tasks.get();
        if (toRun != null) {
            for (SimpleTimerTask each : toRun) {
                each.run();
            }
        }
    }

    public boolean isTimerThread() {
        return this.isTimerThread(Thread.currentThread());
    }

    public boolean isTimerThread(Thread thread) {
        return THREAD_NAME.equals(thread.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCancelled(SimpleTimerTask task) {
        Map<Long, ArrayList<SimpleTimerTask>> map = this.myTime2Task;
        synchronized (map) {
            ArrayList<SimpleTimerTask> list = this.myTime2Task.get(task.getTargetTime());
            if (list != null) {
                list.remove(task);
                if (list.size() == 0) {
                    this.myTime2Task.remove(task.getTargetTime());
                }
            }
        }
    }
}

