/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.event.MockDocumentEvent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class EditorModificationUtil {
    private EditorModificationUtil() {
    }

    public static void deleteSelectedText(Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasBlockSelection()) {
            EditorModificationUtil.deleteBlockSelection(editor);
        }
        if (!selectionModel.hasSelection()) {
            return;
        }
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        editor.getCaretModel().moveToOffset(selectionStart);
        selectionModel.removeSelection();
        editor.getDocument().deleteString(selectionStart, selectionEnd);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    public static void deleteBlockSelection(Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasBlockSelection()) {
            return;
        }
        int startLine = selectionModel.getBlockStart().line;
        int endLine = selectionModel.getBlockEnd().line;
        int[] starts = selectionModel.getBlockSelectionStarts();
        int[] ends = selectionModel.getBlockSelectionEnds();
        for (int i = starts.length - 1; i >= 0; --i) {
            editor.getDocument().deleteString(starts[i], ends[i]);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        EditorModificationUtil.zeroWidthBlockSelectionAtCaretColumn(editor, startLine, endLine);
    }

    private static void zeroWidthBlockSelectionAtCaretColumn(Editor editor, int startLine, int endLine) {
        int caretColumn = editor.getCaretModel().getLogicalPosition().column;
        editor.getSelectionModel().setBlockSelection(new LogicalPosition(startLine, caretColumn), new LogicalPosition(endLine, caretColumn));
    }

    public static void insertStringAtCaret(Editor editor, String s) {
        EditorModificationUtil.insertStringAtCaret(editor, s, false, true);
    }

    public static int insertStringAtCaret(Editor editor, String s, boolean toProcessOverwriteMode, boolean toMoveCaret) {
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            editor.getCaretModel().moveToOffset(selectionModel.getSelectionStart());
        }
        int oldOffset = editor.getCaretModel().getOffset();
        String filler = EditorModificationUtil.calcStringToFillVitualSpace(editor);
        if (filler.length() > 0) {
            s = filler + s;
        }
        if (editor.isInsertMode() || !toProcessOverwriteMode) {
            if (selectionModel.hasSelection()) {
                editor.getDocument().replaceString(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd(), s);
            } else {
                editor.getDocument().insertString(oldOffset, s);
            }
        } else {
            EditorModificationUtil.deleteSelectedText(editor);
            Document document = editor.getDocument();
            int lineNumber = editor.getCaretModel().getLogicalPosition().line;
            if (lineNumber >= document.getLineCount()) {
                return EditorModificationUtil.insertStringAtCaret(editor, s, false, toMoveCaret);
            }
            int endOffset = document.getLineEndOffset(lineNumber);
            document.replaceString(oldOffset, Math.min(endOffset, oldOffset + s.length()), s);
        }
        int offset = oldOffset + s.length();
        if (toMoveCaret) {
            editor.getCaretModel().moveToOffset(offset);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            selectionModel.removeSelection();
        }
        return offset;
    }

    @Nullable
    public static TextRange pasteFromClipboard(Editor editor) {
        return EditorModificationUtil.pasteFromTransferrable(EditorModificationUtil.getClipboardContent(editor), editor);
    }

    @Nullable
    public static TextRange pasteFromTransferrable(Transferable content, Editor editor) {
        if (content != null) {
            try {
                String s = EditorModificationUtil.getStringContent(content);
                int caretOffset = editor.getCaretModel().getOffset();
                EditorModificationUtil.insertStringAtCaret(editor, s, false, true);
                return new TextRange(caretOffset, caretOffset + s.length());
            }
            catch (Exception exception) {
                editor.getComponent().getToolkit().beep();
            }
        }
        return null;
    }

    private static String getStringContent(Transferable content) throws UnsupportedFlavorException, IOException {
        RawText raw = RawText.fromTransferable(content);
        String s = raw != null ? raw.rawText : (String)content.getTransferData(DataFlavor.stringFlavor);
        s = StringUtil.convertLineSeparators((String)s);
        return s;
    }

    private static Transferable getClipboardContent(Editor editor) {
        Transferable content;
        Project project = editor.getProject();
        if (project != null) {
            content = CopyPasteManager.getInstance().getContents();
        } else {
            Clipboard clipboard = editor.getComponent().getToolkit().getSystemClipboard();
            content = clipboard.getContents(editor.getComponent());
        }
        return content;
    }

    public static void pasteFromClipboardAsBlock(Editor editor) {
        Transferable content = EditorModificationUtil.getClipboardContent(editor);
        if (content != null) {
            try {
                int caretLine;
                int originalCaretLine = caretLine = editor.getCaretModel().getLogicalPosition().line;
                int selectedLinesCount = 0;
                SelectionModel selectionModel = editor.getSelectionModel();
                if (selectionModel.hasBlockSelection()) {
                    LogicalPosition start = selectionModel.getBlockStart();
                    LogicalPosition end = selectionModel.getBlockEnd();
                    assert (start != null);
                    assert (end != null);
                    LogicalPosition caret = new LogicalPosition(Math.min(start.line, end.line), Math.min(start.column, end.column));
                    selectedLinesCount = Math.abs(end.line - start.line);
                    caretLine = caret.line;
                    EditorModificationUtil.deleteSelectedText(editor);
                    editor.getCaretModel().moveToLogicalPosition(caret);
                }
                LogicalPosition caretToRestore = editor.getCaretModel().getLogicalPosition();
                String s = EditorModificationUtil.getStringContent(content);
                String[] lines = LineTokenizer.tokenize((char[])s.toCharArray(), (boolean)false);
                if (lines.length > 1 || selectedLinesCount <= 1) {
                    int longestLineLength = 0;
                    for (String line : lines) {
                        longestLineLength = Math.max(longestLineLength, line.length());
                        EditorModificationUtil.insertStringAtCaret(editor, line, false, true);
                        editor.getCaretModel().moveCaretRelatively(-line.length(), 1, false, false, true);
                    }
                    caretToRestore = new LogicalPosition(originalCaretLine, caretToRestore.column + longestLineLength);
                } else {
                    for (int i = 0; i <= selectedLinesCount; ++i) {
                        EditorModificationUtil.insertStringAtCaret(editor, s, false, true);
                        editor.getCaretModel().moveCaretRelatively(-s.length(), 1, false, false, true);
                    }
                    caretToRestore = new LogicalPosition(originalCaretLine, caretToRestore.column + s.length());
                }
                editor.getCaretModel().moveToLogicalPosition(caretToRestore);
                EditorModificationUtil.zeroWidthBlockSelectionAtCaretColumn(editor, caretLine, caretLine + selectedLinesCount);
            }
            catch (Exception exception) {
                editor.getComponent().getToolkit().beep();
            }
        }
    }

    public static int calcAfterLineEnd(Editor editor) {
        Document document = editor.getDocument();
        LogicalPosition logicalPosition = editor.getCaretModel().getLogicalPosition();
        int columnNumber = logicalPosition.column;
        int lineNumber = logicalPosition.line;
        if (lineNumber >= document.getLineCount()) {
            return columnNumber;
        }
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        int lineEndColumnNumber = editor.offsetToLogicalPosition((int)lineEndOffset).column;
        return columnNumber - lineEndColumnNumber;
    }

    public static String calcStringToFillVitualSpace(Editor editor) {
        int afterLineEnd = EditorModificationUtil.calcAfterLineEnd(editor);
        if (afterLineEnd > 0) {
            String properIndent;
            boolean atLineStart;
            Project project = editor.getProject();
            StringBuilder buf = new StringBuilder();
            Document doc = editor.getDocument();
            int caretOffset = editor.getCaretModel().getOffset();
            boolean bl = atLineStart = caretOffset >= doc.getTextLength() || doc.getLineStartOffset(doc.getLineNumber(caretOffset)) == caretOffset;
            if (atLineStart && project != null && (properIndent = CodeStyleFacade.getInstance(project).getLineIndent(editor)) != null) {
                int tabSize = editor.getSettings().getTabSize(project);
                for (int i = 0; i < properIndent.length(); ++i) {
                    if (properIndent.charAt(i) == ' ') {
                        --afterLineEnd;
                    } else if (properIndent.charAt(i) == '\t') {
                        if (afterLineEnd < tabSize) break;
                        afterLineEnd -= tabSize;
                    }
                    buf.append(properIndent.charAt(i));
                    if (afterLineEnd == 0) break;
                }
            }
            for (int i = 0; i < afterLineEnd; ++i) {
                buf.append(' ');
            }
            return buf.toString();
        }
        return "";
    }

    public static void typeInStringAtCaretHonorBlockSelection(Editor editor, String str, boolean toProcessOverwriteMode) throws ReadOnlyFragmentModificationException {
        Document doc = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasBlockSelection()) {
            RangeMarker guard = selectionModel.getBlockSelectionGuard();
            if (guard != null) {
                MockDocumentEvent evt = new MockDocumentEvent(doc, editor.getCaretModel().getOffset());
                ReadOnlyFragmentModificationException e = new ReadOnlyFragmentModificationException(evt, guard);
                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
            } else {
                LogicalPosition start = selectionModel.getBlockStart();
                LogicalPosition end = selectionModel.getBlockEnd();
                assert (start != null);
                assert (end != null);
                int column = Math.min(start.column, end.column);
                int startLine = Math.min(start.line, end.line);
                int endLine = Math.max(start.line, end.line);
                EditorModificationUtil.deleteBlockSelection(editor);
                for (int i = startLine; i <= endLine; ++i) {
                    editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(i, column));
                    EditorModificationUtil.insertStringAtCaret(editor, str, toProcessOverwriteMode, true);
                }
                selectionModel.setBlockSelection(new LogicalPosition(startLine, column + str.length()), new LogicalPosition(endLine, column + str.length()));
            }
        } else {
            EditorModificationUtil.insertStringAtCaret(editor, str, toProcessOverwriteMode, true);
        }
    }
}

