/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.ModuleBuilderFactory;
import com.intellij.ide.util.projectWizard.ModuleBuilderListener;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleBuilder
extends ProjectBuilder {
    private static final ExtensionPointName<ModuleBuilderFactory> EP_NAME = ExtensionPointName.create((String)"com.intellij.moduleBuilder");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.projectWizard.ModuleBuilder");
    private String myName;
    @NonNls
    private String myModuleFilePath;
    private final List<ModuleConfigurationUpdater> myUpdaters = new ArrayList<ModuleConfigurationUpdater>();
    private final EventDispatcher<ModuleBuilderListener> myDispatcher = EventDispatcher.create(ModuleBuilderListener.class);

    public static List<ModuleBuilder> getAllBuilders() {
        ArrayList<ModuleBuilder> result = new ArrayList<ModuleBuilder>();
        for (ModuleType moduleType : ModuleTypeManager.getInstance().getRegisteredTypes()) {
            result.add((ModuleBuilder)moduleType.createModuleBuilder());
        }
        for (ModuleBuilderFactory moduleBuilderFactory : (ModuleBuilderFactory[])EP_NAME.getExtensions()) {
            result.add(moduleBuilderFactory.createBuilder());
        }
        return result;
    }

    @Nullable
    protected final String acceptParameter(String param) {
        return param != null && param.length() > 0 ? param : null;
    }

    public String getName() {
        return this.myName;
    }

    public String getBuilderId() {
        return this.getModuleType().getId();
    }

    public ModuleWizardStep[] createWizardSteps(WizardContext wizardContext, ModulesProvider modulesProvider) {
        return this.getModuleType().createWizardSteps(wizardContext, this, modulesProvider);
    }

    public void setName(String name) {
        this.myName = this.acceptParameter(name);
    }

    public String getModuleFilePath() {
        return this.myModuleFilePath;
    }

    public void addModuleConfigurationUpdater(ModuleConfigurationUpdater updater) {
        this.myUpdaters.add(updater);
    }

    public void setModuleFilePath(@NonNls String path) {
        this.myModuleFilePath = this.acceptParameter(path);
    }

    @Nullable
    public String getModuleFileDirectory() {
        if (this.myModuleFilePath == null) {
            return null;
        }
        String parent = new File(this.myModuleFilePath).getParent();
        if (parent == null) {
            return null;
        }
        return parent.replace(File.separatorChar, '/');
    }

    @NotNull
    public Module createModule(ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        LOG.assertTrue(this.myName != null);
        LOG.assertTrue(this.myModuleFilePath != null);
        ModuleBuilder.deleteModuleFile(this.myModuleFilePath);
        ModuleType moduleType = this.getModuleType();
        Module module = moduleModel.newModule(this.myModuleFilePath, moduleType);
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance(module).getModifiableModel();
        this.setupRootModel(modifiableModel);
        for (ModuleConfigurationUpdater updater : this.myUpdaters) {
            updater.update(module, modifiableModel);
        }
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/projectWizard/ModuleBuilder.createModule must not return null");
        }
        return module2;
    }

    private void onModuleInitialized(Module module) {
        ((ModuleBuilderListener)this.myDispatcher.getMulticaster()).moduleCreated(module);
    }

    public abstract void setupRootModel(ModifiableRootModel var1) throws ConfigurationException;

    public abstract ModuleType getModuleType();

    @NotNull
    public Module createAndCommitIfNeeded(Project project, ModifiableModuleModel model, boolean runFromProjectWizard) throws InvalidDataException, ConfigurationException, IOException, JDOMException, ModuleWithNameAlreadyExists {
        ModifiableModuleModel moduleModel = model != null ? model : ModuleManager.getInstance(project).getModifiableModel();
        final Module module = this.createModule(moduleModel);
        if (model == null) {
            moduleModel.commit();
        }
        if (runFromProjectWizard) {
            StartupManager.getInstance(module.getProject()).runWhenProjectIsInitialized(new DumbAwareRunnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            ModuleBuilder.this.onModuleInitialized(module);
                        }
                    });
                }
            });
        } else {
            this.onModuleInitialized(module);
        }
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/projectWizard/ModuleBuilder.createAndCommitIfNeeded must not return null");
        }
        return module2;
    }

    public void addListener(ModuleBuilderListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(ModuleBuilderListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public boolean canCreateModule() {
        return true;
    }

    @Override
    @Nullable
    public List<Module> commit(Project project, ModifiableModuleModel model, ModulesProvider modulesProvider) {
        Module module = this.commitModule(project, model);
        return module != null ? Collections.singletonList(module) : null;
    }

    public Module commitModule(final Project project, final ModifiableModuleModel model) {
        final Ref result = new Ref();
        if (this.canCreateModule()) {
            Exception ex;
            if (this.myName == null) {
                this.myName = project.getName();
            }
            if (this.myModuleFilePath == null) {
                this.myModuleFilePath = project.getBaseDir().getPath() + File.separator + this.myName + ".iml";
            }
            if ((ex = ApplicationManager.getApplication().runWriteAction(new Computable<Exception>(){

                public Exception compute() {
                    try {
                        result.set((Object)ModuleBuilder.this.createAndCommitIfNeeded(project, model, true));
                        return null;
                    }
                    catch (Exception e) {
                        return e;
                    }
                }
            })) != null) {
                LOG.info((Throwable)ex);
                Messages.showErrorDialog(IdeBundle.message("error.adding.module.to.project", ex.getMessage()), IdeBundle.message("title.add.module", new Object[0]));
            }
        }
        return (Module)result.get();
    }

    public static void deleteModuleFile(String moduleFilePath) {
        VirtualFile file;
        File moduleFile = new File(moduleFilePath);
        if (moduleFile.exists()) {
            FileUtil.delete((File)moduleFile);
        }
        if ((file = LocalFileSystem.getInstance().findFileByIoFile(moduleFile)) != null) {
            file.refresh(false, false);
        }
    }

    public Icon getBigIcon() {
        return this.getModuleType().getBigIcon();
    }

    public String getDescription() {
        return this.getModuleType().getDescription();
    }

    public String getPresentableName() {
        return this.getModuleType().getName();
    }

    public static abstract class ModuleConfigurationUpdater {
        public abstract void update(@NotNull Module var1, @NotNull ModifiableRootModel var2);
    }
}

