/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.frameworkSupport;

import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProviderBase;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkSupportConfigurableBase
extends FrameworkSupportConfigurable {
    private JComboBox myVersionComboBox;
    private final FrameworkSupportProviderBase myFrameworkSupportProvider;
    private JPanel myMainPanel;
    private JLabel myDescriptionLabel;

    public FrameworkSupportConfigurableBase(FrameworkSupportProviderBase frameworkSupportProvider) {
        this(frameworkSupportProvider, Collections.emptyList(), null);
    }

    public FrameworkSupportConfigurableBase(FrameworkSupportProviderBase frameworkSupportProvider, List<FrameworkVersion> versions, String versionLabelText) {
        this.myFrameworkSupportProvider = frameworkSupportProvider;
        this.$$$setupUI$$$();
        if (versions.size() > 0) {
            this.myDescriptionLabel.setText(versionLabelText);
            String maxValue = "";
            FrameworkVersion defaultVersion = versions.get(versions.size() - 1);
            for (FrameworkVersion version : versions) {
                this.myVersionComboBox.addItem(version);
                FontMetrics fontMetrics = this.myVersionComboBox.getFontMetrics(this.myVersionComboBox.getFont());
                if (fontMetrics.stringWidth(version.getVersionName()) > fontMetrics.stringWidth(maxValue)) {
                    maxValue = version.getVersionName();
                }
                if (!version.isDefault()) continue;
                defaultVersion = version;
            }
            this.myVersionComboBox.setPrototypeDisplayValue(maxValue + "_");
            this.myVersionComboBox.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof FrameworkVersion) {
                        this.setText(((FrameworkVersion)value).getVersionName());
                    }
                    return component;
                }
            });
            this.myVersionComboBox.setSelectedItem(defaultVersion);
            this.myVersionComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameworkSupportConfigurableBase.this.fireFrameworkVersionChanged();
                }
            });
        } else {
            this.myDescriptionLabel.setVisible(false);
            this.myVersionComboBox.setVisible(false);
        }
    }

    @Override
    public JComponent getComponent() {
        return this.myMainPanel;
    }

    @NotNull
    public LibraryInfo[] getLibraries() {
        LibraryInfo[] libraryInfoArray = this.getSelectedVersion().getLibraries();
        if (libraryInfoArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/frameworkSupport/FrameworkSupportConfigurableBase.getLibraries must not return null");
        }
        return libraryInfoArray;
    }

    @Override
    public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @Nullable Library library) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/frameworkSupport/FrameworkSupportConfigurableBase.addSupport must not be null");
        }
        if (rootModel == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/util/frameworkSupport/FrameworkSupportConfigurableBase.addSupport must not be null");
        }
        this.myFrameworkSupportProvider.addSupport(module, rootModel, this.getSelectedVersion(), library);
    }

    @Override
    public FrameworkVersion getSelectedVersion() {
        return (FrameworkVersion)this.myVersionComboBox.getSelectedItem();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JLabel jLabel;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), 2, -1, false, false));
        this.myDescriptionLabel = jLabel = new JLabel();
        jLabel.setText("Version:");
        jLabel.setDisplayedMnemonic('V');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myVersionComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

