/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JTextField;

public class BrowseFilesListener
implements ActionListener {
    private final JTextField myTextField;
    private final String myTitle;
    private final String myDescription;
    private final FileChooserDescriptor myChooserDescriptor;
    public static final FileChooserDescriptor SINGLE_DIRECTORY_DESCRIPTOR = new FileChooserDescriptor(false, true, false, false, false, false);
    public static final FileChooserDescriptor SINGLE_FILE_DESCRIPTOR = new FileChooserDescriptor(true, false, false, false, false, false);

    public BrowseFilesListener(JTextField textField, String title, String description, FileChooserDescriptor chooserDescriptor) {
        this.myTextField = textField;
        this.myTitle = title;
        this.myDescription = description;
        this.myChooserDescriptor = chooserDescriptor;
    }

    protected VirtualFile getFileToSelect() {
        String path = this.myTextField.getText().trim().replace(File.separatorChar, '/');
        if (path.length() > 0) {
            File file;
            for (file = new File(path); file != null && !file.exists(); file = file.getParentFile()) {
            }
            if (file != null) {
                return LocalFileSystem.getInstance().findFileByIoFile(file);
            }
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        VirtualFile[] files;
        VirtualFile fileToSelect = this.getFileToSelect();
        this.myChooserDescriptor.setTitle(this.myTitle);
        this.myChooserDescriptor.setDescription(this.myDescription);
        VirtualFile[] virtualFileArray = files = fileToSelect != null ? FileChooser.chooseFiles(this.myTextField, this.myChooserDescriptor, fileToSelect) : FileChooser.chooseFiles(this.myTextField, this.myChooserDescriptor);
        if (files != null && files.length > 0) {
            this.myTextField.setText(files[0].getPath().replace('/', File.separatorChar));
        }
    }
}

