/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet;

import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.annotations.NotNull;

public class Facet<C extends FacetConfiguration>
extends UserDataHolderBase
implements UserDataHolder,
Disposable {
    public static final Facet[] EMPTY_ARRAY = new Facet[0];
    @NotNull
    private final FacetType myFacetType;
    @NotNull
    private final Module myModule;
    @NotNull
    private final C myConfiguration;
    private final Facet myUnderlyingFacet;
    private String myName;
    private boolean myImplicit;
    private boolean isDisposed;

    public Facet(@NotNull FacetType facetType, @NotNull Module module, @NotNull String name, @NotNull C configuration, Facet underlyingFacet) {
        if (facetType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/Facet.<init> must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/Facet.<init> must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/Facet.<init> must not be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/facet/Facet.<init> must not be null");
        }
        this.myName = name;
        this.myFacetType = facetType;
        this.myModule = module;
        this.myConfiguration = configuration;
        this.myUnderlyingFacet = underlyingFacet;
        Disposer.register((Disposable)this.myModule, (Disposable)this);
    }

    @NotNull
    public final FacetType getType() {
        FacetType facetType = this.myFacetType;
        if (facetType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/Facet.getType must not return null");
        }
        return facetType;
    }

    public final FacetTypeId getTypeId() {
        return this.myFacetType.getId();
    }

    public final Facet getUnderlyingFacet() {
        return this.myUnderlyingFacet;
    }

    @NotNull
    public final C getConfiguration() {
        C c = this.myConfiguration;
        if (c == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/Facet.getConfiguration must not return null");
        }
        return c;
    }

    @NotNull
    public final Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/Facet.getModule must not return null");
        }
        return module;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Deprecated
    public final boolean isImplicit() {
        return this.myImplicit;
    }

    @Deprecated
    public final void setImplicit(boolean implicit) {
        this.myImplicit = implicit;
    }

    public void initFacet() {
    }

    public void disposeFacet() {
    }

    public final void dispose() {
        assert (!this.isDisposed);
        this.isDisposed = true;
        this.disposeFacet();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    @NotNull
    public final String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/Facet.getName must not return null");
        }
        return string;
    }

    final void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/Facet.setName must not be null");
        }
        this.myName = name;
    }
}

