/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightDisplayKey {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.HighlightDisplayKey");
    private static final HashMap<String, HighlightDisplayKey> ourNameToKeyMap = new HashMap();
    private static final HashMap<String, HighlightDisplayKey> ourIdToKeyMap = new HashMap();
    private static final Map<HighlightDisplayKey, String> ourKeyToDisplayNameMap = new HashMap();
    private static final Map<HighlightDisplayKey, String> ourKeyToAlternativeIDMap = new HashMap();
    private final String myName;
    private final String myID;

    public static HighlightDisplayKey find(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/HighlightDisplayKey.find must not be null");
        }
        return (HighlightDisplayKey)ourNameToKeyMap.get((Object)name);
    }

    public static HighlightDisplayKey findById(@NonNls @NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/HighlightDisplayKey.findById must not be null");
        }
        HighlightDisplayKey key = (HighlightDisplayKey)ourIdToKeyMap.get((Object)id);
        if (key != null) {
            return key;
        }
        key = (HighlightDisplayKey)ourNameToKeyMap.get((Object)id);
        if (key != null && key.getID().equals(id)) {
            return key;
        }
        return null;
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/HighlightDisplayKey.register must not be null");
        }
        if (HighlightDisplayKey.find(name) != null) {
            LOG.info("Key with name '" + name + "' already registered");
            return null;
        }
        return new HighlightDisplayKey(name);
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name, @NotNull String displayName, @NotNull @NonNls String id) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/HighlightDisplayKey.register must not be null");
        }
        if (displayName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/HighlightDisplayKey.register must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/HighlightDisplayKey.register must not be null");
        }
        if (HighlightDisplayKey.find(name) != null) {
            LOG.info("Key with name '" + name + "' already registered");
            return null;
        }
        HighlightDisplayKey highlightDisplayKey = new HighlightDisplayKey(name, id);
        ourKeyToDisplayNameMap.put(highlightDisplayKey, displayName);
        return highlightDisplayKey;
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String name, @NotNull String displayName) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/HighlightDisplayKey.register must not be null");
        }
        if (displayName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/HighlightDisplayKey.register must not be null");
        }
        return HighlightDisplayKey.register(name, displayName, name);
    }

    public static String getDisplayNameByKey(@Nullable HighlightDisplayKey key) {
        return key == null ? null : ourKeyToDisplayNameMap.get(key);
    }

    private HighlightDisplayKey(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/HighlightDisplayKey.<init> must not be null");
        }
        this(name, name);
    }

    public HighlightDisplayKey(@NonNls @NotNull String name, @NotNull @NonNls String ID2) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/HighlightDisplayKey.<init> must not be null");
        }
        if (ID2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/HighlightDisplayKey.<init> must not be null");
        }
        this.myName = name;
        this.myID = ID2;
        ourNameToKeyMap.put((Object)this.myName, (Object)this);
        if (!Comparing.equal((String)ID2, (String)name)) {
            ourIdToKeyMap.put((Object)ID2, (Object)this);
        }
    }

    public String toString() {
        return this.myName;
    }

    public String getID() {
        return this.myID;
    }

    public static HighlightDisplayKey register(@NotNull String shortName, @NotNull String displayName, @NotNull String id, String alternativeID) {
        if (shortName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/HighlightDisplayKey.register must not be null");
        }
        if (displayName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/HighlightDisplayKey.register must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/HighlightDisplayKey.register must not be null");
        }
        HighlightDisplayKey key = HighlightDisplayKey.register(shortName, displayName, id);
        if (alternativeID != null) {
            ourKeyToAlternativeIDMap.put(key, alternativeID);
        }
        return key;
    }

    public static String getAlternativeID(@NotNull HighlightDisplayKey key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/HighlightDisplayKey.getAlternativeID must not be null");
        }
        return ourKeyToAlternativeIDMap.get(key);
    }
}

