/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.CodeInsightTestCase;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.quickFix.LightQuickFixTestCase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.FileTreeAccessFilter;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class DaemonAnalyzerTestCase
extends CodeInsightTestCase {
    private final Map<String, LocalInspectionTool> myAvailableTools = new THashMap();
    private final Map<String, LocalInspectionToolWrapper> myAvailableLocalTools = new THashMap();
    private boolean toInitializeDaemon;
    private final FileTreeAccessFilter myFileTreeAccessFilter = new FileTreeAccessFilter();

    @Override
    protected void setUp() throws Exception {
        LocalInspectionTool[] tools;
        super.setUp();
        ((VirtualFilePointerManagerImpl)VirtualFilePointerManagerImpl.getInstance()).cleanupForNextTest();
        for (LocalInspectionTool tool : tools = this.configureLocalInspectionTools()) {
            this.enableInspectionTool(tool);
        }
        InspectionProfileImpl profile = new InspectionProfileImpl("Configurable"){

            @NotNull
            public ModifiableModel getModifiableModel() {
                this.mySource = this;
                1 v0 = this;
                if (v0 == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/DaemonAnalyzerTestCase$1.getModifiableModel must not return null");
                }
                return v0;
            }

            @NotNull
            public InspectionProfileEntry[] getInspectionTools(PsiElement element) {
                Collection tools = DaemonAnalyzerTestCase.this.myAvailableLocalTools.values();
                InspectionProfileEntry[] inspectionProfileEntryArray = (InspectionProfileEntry[])tools.toArray(new LocalInspectionToolWrapper[tools.size()]);
                if (inspectionProfileEntryArray == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/DaemonAnalyzerTestCase$1.getInspectionTools must not return null");
                }
                return inspectionProfileEntryArray;
            }

            public List<ToolsImpl> getAllEnabledInspectionTools() {
                ArrayList<ToolsImpl> result = new ArrayList<ToolsImpl>();
                for (InspectionProfileEntry entry : this.getInspectionTools(null)) {
                    result.add(new ToolsImpl(entry, entry.getDefaultLevel(), true));
                }
                return result;
            }

            public boolean isToolEnabled(HighlightDisplayKey key, PsiElement element) {
                return key != null && DaemonAnalyzerTestCase.this.myAvailableTools.containsKey(key.toString());
            }

            public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key, PsiElement element) {
                if (key == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/DaemonAnalyzerTestCase$1.getErrorLevel must not be null");
                }
                LocalInspectionTool localInspectionTool = (LocalInspectionTool)DaemonAnalyzerTestCase.this.myAvailableTools.get(key.toString());
                return localInspectionTool != null ? localInspectionTool.getDefaultLevel() : HighlightDisplayLevel.WARNING;
            }

            public InspectionTool getInspectionTool(@NotNull String shortName, @NotNull PsiElement element) {
                if (shortName == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/DaemonAnalyzerTestCase$1.getInspectionTool must not be null");
                }
                if (element == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/DaemonAnalyzerTestCase$1.getInspectionTool must not be null");
                }
                return (InspectionTool)DaemonAnalyzerTestCase.this.myAvailableLocalTools.get(shortName);
            }
        };
        final InspectionProfileManager inspectionProfileManager = InspectionProfileManager.getInstance();
        inspectionProfileManager.addProfile((Profile)profile);
        inspectionProfileManager.setRootProfile("Configurable");
        Disposer.register((Disposable)this.getProject(), (Disposable)new Disposable(){

            public void dispose() {
                inspectionProfileManager.deleteProfile("Configurable");
            }
        });
        InspectionProjectProfileManager.getInstance((Project)this.getProject()).updateProfile((Profile)profile);
        InspectionProjectProfileManager.getInstance((Project)this.getProject()).setProjectProfile(profile.getName());
        DaemonCodeAnalyzerImpl daemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(this.getProject());
        boolean bl = this.toInitializeDaemon = !daemonCodeAnalyzer.isInitialized();
        if (this.toInitializeDaemon) {
            daemonCodeAnalyzer.projectOpened();
        }
        ((StartupManagerImpl)StartupManagerEx.getInstanceEx((Project)this.getProject())).runStartupActivities();
        ((StartupManagerImpl)StartupManagerEx.getInstanceEx((Project)this.getProject())).runPostStartupActivities();
        DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(false);
        this.myRunCommandForTest = this.wrapInCommand();
    }

    @Override
    protected void tearDown() throws Exception {
        ((StartupManagerImpl)StartupManager.getInstance(this.getProject())).checkCleared();
        if (this.toInitializeDaemon) {
            DaemonCodeAnalyzer.getInstance(this.getProject()).projectClosed();
        }
        super.tearDown();
        ((VirtualFilePointerManagerImpl)VirtualFilePointerManagerImpl.getInstance()).assertPointersDisposed();
    }

    protected void enableInspectionTool(LocalInspectionTool tool) {
        String shortName = tool.getShortName();
        HighlightDisplayKey key = HighlightDisplayKey.find(shortName);
        if (key == null) {
            HighlightDisplayKey.register(shortName, tool.getDisplayName(), tool.getID());
        }
        this.myAvailableTools.put(shortName, tool);
        this.myAvailableLocalTools.put(shortName, new LocalInspectionToolWrapper(tool));
    }

    protected void enableInspectionToolsFromProvider(InspectionToolProvider toolProvider) {
        try {
            for (Class c : toolProvider.getInspectionClasses()) {
                this.enableInspectionTool((LocalInspectionTool)c.newInstance());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void disableInspectionTool(String shortName) {
        this.myAvailableTools.remove(shortName);
        this.myAvailableLocalTools.remove(shortName);
    }

    protected LocalInspectionTool[] configureLocalInspectionTools() {
        return new LocalInspectionTool[0];
    }

    protected static LocalInspectionTool[] createLocalInspectionTools(InspectionToolProvider ... provider) {
        ArrayList<LocalInspectionTool> result = new ArrayList<LocalInspectionTool>();
        for (InspectionToolProvider toolProvider : provider) {
            for (Class aClass : toolProvider.getInspectionClasses()) {
                try {
                    Object tool = aClass.newInstance();
                    DaemonAnalyzerTestCase.assertTrue((boolean)(tool instanceof LocalInspectionTool));
                    result.add((LocalInspectionTool)tool);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        return result.toArray(new LocalInspectionTool[result.size()]);
    }

    protected void doTest(String filePath, boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) throws Exception {
        this.configureByFile(filePath);
        this.doDoTest(checkWarnings, checkInfos, checkWeakWarnings);
    }

    protected void doTest(String filePath, boolean checkWarnings, boolean checkInfos) throws Exception {
        this.doTest(filePath, checkWarnings, checkInfos, false);
    }

    protected void doTest(@NonNls String filePath, @NonNls String projectRoot, boolean checkWarnings, boolean checkInfos) throws Exception {
        this.configureByFile(filePath, projectRoot);
        this.doDoTest(checkWarnings, checkInfos);
    }

    protected void doTest(VirtualFile vFile, boolean checkWarnings, boolean checkInfos) throws Exception {
        this.doTest(new VirtualFile[]{vFile}, checkWarnings, checkInfos);
    }

    protected void doTest(VirtualFile[] vFile, boolean checkWarnings, boolean checkInfos) throws Exception {
        this.configureByFiles(null, vFile);
        this.doDoTest(checkWarnings, checkInfos);
    }

    protected Collection<HighlightInfo> doDoTest(boolean checkWarnings, boolean checkInfos) {
        return this.doDoTest(checkWarnings, checkInfos, false);
    }

    protected Collection<HighlightInfo> doDoTest(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) {
        return this.checkHighlighting(new ExpectedHighlightingData(this.myEditor.getDocument(), checkWarnings, checkWeakWarnings, checkInfos, this.myFile));
    }

    protected Collection<HighlightInfo> checkHighlighting(ExpectedHighlightingData data) {
        PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
        TreeUtil.clearCaches((TreeElement)((TreeElement)this.myFile.getNode()));
        this.myPsiManager.getCacheManager().getFilesWithWord("XXX", (short)2, GlobalSearchScope.allScope(this.myProject), true);
        JavaPsiFacadeEx facade = this.getJavaFacade();
        if (facade != null) {
            facade.setAssertOnFileLoadingFilter((VirtualFileFilter)this.myFileTreeAccessFilter);
        }
        List<HighlightInfo> infos = this.doHighlighting();
        if (facade != null) {
            facade.setAssertOnFileLoadingFilter(VirtualFileFilter.NONE);
        }
        String text = this.myEditor.getDocument().getText();
        data.checkLineMarkers((Collection)DaemonCodeAnalyzerImpl.getLineMarkers((Document)this.getDocument(this.getFile()), (Project)this.getProject()), text);
        data.checkResult(infos, text);
        return infos;
    }

    public void allowTreeAccessForFile(VirtualFile file) {
        this.myFileTreeAccessFilter.allowTreeAccessForFile(file);
    }

    protected Collection<HighlightInfo> highlightErrors() {
        return DaemonAnalyzerTestCase.filter(this.doHighlighting(), HighlightSeverity.ERROR);
    }

    protected List<HighlightInfo> doHighlighting() {
        List infos;
        PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
        TIntArrayList toIgnore = new TIntArrayList();
        if (!this.doTestLineMarkers()) {
            toIgnore.add(6);
            toIgnore.add(10);
            toIgnore.add(11);
        }
        if (!this.doExternalValidation()) {
            toIgnore.add(8);
        }
        if (this.forceExternalValidation()) {
            toIgnore.add(11);
            toIgnore.add(7);
            toIgnore.add(3);
            toIgnore.add(5);
            toIgnore.add(4);
            toIgnore.add(2);
            toIgnore.add(6);
            toIgnore.add(10);
        }
        boolean canChange = this.canChangeDocumentDuringHighlighting();
        CodeInsightTestFixtureImpl.instantiateAndRun((PsiFile)this.getFile(), (Editor)this.getEditor(), (int[])toIgnore.toNativeArray(), (boolean)canChange);
        if (!canChange) {
            Document document = this.getDocument(this.getFile());
            ((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(this.getProject())).getFileStatusMap().assertAllDirtyScopesAreNull(document);
        }
        return (infos = DaemonCodeAnalyzerImpl.getHighlights((Document)this.getEditor().getDocument(), (Project)this.getProject())) == null ? Collections.emptyList() : new ArrayList(infos);
    }

    private boolean canChangeDocumentDuringHighlighting() {
        return this.annotatedWith(CanChangeDocumentDuringHighlighting.class);
    }

    private boolean wrapInCommand() {
        return !this.annotatedWith(DoNotWrapInCommand.class);
    }

    private boolean annotatedWith(Class annotationClass) {
        Object annotation;
        String methodName = "test" + this.getTestName(false);
        Class<?> aClass = ((Object)((Object)this)).getClass();
        if (aClass.getAnnotation(annotationClass) != null) {
            return true;
        }
        Method method = null;
        while (aClass != null) {
            try {
                method = aClass.getDeclaredMethod(methodName, new Class[0]);
                break;
            }
            catch (NoSuchMethodException e) {
                aClass = aClass.getSuperclass();
            }
        }
        if (method == null) {
            DaemonAnalyzerTestCase.fail((String)methodName);
        }
        return (annotation = method.getAnnotation(annotationClass)) != null;
    }

    public static List<HighlightInfo> filter(List<HighlightInfo> infos, HighlightSeverity minSeverity) {
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>();
        for (HighlightInfo info : infos) {
            if (info.getSeverity().compareTo(minSeverity) < 0) continue;
            result.add(info);
        }
        return result;
    }

    protected boolean doTestLineMarkers() {
        return false;
    }

    protected boolean doExternalValidation() {
        return true;
    }

    protected boolean forceExternalValidation() {
        return false;
    }

    protected static void findAndInvokeIntentionAction(Collection<HighlightInfo> infos, String intentionActionName, Editor editor, PsiFile file) throws IncorrectOperationException {
        IntentionAction intentionAction = DaemonAnalyzerTestCase.findIntentionAction(infos, intentionActionName, editor, file);
        DaemonAnalyzerTestCase.assertNotNull((String)intentionActionName, (Object)intentionAction);
        ShowIntentionActionsHandler.chooseActionAndInvoke((PsiFile)file, (Editor)editor, (IntentionAction)intentionAction, (String)intentionActionName);
    }

    protected static IntentionAction findIntentionAction(Collection<HighlightInfo> infos, String intentionActionName, Editor editor, PsiFile file) {
        List<IntentionAction> actions = LightQuickFixTestCase.getAvailableActions(editor, file);
        IntentionAction intentionAction = LightQuickFixTestCase.findActionWithText(actions, intentionActionName);
        if (intentionAction == null) {
            ArrayList<IntentionAction> availableActions = new ArrayList<IntentionAction>();
            for (HighlightInfo info : infos) {
                if (info.quickFixActionRanges == null) continue;
                for (Pair pair : info.quickFixActionRanges) {
                    IntentionAction action = ((HighlightInfo.IntentionActionDescriptor)pair.first).getAction();
                    if (!action.isAvailable(file.getProject(), editor, file)) continue;
                    availableActions.add(action);
                }
            }
            intentionAction = LightQuickFixTestCase.findActionWithText(availableActions, intentionActionName);
        }
        return intentionAction;
    }

    public void checkHighlighting(Editor editor, boolean checkWarnings, boolean checkInfos) {
        this.setActiveEditor(editor);
        this.doDoTest(checkWarnings, checkInfos);
    }

    public PsiClass createClass(String text) throws IOException {
        return this.createClass(this.myModule, text);
    }

    protected PsiClass createClass(Module module, String text) throws IOException {
        File dir;
        String qname = ((PsiJavaFile)PsiFileFactory.getInstance(this.getProject()).createFileFromText("a.java", text)).getClasses()[0].getQualifiedName();
        VirtualFile[] files = ModuleRootManager.getInstance(module).getSourceRoots();
        if (files.length > 0) {
            dir = VfsUtil.virtualToIoFile(files[0]);
        } else {
            dir = this.createTempDirectory();
            VirtualFile vDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(dir.getCanonicalPath().replace(File.separatorChar, '/'));
            this.addSourceContentToRoots(module, vDir);
        }
        File file = new File(dir, qname.replace('.', '/') + ".java");
        FileUtil.createIfDoesntExist((File)file);
        VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(file.getCanonicalPath().replace(File.separatorChar, '/'));
        VfsUtil.saveText(vFile, text);
        return ((PsiJavaFile)this.myPsiManager.findFile(vFile)).getClasses()[0];
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface DoNotWrapInCommand {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface CanChangeDocumentDuringHighlighting {
    }
}

