/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.util;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.annotations.Nullable;

public abstract class ParenthesesInsertHandler<T extends LookupElement>
implements InsertHandler<T> {
    public static final ParenthesesInsertHandler<LookupElement> WITH_PARAMETERS = new ParenthesesInsertHandler<LookupElement>(){

        @Override
        protected boolean placeCaretInsideParentheses(InsertionContext context, LookupElement item) {
            return true;
        }
    };
    public static final ParenthesesInsertHandler<LookupElement> NO_PARAMETERS = new ParenthesesInsertHandler<LookupElement>(){

        @Override
        protected boolean placeCaretInsideParentheses(InsertionContext context, LookupElement item) {
            return false;
        }
    };
    private final boolean mySpaceBeforeParentheses;
    private final boolean mySpaceBetweenParentheses;
    private final boolean myInsertRightParenthesis;

    public static ParenthesesInsertHandler<LookupElement> getInstance(boolean hasParameters) {
        return hasParameters ? WITH_PARAMETERS : NO_PARAMETERS;
    }

    protected ParenthesesInsertHandler(boolean spaceBeforeParentheses, boolean spaceBetweenParentheses, boolean insertRightParenthesis) {
        this.mySpaceBeforeParentheses = spaceBeforeParentheses;
        this.mySpaceBetweenParentheses = spaceBetweenParentheses;
        this.myInsertRightParenthesis = insertRightParenthesis;
    }

    protected ParenthesesInsertHandler() {
        this(false, false, true);
    }

    private static boolean isToken(@Nullable PsiElement element, String text) {
        return element != null && text.equals(element.getText());
    }

    protected abstract boolean placeCaretInsideParentheses(InsertionContext var1, T var2);

    @Override
    public void handleInsert(InsertionContext context, T item) {
        int tailOffset;
        boolean putCaretInside;
        Editor editor = context.getEditor();
        Document document = editor.getDocument();
        PsiElement element = this.findNextToken(context);
        char completionChar = context.getCompletionChar();
        boolean bl = putCaretInside = completionChar == '(' || this.placeCaretInsideParentheses(context, item);
        if (completionChar == '(') {
            context.setAddCompletionChar(false);
        }
        if (ParenthesesInsertHandler.isToken(element, "(")) {
            int lparenthOffset = element.getTextRange().getStartOffset();
            if (this.mySpaceBeforeParentheses && lparenthOffset == context.getTailOffset()) {
                document.insertString(context.getTailOffset(), " ");
                ++lparenthOffset;
            }
            if (completionChar == '(' || completionChar == '\t') {
                editor.getCaretModel().moveToOffset(lparenthOffset + 1);
            } else {
                editor.getCaretModel().moveToOffset(context.getTailOffset());
            }
            context.setTailOffset(lparenthOffset + 1);
            PsiElement list = element.getParent();
            PsiElement last = list.getLastChild();
            if (ParenthesesInsertHandler.isToken(last, ")")) {
                int rparenthOffset = last.getTextRange().getStartOffset();
                context.setTailOffset(rparenthOffset + 1);
                if (!putCaretInside) {
                    for (int i = lparenthOffset + 1; i < rparenthOffset; ++i) {
                        if (Character.isWhitespace(document.getCharsSequence().charAt(i))) continue;
                        return;
                    }
                    editor.getCaretModel().moveToOffset(context.getTailOffset());
                } else if (this.mySpaceBetweenParentheses && document.getCharsSequence().charAt(lparenthOffset) == ' ') {
                    editor.getCaretModel().moveToOffset(lparenthOffset + 2);
                } else {
                    editor.getCaretModel().moveToOffset(lparenthOffset + 1);
                }
                return;
            }
        } else {
            tailOffset = context.getTailOffset();
            if (this.mySpaceBeforeParentheses) {
                tailOffset = TailType.insertChar(editor, tailOffset, ' ');
            }
            tailOffset = TailType.insertChar(editor, tailOffset, '(');
            if (this.mySpaceBetweenParentheses) {
                tailOffset = TailType.insertChar(editor, tailOffset, ' ');
            }
        }
        if (!this.myInsertRightParenthesis) {
            return;
        }
        int caret = tailOffset = context.getTailOffset();
        if (this.mySpaceBetweenParentheses) {
            tailOffset = TailType.insertChar(editor, tailOffset, ' ');
        }
        document.insertString(tailOffset, ")");
        editor.getCaretModel().moveToOffset(putCaretInside ? caret : context.getTailOffset());
    }

    @Nullable
    protected PsiElement findNextToken(InsertionContext context) {
        PsiFile file = context.getFile();
        PsiElement element = file.findElementAt(context.getTailOffset());
        if (element instanceof PsiWhiteSpace) {
            element = file.findElementAt(element.getTextRange().getEndOffset());
        }
        return element;
    }
}

