/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;

class PropertyAccessor
implements Accessor {
    private final PropertyDescriptor myPropertyDescriptor;

    public PropertyAccessor(PropertyDescriptor myPropertyDescriptor) {
        this.myPropertyDescriptor = myPropertyDescriptor;
    }

    @Override
    public Object read(Object o) {
        try {
            return this.myPropertyDescriptor.getReadMethod().invoke(o, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new XmlSerializationException(e);
        }
    }

    @Override
    public void write(Object o, Object value) {
        try {
            this.myPropertyDescriptor.getWriteMethod().invoke(o, XmlSerializerImpl.convert(value, this.myPropertyDescriptor.getPropertyType()));
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new XmlSerializationException(e);
        }
    }

    @Override
    public Annotation[] getAnnotations() {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        if (this.myPropertyDescriptor.getReadMethod() != null) {
            result.addAll(Arrays.asList(this.myPropertyDescriptor.getReadMethod().getAnnotations()));
        }
        if (this.myPropertyDescriptor.getWriteMethod() != null) {
            result.addAll(Arrays.asList(this.myPropertyDescriptor.getWriteMethod().getAnnotations()));
        }
        return result.toArray(new Annotation[result.size()]);
    }

    @Override
    public String getName() {
        return this.myPropertyDescriptor.getName();
    }

    @Override
    public Class<?> getValueClass() {
        return this.myPropertyDescriptor.getPropertyType();
    }

    @Override
    public Type getGenericType() {
        return this.myPropertyDescriptor.getReadMethod().getGenericReturnType();
    }

    @NonNls
    public String toString() {
        return "PropertyAccessor[" + this.myPropertyDescriptor.getReadMethod().getDeclaringClass().getName() + "." + this.getName() + "]";
    }
}

