/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Set;

public class CollectionFactory {
    private CollectionFactory() {
    }

    public static <T> Set<T> newTroveSet(T ... elements) {
        return CollectionFactory.newTroveSet(Arrays.asList(elements));
    }

    public static <T> Set<T> newTroveSet(Collection<T> elements) {
        return new THashSet(elements);
    }

    public static <T> T[] ar(T ... elements) {
        return elements;
    }

    public static <T, V> THashMap<T, V> newTroveMap() {
        return new THashMap();
    }

    public static <T> ArrayList<T> arrayList() {
        return new ArrayList();
    }

    public static <T, V> LinkedHashMap<T, V> linkedMap() {
        return new LinkedHashMap();
    }
}

