/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.psi.UpdatePsiFileCopyright;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class UpdateJavaFileCopyright
extends UpdatePsiFileCopyright {
    private static final Logger logger = Logger.getInstance((String)UpdateJavaFileCopyright.class.getName());

    public UpdateJavaFileCopyright(Project project, Module module, VirtualFile root, CopyrightProfile options) {
        super(project, module, root, options);
    }

    @Override
    protected boolean accept() {
        return this.getFile() instanceof PsiJavaFile;
    }

    @Override
    protected void scanFile() {
        logger.debug("updating " + this.getFile().getVirtualFile());
        PsiClassOwner javaFile = (PsiClassOwner)this.getFile();
        PsiElement pkg = this.getPackageStatement();
        PsiElement[] imports = this.getImportsList();
        PsiClass topclass = null;
        PsiClass[] classes = javaFile.getClasses();
        if (classes.length > 0) {
            topclass = classes[0];
        }
        PsiElement first = javaFile.getFirstChild();
        int location = this.getLanguageOptions().getFileLocation();
        if (pkg != null) {
            this.checkComments(first, pkg, location == 1);
            first = pkg;
        } else if (location == 1) {
            location = 2;
        }
        if (imports != null && imports.length > 0) {
            this.checkComments(first, imports[0], location == 2);
            first = imports[0];
        } else if (location == 2) {
            location = 3;
        }
        if (topclass != null) {
            ArrayList<PsiComment> comments = new ArrayList<PsiComment>();
            this.collectComments(first, (PsiElement)topclass, comments);
            this.collectComments(topclass.getFirstChild(), (PsiElement)topclass.getModifierList(), comments);
            this.checkComments((PsiElement)topclass.getModifierList(), location == 3, comments);
        } else if (location == 3) {
            // empty if block
        }
    }

    @Nullable
    protected PsiElement[] getImportsList() {
        PsiJavaFile javaFile = (PsiJavaFile)this.getFile();
        assert (javaFile != null);
        PsiImportList importList = javaFile.getImportList();
        return importList == null ? null : importList.getChildren();
    }

    @Nullable
    protected PsiElement getPackageStatement() {
        PsiJavaFile javaFile = (PsiJavaFile)this.getFile();
        assert (javaFile != null);
        return javaFile.getPackageStatement();
    }
}

