/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.editor.ResourceBundleFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleEditorProvider
extends FileTypeFactory
implements FileEditorProvider,
DumbAware {
    private static final ResourceBundleFileType RESOURCE_BUNDLE_FILE_TYPE = new ResourceBundleFileType();

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/editor/ResourceBundleEditorProvider.accept must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/properties/editor/ResourceBundleEditorProvider.accept must not be null");
        }
        if (file instanceof ResourceBundleAsVirtualFile) {
            return true;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        return psiFile instanceof PropertiesFile && ((PropertiesFile)psiFile).getResourceBundle().getPropertiesFiles(project).size() > 1;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        ResourceBundle resourceBundle;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/editor/ResourceBundleEditorProvider.createEditor must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/properties/editor/ResourceBundleEditorProvider.createEditor must not be null");
        }
        if (file instanceof ResourceBundleAsVirtualFile) {
            resourceBundle = ((ResourceBundleAsVirtualFile)file).getResourceBundle();
        } else {
            PropertiesFile psiFile = (PropertiesFile)PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile == null) {
                throw new IllegalArgumentException("psifile cannot be null");
            }
            resourceBundle = psiFile.getResourceBundle();
        }
        ResourceBundleEditor resourceBundleEditor = new ResourceBundleEditor(project, resourceBundle);
        if (resourceBundleEditor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/editor/ResourceBundleEditorProvider.createEditor must not return null");
        }
        return resourceBundleEditor;
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/editor/ResourceBundleEditorProvider.disposeEditor must not be null");
        }
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element element, @NotNull Project project, @NotNull VirtualFile file) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/editor/ResourceBundleEditorProvider.readState must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/properties/editor/ResourceBundleEditorProvider.readState must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/lang/properties/editor/ResourceBundleEditorProvider.readState must not be null");
        }
        ResourceBundleEditor.ResourceBundleEditorState resourceBundleEditorState = new ResourceBundleEditor.ResourceBundleEditorState(null);
        if (resourceBundleEditorState == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/editor/ResourceBundleEditorProvider.readState must not return null");
        }
        return resourceBundleEditorState;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element element) {
        if (state == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/editor/ResourceBundleEditorProvider.writeState must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/properties/editor/ResourceBundleEditorProvider.writeState must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/lang/properties/editor/ResourceBundleEditorProvider.writeState must not be null");
        }
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/editor/ResourceBundleEditorProvider.getPolicy must not return null");
        }
        return fileEditorPolicy;
    }

    @NotNull
    public String getEditorTypeId() {
        if ("ResourceBundle" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/editor/ResourceBundleEditorProvider.getEditorTypeId must not return null");
        }
        return "ResourceBundle";
    }

    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/editor/ResourceBundleEditorProvider.createFileTypes must not be null");
        }
        consumer.consume((FileType)RESOURCE_BUNDLE_FILE_TYPE, "");
    }
}

