/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.openapi.module.Module;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.FeedbackLayer;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadComponentFactory;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadLayoutManager;
import com.intellij.uiDesigner.snapShooter.SnapshotContext;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RadScrollPane
extends RadContainer {
    public static final Class COMPONENT_CLASS = JScrollPane.class;

    public RadScrollPane(Module module, Class componentClass, String id) {
        super(module, componentClass, id);
    }

    public RadScrollPane(Class componentClass, String id, Palette palette) {
        super(componentClass, id, palette);
    }

    @Override
    @Nullable
    protected RadLayoutManager createInitialLayoutManager() {
        return new RadScrollPaneLayoutManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(XmlWriter writer) {
        writer.startElement("scrollpane");
        try {
            this.writeNoLayout(writer, JScrollPane.class.getName());
        }
        finally {
            writer.endElement();
        }
    }

    @Override
    public RadComponent getActionTargetComponent(RadComponent child) {
        return this;
    }

    @Override
    protected void importSnapshotComponent(SnapshotContext context, JComponent component) {
        RadComponent childComponent;
        JScrollPane scrollPane = (JScrollPane)component;
        Component view = scrollPane.getViewport().getView();
        if (view instanceof JComponent && (childComponent = RadScrollPane.createSnapshotComponent(context, (JComponent)view)) != null) {
            this.addComponent(childComponent);
        }
    }

    private class MyDropLocation
    implements ComponentDropLocation {
        private MyDropLocation() {
        }

        @Override
        public RadContainer getContainer() {
            return RadScrollPane.this;
        }

        @Override
        public boolean canDrop(ComponentDragObject dragObject) {
            return dragObject.getComponentCount() == 1 && RadScrollPane.this.getComponentCount() == 0;
        }

        @Override
        public void placeFeedback(FeedbackLayer feedbackLayer, ComponentDragObject dragObject) {
            feedbackLayer.putFeedback(RadScrollPane.this.getDelegee(), new Rectangle(0, 0, RadScrollPane.this.getWidth(), RadScrollPane.this.getHeight()), RadScrollPane.this.getDisplayName());
        }

        @Override
        public void processDrop(GuiEditor editor, RadComponent[] components, GridConstraints[] constraintsToAdjust, ComponentDragObject dragObject) {
            RadScrollPane.this.addComponent(components[0]);
        }

        @Override
        @Nullable
        public ComponentDropLocation getAdjacentLocation(ComponentDropLocation.Direction direction) {
            return null;
        }
    }

    private class RadScrollPaneLayoutManager
    extends RadLayoutManager {
        private MyDropLocation myDropLocation = null;

        private RadScrollPaneLayoutManager() {
        }

        @Override
        @Nullable
        public String getName() {
            return null;
        }

        @Override
        public void writeChildConstraints(XmlWriter writer, RadComponent child) {
        }

        @Override
        @NotNull
        public ComponentDropLocation getDropLocation(RadContainer container, @Nullable Point location) {
            if (this.myDropLocation == null) {
                this.myDropLocation = new MyDropLocation();
            }
            MyDropLocation myDropLocation = this.myDropLocation;
            if (myDropLocation == null) {
                throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/radComponents/RadScrollPane$RadScrollPaneLayoutManager.getDropLocation must not return null");
            }
            return myDropLocation;
        }

        @Override
        public void addComponentToContainer(RadContainer container, RadComponent component, int index) {
            JScrollPane scrollPane = (JScrollPane)container.getDelegee();
            JComponent delegee = component.getDelegee();
            delegee.setLocation(0, 0);
            scrollPane.setViewportView(delegee);
        }

        @Override
        public void removeComponentFromContainer(RadContainer container, RadComponent component) {
            JScrollPane scrollPane = (JScrollPane)container.getDelegee();
            scrollPane.setViewportView(null);
        }
    }

    public static class Factory
    extends RadComponentFactory {
        @Override
        public RadComponent newInstance(Module module, Class aClass, String id) {
            return new RadScrollPane(module, aClass, id);
        }

        @Override
        public RadComponent newInstance(Class componentClass, String id, Palette palette) {
            return new RadScrollPane(componentClass, id, palette);
        }
    }
}

