/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.componentTree.ComponentTree;
import com.intellij.uiDesigner.componentTree.ComponentTreeBuilder;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.editor.UIFormEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyInspector;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UIDesignerToolWindowManager
implements ProjectComponent {
    private final Project myProject;
    private MyToolWindowPanel myToolWindowPanel;
    private ComponentTree myComponentTree;
    private ComponentTreeBuilder myComponentTreeBuilder;
    private PropertyInspector myPropertyInspector;
    private final FileEditorManager myFileEditorManager;
    private ToolWindow myToolWindow;
    private boolean myToolWindowReady = false;
    private boolean myToolWindowDisposed = false;
    private List<TreeSelectionListener> myPendingListeners = new ArrayList<TreeSelectionListener>();
    private final MergingUpdateQueue myQueue = new MergingUpdateQueue("property.inspector", 200, true, null);

    public UIDesignerToolWindowManager(Project project, FileEditorManager fileEditorManager) {
        this.myProject = project;
        this.myFileEditorManager = fileEditorManager;
        MyFileEditorManagerListener listener = new MyFileEditorManagerListener();
        this.myFileEditorManager.addFileEditorManagerListener((FileEditorManagerListener)listener, (Disposable)project);
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(new Runnable(){

            @Override
            public void run() {
                UIDesignerToolWindowManager.this.myToolWindowReady = true;
            }
        });
    }

    private void checkInitToolWindow() {
        if (this.myToolWindowReady && !this.myToolWindowDisposed && this.myToolWindow == null) {
            this.initToolWindow();
        }
    }

    private void initToolWindow() {
        this.myToolWindowPanel = new MyToolWindowPanel();
        this.myComponentTree = new ComponentTree(this.myProject);
        for (TreeSelectionListener listener : this.myPendingListeners) {
            this.myComponentTree.addTreeSelectionListener(listener);
        }
        this.myPendingListeners.clear();
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.myComponentTree));
        scrollPane.setPreferredSize(new Dimension(250, -1));
        this.myComponentTree.initQuickFixManager(scrollPane.getViewport());
        this.myPropertyInspector = new PropertyInspector(this.myProject, this.myComponentTree);
        this.myToolWindowPanel.setFirstComponent(scrollPane);
        this.myToolWindowPanel.setSecondComponent(this.myPropertyInspector);
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(UIDesignerBundle.message("toolwindow.ui.designer", new Object[0]), (JComponent)((Object)this.myToolWindowPanel), ToolWindowAnchor.LEFT, (Disposable)this.myProject, true);
        this.myToolWindow.setIcon(IconLoader.getIcon((String)"/com/intellij/uiDesigner/icons/toolWindowUIDesigner.png"));
        this.myToolWindow.setAvailable(false, null);
    }

    public void projectClosed() {
        if (this.myToolWindowPanel != null) {
            if (this.myComponentTreeBuilder != null) {
                Disposer.dispose((Disposable)this.myComponentTreeBuilder);
            }
            this.myToolWindowPanel = null;
            this.myToolWindow = null;
            this.myToolWindowDisposed = true;
        }
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("UIDesignerToolWindowManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/propertyInspector/UIDesignerToolWindowManager.getComponentName must not return null");
        }
        return "UIDesignerToolWindowManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private void processFileEditorChange(final UIFormEditor newEditor) {
        this.myQueue.cancelAllUpdates();
        this.myQueue.queue(new Update("update"){

            public void run() {
                GuiEditor activeFormEditor;
                if (!UIDesignerToolWindowManager.this.myToolWindowReady || UIDesignerToolWindowManager.this.myToolWindowDisposed) {
                    return;
                }
                GuiEditor guiEditor = activeFormEditor = newEditor != null ? newEditor.getEditor() : null;
                if (UIDesignerToolWindowManager.this.myToolWindow == null) {
                    if (activeFormEditor == null) {
                        return;
                    }
                    UIDesignerToolWindowManager.this.initToolWindow();
                }
                if (UIDesignerToolWindowManager.this.myComponentTreeBuilder != null) {
                    Disposer.dispose((Disposable)UIDesignerToolWindowManager.this.myComponentTreeBuilder);
                    UIDesignerToolWindowManager.this.myComponentTreeBuilder = null;
                }
                UIDesignerToolWindowManager.this.myComponentTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
                UIDesignerToolWindowManager.this.myComponentTree.setEditor(activeFormEditor);
                UIDesignerToolWindowManager.this.myComponentTree.setFormEditor(newEditor);
                UIDesignerToolWindowManager.this.myPropertyInspector.setEditor(activeFormEditor);
                if (activeFormEditor == null) {
                    UIDesignerToolWindowManager.this.myToolWindow.setAvailable(false, null);
                } else {
                    UIDesignerToolWindowManager.this.myComponentTreeBuilder = new ComponentTreeBuilder(UIDesignerToolWindowManager.this.myComponentTree, activeFormEditor);
                    UIDesignerToolWindowManager.this.myToolWindow.setAvailable(true, null);
                    UIDesignerToolWindowManager.this.myToolWindow.show(null);
                }
            }
        });
    }

    @Nullable
    public UIFormEditor getActiveFormFileEditor() {
        FileEditor[] fileEditors = this.myFileEditorManager.getSelectedEditors();
        if (fileEditors.length > 0 && fileEditors[0] instanceof UIFormEditor) {
            return (UIFormEditor)fileEditors[0];
        }
        return null;
    }

    @Nullable
    public GuiEditor getActiveFormEditor() {
        UIFormEditor formEditor = this.getActiveFormFileEditor();
        return formEditor == null ? null : formEditor.getEditor();
    }

    public static UIDesignerToolWindowManager getInstance(Project project) {
        return (UIDesignerToolWindowManager)project.getComponent(UIDesignerToolWindowManager.class);
    }

    public ComponentTree getComponentTree() {
        this.checkInitToolWindow();
        return this.myComponentTree;
    }

    public ComponentTreeBuilder getComponentTreeBuilder() {
        return this.myComponentTreeBuilder;
    }

    public PropertyInspector getPropertyInspector() {
        return this.myPropertyInspector;
    }

    public void refreshErrors() {
        this.myComponentTree.refreshIntentionHint();
        this.myComponentTree.repaint(this.myComponentTree.getVisibleRect());
        this.myPropertyInspector.refreshIntentionHint();
        this.myPropertyInspector.repaint(this.myPropertyInspector.getVisibleRect());
    }

    public void updateComponentTree() {
        this.myComponentTreeBuilder.updateFromRoot();
    }

    public void addComponentSelectionListener(TreeSelectionListener treeSelectionListener) {
        if (this.myComponentTree != null) {
            this.myComponentTree.addTreeSelectionListener(treeSelectionListener);
        } else {
            this.myPendingListeners.add(treeSelectionListener);
        }
    }

    private class MyToolWindowPanel
    extends Splitter
    implements DataProvider {
        MyToolWindowPanel() {
            super(true, 0.33f);
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (GuiEditor.DATA_KEY.is(dataId)) {
                return UIDesignerToolWindowManager.this.getActiveFormEditor();
            }
            return null;
        }
    }

    private class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(FileEditorManager source, VirtualFile file) {
            UIDesignerToolWindowManager.this.processFileEditorChange(UIDesignerToolWindowManager.this.getActiveFormFileEditor());
        }

        public void fileClosed(FileEditorManager source, VirtualFile file) {
            UIDesignerToolWindowManager.this.processFileEditorChange(UIDesignerToolWindowManager.this.getActiveFormFileEditor());
        }

        public void selectionChanged(FileEditorManagerEvent event) {
            UIFormEditor newEditor = event.getNewEditor() instanceof UIFormEditor ? (UIFormEditor)event.getNewEditor() : null;
            UIDesignerToolWindowManager.this.processFileEditorChange(newEditor);
        }
    }
}

