/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.actions.AbstractGuiEditorAction;
import com.intellij.uiDesigner.actions.PaletteListPopupStep;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.GridDropLocation;
import com.intellij.uiDesigner.designSurface.GridInsertLocation;
import com.intellij.uiDesigner.designSurface.GridInsertMode;
import com.intellij.uiDesigner.designSurface.GridInsertProcessor;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.util.Processor;
import java.awt.Component;
import java.awt.Point;
import java.util.List;

public class CreateComponentAction
extends AbstractGuiEditorAction {
    private ComponentItem myLastCreatedComponent = null;

    @Override
    protected void actionPerformed(final GuiEditor editor, final List<RadComponent> selection, AnActionEvent e) {
        Processor<ComponentItem> processor = new Processor<ComponentItem>(){

            public boolean process(ComponentItem selectedValue) {
                CreateComponentAction.this.myLastCreatedComponent = selectedValue;
                editor.getMainProcessor().startInsertProcessor(selectedValue, CreateComponentAction.getCreateLocation(editor, selection));
                return true;
            }
        };
        PaletteListPopupStep step = new PaletteListPopupStep(editor, this.myLastCreatedComponent, processor, UIDesignerBundle.message("create.component.title", new Object[0]));
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        if (selection.size() > 0) {
            FormEditingUtil.showPopupUnderComponent((JBPopup)listPopup, selection.get(0));
        } else {
            listPopup.showInCenterOf((Component)editor.getRootContainer().getDelegee());
        }
    }

    private static ComponentDropLocation getCreateLocation(GuiEditor editor, List<RadComponent> selection) {
        RadComponent component;
        RadContainer container;
        ComponentDropLocation dropLocation = null;
        if (selection.size() > 0 && (container = (component = selection.get(0)).getParent()).getLayoutManager().isGrid()) {
            GridConstraints c = component.getConstraints();
            int nextCol = FormEditingUtil.adjustForGap(component.getParent(), c.getColumn() + c.getColSpan(), false, 1);
            int nextRow = FormEditingUtil.adjustForGap(component.getParent(), c.getRow() + c.getRowSpan(), true, 1);
            dropLocation = nextCol < container.getGridColumnCount() && container.getComponentAtGrid(c.getRow(), nextCol) == null ? new GridDropLocation(container, c.getRow(), nextCol) : (nextRow < container.getGridRowCount() && container.getComponentAtGrid(nextRow, c.getColumn()) == null ? new GridDropLocation(container, nextRow, c.getColumn()) : new GridInsertLocation(container, c.getRow() + c.getRowSpan() - 1, c.getColumn(), GridInsertMode.RowAfter));
        }
        if (dropLocation == null) {
            RadContainer childContainer;
            Point mousePosition = editor.getMainProcessor().getLastMousePosition();
            if (mousePosition != null) {
                container = GridInsertProcessor.getDropTargetContainer(editor.getRootContainer(), mousePosition);
                if (container == null) {
                    container = editor.getRootContainer();
                }
                if (container instanceof RadRootContainer && container.getComponentCount() == 1 && container.getComponent(0) instanceof RadContainer) {
                    childContainer = (RadContainer)container.getComponent(0);
                    dropLocation = childContainer.getDropLocation(null);
                } else {
                    dropLocation = GridInsertProcessor.getDropLocation(editor.getRootContainer(), mousePosition);
                }
            } else {
                container = editor.getRootContainer();
                if (container.getComponentCount() == 1 && container.getComponent(0) instanceof RadContainer) {
                    childContainer = (RadContainer)container.getComponent(0);
                    dropLocation = childContainer.getDropLocation(null);
                } else {
                    dropLocation = container.getDropLocation(null);
                }
            }
        }
        return dropLocation;
    }
}

