/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.idea.svn.integrate.Splitter;

public class GroupSplitter
extends Splitter {
    private final List<Integer> myList = new LinkedList<Integer>();
    private int myCnt = 0;

    public GroupSplitter(List<CommittedChangeList> lists) {
        super(lists);
        if (lists.isEmpty()) {
            return;
        }
        int currentPackSize = 1;
        for (int i = 1; i < lists.size(); ++i) {
            CommittedChangeList list = lists.get(i);
            if (list.getNumber() != lists.get(i - 1).getNumber() + 1L) {
                this.myList.add(currentPackSize);
                currentPackSize = 1;
                continue;
            }
            ++currentPackSize;
        }
        this.myList.add(currentPackSize);
    }

    @Override
    public boolean hasNext() {
        return this.myCnt < this.myList.size();
    }

    @Override
    public int step() {
        ++this.myCnt;
        return this.myList.get(this.myCnt - 1);
    }
}

