/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.PopupHandler;
import com.intellij.util.containers.HashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.SetKeywordsDialog;
import org.jetbrains.idea.svn.dialogs.SetPropertyDialog;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class PropertiesComponent
extends JPanel {
    public static final String ID = "SVN Properties";
    private JTable myTable;
    private JTextArea myTextArea;
    private boolean myIsFollowSelection = true;
    private File myFile;
    private SvnVcs myVcs;
    private JSplitPane mySplitPane;
    private static final String CONTEXT_ID = "context";
    private final CloseAction myCloseAction = new CloseAction();
    private final RefreshAction myRefreshAction = new RefreshAction();
    private ActionGroup myPopupActionGroup;

    public PropertiesComponent() {
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.myTable = new JTable();
        this.myTextArea = new JTextArea(0, 0);
        this.myTextArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.myTable);
        this.mySplitPane = new JSplitPane(0, true, scrollPane, new JScrollPane(this.myTextArea));
        this.add((Component)this.mySplitPane, "Center");
        this.add((Component)this.createToolbar(), "West");
        DefaultTableModel model = new DefaultTableModel(PropertiesComponent.createTableModel((Map<String, String>)new HashMap()), new Object[]{"Name", "Value"}){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.myTable.setModel(model);
        this.myTable.setShowVerticalLines(true);
        this.myTable.setSelectionMode(0);
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = PropertiesComponent.this.myTable.getSelectedRow();
                if (index >= 0) {
                    Object value = PropertiesComponent.this.myTable.getValueAt(index, 1);
                    if (value instanceof String) {
                        PropertiesComponent.this.myTextArea.setText((String)value);
                    } else {
                        PropertiesComponent.this.myTextArea.setText("");
                    }
                } else {
                    PropertiesComponent.this.myTextArea.setText("");
                }
            }
        });
        this.myPopupActionGroup = this.createPopup();
        PopupHandler.installPopupHandler((JComponent)this.myTable, (ActionGroup)this.myPopupActionGroup, (String)"unknown", (ActionManager)ActionManager.getInstance());
        PopupHandler.installPopupHandler((JComponent)scrollPane, (ActionGroup)this.myPopupActionGroup, (String)"unknown", (ActionManager)ActionManager.getInstance());
        Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts("CloseActiveTab");
        this.myCloseAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), this);
        this.myRefreshAction.registerCustomShortcutSet(CommonShortcuts.getRerun(), this);
    }

    public void setFile(SvnVcs vcs, File file) {
        boolean firstTime;
        final TreeMap<String, String> props = new TreeMap<String, String>();
        boolean bl = firstTime = this.myFile == null;
        if (file != null) {
            this.myFile = file;
            this.myVcs = vcs;
            try {
                vcs.createWCClient().doGetProperty(file, null, SVNRevision.UNDEFINED, SVNRevision.WORKING, false, new ISVNPropertyHandler(){

                    public void handleProperty(File path, SVNPropertyData property) throws SVNException {
                        SVNPropertyValue value = property.getValue();
                        if (value != null) {
                            props.put(property.getName(), value.getString());
                        }
                    }

                    public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
                    }

                    public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
                    }
                });
            }
            catch (SVNException e) {
                props.clear();
            }
        }
        DefaultTableModel model = (DefaultTableModel)this.myTable.getModel();
        model.setDataVector(PropertiesComponent.createTableModel(props), new Object[]{"Name", "Value"});
        this.myTable.getColumnModel().setColumnSelectionAllowed(false);
        this.myTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object value) {
                if (value != null) {
                    if (value.toString().indexOf(13) >= 0) {
                        value = value.toString().substring(0, value.toString().indexOf(13)) + " [...]";
                    }
                    if (value.toString().indexOf(10) >= 0) {
                        value = value.toString().substring(0, value.toString().indexOf(10)) + " [...]";
                    }
                }
                super.setValue(value);
            }
        });
        if (firstTime) {
            this.mySplitPane.setDividerLocation(0.5);
        }
        if (this.myTable.getRowCount() > 0) {
            this.myTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private static Object[][] createTableModel(Map<String, String> model) {
        Object[][] result = new Object[model.size()][2];
        int index = 0;
        for (String name : model.keySet()) {
            String value = model.get(name);
            if (value == null) {
                value = "";
            }
            result[index][0] = name;
            result[index][1] = value;
            ++index;
        }
        return result;
    }

    private JComponent createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new AddPropertyAction());
        group.add((AnAction)new EditPropertyAction());
        group.add((AnAction)new DeletePropertyAction());
        group.addSeparator();
        group.add((AnAction)new SetKeywordsAction());
        group.addSeparator();
        group.add((AnAction)new FollowSelectionAction());
        group.add((AnAction)this.myRefreshAction);
        group.add((AnAction)this.myCloseAction);
        return ActionManager.getInstance().createActionToolbar("", (ActionGroup)group, false).getComponent();
    }

    private DefaultActionGroup createPopup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new AddPropertyAction());
        group.add((AnAction)new EditPropertyAction());
        group.add((AnAction)new DeletePropertyAction());
        group.addSeparator();
        group.add((AnAction)new SetKeywordsAction());
        group.addSeparator();
        group.add((AnAction)this.myRefreshAction);
        return group;
    }

    private String getSelectedPropertyName() {
        int row = this.myTable.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return (String)this.myTable.getValueAt(row, 0);
    }

    private void updateFileStatus(boolean recursive) {
        if (this.myFile != null && this.myVcs != null) {
            String url = "file://" + this.myFile.getPath().replace(File.separatorChar, '/');
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
            if (file != null) {
                if (recursive && file.isDirectory()) {
                    VcsDirtyScopeManager.getInstance((Project)this.myVcs.getProject()).dirDirtyRecursively(file, true);
                } else {
                    VcsDirtyScopeManager.getInstance((Project)this.myVcs.getProject()).fileDirty(file);
                }
            }
        }
    }

    private class FollowSelectionAction
    extends ToggleAction {
        private FollowSelectionAction() {
        }

        public boolean isSelected(AnActionEvent e) {
            return PropertiesComponent.this.myIsFollowSelection;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state && !PropertiesComponent.this.myIsFollowSelection) {
                this.updateSelection(e);
            }
            PropertiesComponent.this.myIsFollowSelection = state;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setIcon(IconLoader.getIcon((String)"/general/autoscrollFromSource.png"));
            e.getPresentation().setText("Follow Selection");
            e.getPresentation().setDescription("Follow Selection");
            if (PropertiesComponent.this.myIsFollowSelection) {
                this.updateSelection(e);
            }
        }

        private void updateSelection(AnActionEvent e) {
            File f;
            if (PropertiesComponent.this.myVcs == null) {
                return;
            }
            VirtualFile vf = (VirtualFile)PlatformDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
            if (vf != null && !(f = new File(vf.getPath())).equals(PropertiesComponent.this.myFile)) {
                PropertiesComponent.this.setFile(PropertiesComponent.this.myVcs, f);
                Project p = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
                ToolWindowManager.getInstance((Project)p).getToolWindow(PropertiesComponent.ID).setTitle(f.getName());
            }
        }
    }

    private class EditPropertyAction
    extends AnAction {
        private EditPropertyAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText("Edit Property");
            e.getPresentation().setDescription("Edit selected property value");
            if (!PropertiesComponent.CONTEXT_ID.equals(e.getPlace())) {
                e.getPresentation().setIcon(IconLoader.getIcon((String)"/actions/editSource.png"));
            }
            e.getPresentation().setEnabled(PropertiesComponent.this.myFile != null && PropertiesComponent.this.getSelectedPropertyName() != null);
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
            SetPropertyDialog dialog = new SetPropertyDialog(project, new File[]{PropertiesComponent.this.myFile}, PropertiesComponent.this.getSelectedPropertyName(), PropertiesComponent.this.myFile.isDirectory());
            dialog.show();
            boolean recursive = false;
            if (dialog.isOK()) {
                String name = dialog.getPropertyName();
                String value = dialog.getPropertyValue();
                recursive = dialog.isRecursive();
                SVNWCClient wcClient = PropertiesComponent.this.myVcs.createWCClient();
                try {
                    wcClient.doSetProperty(PropertiesComponent.this.myFile, name, SVNPropertyValue.create((String)value), false, recursive, null);
                }
                catch (SVNException err) {
                    // empty catch block
                }
            }
            PropertiesComponent.this.setFile(PropertiesComponent.this.myVcs, PropertiesComponent.this.myFile);
            PropertiesComponent.this.updateFileStatus(recursive);
        }
    }

    private class AddPropertyAction
    extends AnAction {
        private AddPropertyAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText("Add Property");
            e.getPresentation().setDescription("Add new property");
            if (!PropertiesComponent.CONTEXT_ID.equals(e.getPlace())) {
                e.getPresentation().setIcon(IconLoader.getIcon((String)"/general/add.png"));
            }
            e.getPresentation().setEnabled(PropertiesComponent.this.myFile != null);
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
            SetPropertyDialog dialog = new SetPropertyDialog(project, new File[]{PropertiesComponent.this.myFile}, null, PropertiesComponent.this.myFile.isDirectory());
            dialog.show();
            boolean recursive = false;
            if (dialog.isOK()) {
                String name = dialog.getPropertyName();
                String value = dialog.getPropertyValue();
                recursive = dialog.isRecursive();
                SVNWCClient wcClient = PropertiesComponent.this.myVcs.createWCClient();
                try {
                    wcClient.doSetProperty(PropertiesComponent.this.myFile, name, SVNPropertyValue.create((String)value), false, recursive, null);
                }
                catch (SVNException err) {
                    // empty catch block
                }
            }
            PropertiesComponent.this.setFile(PropertiesComponent.this.myVcs, PropertiesComponent.this.myFile);
            PropertiesComponent.this.updateFileStatus(recursive);
        }
    }

    private class DeletePropertyAction
    extends AnAction {
        private DeletePropertyAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText("Delete Property");
            e.getPresentation().setDescription("Delete selected property");
            if (!PropertiesComponent.CONTEXT_ID.equals(e.getPlace())) {
                e.getPresentation().setIcon(IconLoader.getIcon((String)"/general/remove.png"));
            }
            e.getPresentation().setEnabled(PropertiesComponent.this.myFile != null && PropertiesComponent.this.getSelectedPropertyName() != null);
        }

        public void actionPerformed(AnActionEvent e) {
            try {
                PropertiesComponent.this.myVcs.createWCClient().doSetProperty(PropertiesComponent.this.myFile, PropertiesComponent.this.getSelectedPropertyName(), null, true, false, null);
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
            PropertiesComponent.this.setFile(PropertiesComponent.this.myVcs, PropertiesComponent.this.myFile);
            PropertiesComponent.this.updateFileStatus(false);
        }
    }

    private class SetKeywordsAction
    extends AnAction {
        private SetKeywordsAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText("Edit Keywords");
            e.getPresentation().setDescription("Manage svn:keywords property");
            if (!PropertiesComponent.CONTEXT_ID.equals(e.getPlace())) {
                e.getPresentation().setIcon(IconLoader.getIcon((String)"/actions/properties.png"));
            }
            e.getPresentation().setEnabled(PropertiesComponent.this.myFile != null && PropertiesComponent.this.myFile.isFile());
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
            SVNWCClient wcClient = PropertiesComponent.this.myVcs.createWCClient();
            SVNPropertyData propValue = null;
            try {
                propValue = wcClient.doGetProperty(PropertiesComponent.this.myFile, "svn:keywords", SVNRevision.UNDEFINED, SVNRevision.WORKING);
            }
            catch (SVNException e1) {
                // empty catch block
            }
            SetKeywordsDialog dialog = new SetKeywordsDialog(project, propValue != null ? SVNPropertyValue.getPropertyAsString((SVNPropertyValue)propValue.getValue()) : null);
            dialog.show();
            if (dialog.isOK()) {
                String value = dialog.getKeywords();
                try {
                    wcClient.doSetProperty(PropertiesComponent.this.myFile, "svn:keywords", SVNPropertyValue.create((String)value), false, false, null);
                }
                catch (SVNException err) {
                    // empty catch block
                }
            }
            PropertiesComponent.this.setFile(PropertiesComponent.this.myVcs, PropertiesComponent.this.myFile);
            PropertiesComponent.this.updateFileStatus(false);
        }
    }

    private class RefreshAction
    extends AnAction {
        private RefreshAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText("Refresh");
            e.getPresentation().setDescription("Reload properties");
            e.getPresentation().setIcon(IconLoader.getIcon((String)"/actions/sync.png"));
            e.getPresentation().setEnabled(PropertiesComponent.this.myFile != null);
        }

        public void actionPerformed(AnActionEvent e) {
            PropertiesComponent.this.setFile(PropertiesComponent.this.myVcs, PropertiesComponent.this.myFile);
            PropertiesComponent.this.updateFileStatus(false);
        }
    }

    private static class CloseAction
    extends AnAction {
        private CloseAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText("Close");
            e.getPresentation().setDescription("Close this tool window");
            e.getPresentation().setIcon(IconLoader.getIcon((String)"/actions/cancel.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            Project p = (Project)e.getData(PlatformDataKeys.PROJECT);
            ToolWindowManager.getInstance((Project)p).unregisterToolWindow(PropertiesComponent.ID);
        }
    }
}

