/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.LatestExistentSearcher;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SvnDiffProvider
implements DiffProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnDiffProvider");
    private final SvnVcs myVcs;

    public SvnDiffProvider(SvnVcs vcs) {
        this.myVcs = vcs;
    }

    public VcsRevisionNumber getCurrentRevision(VirtualFile file) {
        SVNStatusClient client = this.myVcs.createStatusClient();
        try {
            SVNStatus svnStatus = client.doStatus(new File(file.getPresentableUrl()), false, false);
            if (svnStatus.getCommittedRevision().equals((Object)SVNRevision.UNDEFINED) && svnStatus.isCopied()) {
                return new SvnRevisionNumber(svnStatus.getCopyFromRevision());
            }
            return new SvnRevisionNumber(svnStatus.getCommittedRevision());
        }
        catch (SVNException e) {
            LOG.debug((Throwable)e);
            return null;
        }
    }

    private static ItemLatestState defaultResult() {
        return SvnDiffProvider.createResult(SVNRevision.HEAD, true, true);
    }

    private static ItemLatestState createResult(SVNRevision revision, boolean exists, boolean defaultHead) {
        return new ItemLatestState((VcsRevisionNumber)new SvnRevisionNumber(revision), exists, defaultHead);
    }

    public ItemLatestState getLastRevision(VirtualFile file) {
        return this.getLastRevision(new File(file.getPath()));
    }

    public ContentRevision createFileContent(VcsRevisionNumber revisionNumber, VirtualFile selectedFile) {
        SVNRevision svnRevision = ((SvnRevisionNumber)revisionNumber).getRevision();
        FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(selectedFile);
        SVNStatusClient client = this.myVcs.createStatusClient();
        try {
            SVNStatus svnStatus = client.doStatus(new File(selectedFile.getPresentableUrl()), false, false);
            if (svnRevision.equals((Object)svnStatus.getCommittedRevision())) {
                return SvnContentRevision.create(this.myVcs, filePath, svnRevision);
            }
        }
        catch (SVNException e) {
            LOG.debug((Throwable)e);
        }
        return SvnContentRevision.createRemote(this.myVcs, filePath, svnRevision);
    }

    public ItemLatestState getLastRevision(FilePath filePath) {
        return this.getLastRevision(filePath.getIOFile());
    }

    public VcsRevisionNumber getLatestCommittedRevision(VirtualFile vcsRoot) {
        return null;
    }

    private ItemLatestState getLastRevision(File file) {
        SVNStatusClient client = this.myVcs.createStatusClient();
        try {
            boolean exists;
            SVNStatus svnStatus = client.doStatus(file, true, false);
            if (svnStatus == null) {
                LOG.info("No SVN status returned for " + file.getPath());
                return SvnDiffProvider.defaultResult();
            }
            boolean bl = exists = !SVNStatusType.STATUS_DELETED.equals(svnStatus.getRemoteContentsStatus());
            if (!exists) {
                LatestExistentSearcher searcher = new LatestExistentSearcher(this.myVcs, svnStatus.getURL());
                long revision = searcher.getDeletionRevision();
                return SvnDiffProvider.createResult(SVNRevision.create((long)revision), exists, false);
            }
            SVNRevision remoteRevision = svnStatus.getRemoteRevision();
            if (remoteRevision != null) {
                return SvnDiffProvider.createResult(remoteRevision, exists, false);
            }
            return SvnDiffProvider.createResult(svnStatus.getCommittedRevision(), exists, false);
        }
        catch (SVNException e) {
            LOG.debug((Throwable)e);
            return SvnDiffProvider.defaultResult();
        }
    }
}

