/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.committed.AbstractCalledLater;
import com.intellij.openapi.vcs.changes.ui.ChangesViewBalloonProblemNotifier;
import com.intellij.util.EventDispatcher;
import com.intellij.util.net.HttpConfigurable;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.auth.ProviderType;
import org.jetbrains.idea.svn.auth.SvnAuthenticationInteraction;
import org.jetbrains.idea.svn.auth.SvnAuthenticationListener;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.ISVNProxyManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.internal.util.jna.SVNJNAUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNCompositeConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SvnAuthenticationManager
extends DefaultSVNAuthenticationManager
implements SvnAuthenticationListener {
    private static final Logger LOG = Logger.getInstance((String)SvnAuthenticationManager.class.getName());
    private final Project myProject;
    private final File myConfigDirectory;
    private PersistentAuthenticationProviderProxy myPersistentAuthenticationProviderProxy;
    private SvnConfiguration myConfig;
    private final Map<Thread, Boolean> myPlainTextAllowed;
    private static final ThreadLocal<Boolean> ourJustEntered = new ThreadLocal();
    private SvnAuthenticationInteraction myInteraction;
    private final EventDispatcher<SvnAuthenticationListener> myListener;
    private static final int DEFAULT_READ_TIMEOUT = 30000;

    public SvnAuthenticationManager(Project project, File configDirectory) {
        super(configDirectory, true, null, null);
        this.myProject = project;
        this.myConfigDirectory = configDirectory;
        this.myListener = EventDispatcher.create(SvnAuthenticationListener.class);
        this.myConfig = SvnConfiguration.getInstance(this.myProject);
        if (this.myPersistentAuthenticationProviderProxy != null) {
            this.myPersistentAuthenticationProviderProxy.setProject(this.myProject);
        }
        this.myPlainTextAllowed = Collections.synchronizedMap(new HashMap());
        this.myInteraction = new MySvnAuthenticationInteraction(this.myProject);
    }

    public void addListener(SvnAuthenticationListener listener) {
        this.myListener.addListener((EventListener)listener);
    }

    @Override
    public void actualSaveWillBeTried(ProviderType type, SVNURL url, String realm, String kind, boolean withCredentials) {
        ((SvnAuthenticationListener)this.myListener.getMulticaster()).actualSaveWillBeTried(type, url, realm, kind, withCredentials);
    }

    @Override
    public void requested(ProviderType type, SVNURL url, String realm, String kind, boolean canceled) {
        if (ProviderType.interactive.equals((Object)type) && !canceled) {
            ourJustEntered.set(true);
        }
        ((SvnAuthenticationListener)this.myListener.getMulticaster()).requested(type, url, realm, kind, canceled);
    }

    protected ISVNAuthenticationProvider createCacheAuthenticationProvider(File authDir, String userName) {
        this.myPersistentAuthenticationProviderProxy = new PersistentAuthenticationProviderProxy(super.createCacheAuthenticationProvider(authDir, userName), authDir);
        return this.myPersistentAuthenticationProviderProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeAuthentication(boolean accepted, String kind, String realm, SVNErrorMessage errorMessage, SVNAuthentication authentication) throws SVNException {
        try {
            super.acknowledgeAuthentication(accepted, kind, realm, errorMessage, authentication);
        }
        finally {
            Thread currentThread = Thread.currentThread();
            this.myPlainTextAllowed.remove(currentThread);
        }
    }

    public ISVNProxyManager getProxyManager(SVNURL url) throws SVNException {
        String host = url.getHost();
        Map properties = this.getHostProperties(host);
        String proxyHost = (String)properties.get("http-proxy-host");
        if (proxyHost == null || "".equals(proxyHost.trim())) {
            if (this.myConfig.isIsUseDefaultProxy()) {
                HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
                String ideaWideProxyHost = httpConfigurable.PROXY_HOST;
                String ideaWideProxyPort = String.valueOf(httpConfigurable.PROXY_PORT);
                if (ideaWideProxyPort == null) {
                    ideaWideProxyPort = "3128";
                }
                if (ideaWideProxyHost != null && !"".equals(ideaWideProxyHost.trim())) {
                    return new MyPromptingProxyManager(ideaWideProxyHost, ideaWideProxyPort);
                }
            }
            return null;
        }
        String proxyExceptions = (String)properties.get("http-proxy-exceptions");
        String proxyExceptionsSeparator = ",";
        if (proxyExceptions == null) {
            proxyExceptions = System.getProperty("http.nonProxyHosts");
            proxyExceptionsSeparator = "|";
        }
        if (proxyExceptions != null) {
            StringTokenizer exceptions = new StringTokenizer(proxyExceptions, proxyExceptionsSeparator);
            while (exceptions.hasMoreTokens()) {
                String exception = exceptions.nextToken().trim();
                if (!DefaultSVNOptions.matches((String)exception, (String)host)) continue;
                return null;
            }
        }
        String proxyPort = (String)properties.get("http-proxy-port");
        String proxyUser = (String)properties.get("http-proxy-username");
        String proxyPassword = (String)properties.get("http-proxy-password");
        return new MySimpleProxyManager(proxyHost, proxyPort, proxyUser, proxyPassword);
    }

    public int getReadTimeout(SVNRepository repository) {
        String protocol = repository.getLocation().getProtocol();
        if ("http".equals(protocol) || "https".equals(protocol)) {
            String host = repository.getLocation().getHost();
            Map properties = this.getHostProperties(host);
            String timeout = (String)properties.get("http-timeout");
            if (timeout != null) {
                try {
                    return Integer.parseInt(timeout) * 1000;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            return 30000;
        }
        return 0;
    }

    private Map getHostProperties(String host) {
        SVNCompositeConfigFile serversFile = this.getServersFile();
        Map globalProps = serversFile.getProperties("global");
        String groupName = SvnAuthenticationManager.getGroupName(serversFile.getProperties("groups"), host);
        if (groupName != null) {
            Map hostProps = serversFile.getProperties(groupName);
            globalProps.putAll(hostProps);
        }
        return globalProps;
    }

    public static boolean checkHostGroup(String url, String patterns, String exceptions) {
        SVNURL svnurl;
        try {
            svnurl = SVNURL.parseURIEncoded((String)url);
        }
        catch (SVNException e) {
            return false;
        }
        String host = svnurl.getHost();
        return SvnAuthenticationManager.matches(patterns, host) && !SvnAuthenticationManager.matches(exceptions, host);
    }

    private static boolean matches(String pattern, String host) {
        StringTokenizer tokenizer = new StringTokenizer(pattern, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!DefaultSVNOptions.matches((String)token, (String)host)) continue;
            return true;
        }
        return false;
    }

    private static String getGroupName(Map groups, String host) {
        for (String name : groups.keySet()) {
            String pattern = (String)groups.get(name);
            StringTokenizer tokens = new StringTokenizer(pattern, ",");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (!DefaultSVNOptions.matches((String)token, (String)host)) continue;
                return name;
            }
        }
        return null;
    }

    private void setPropertyForHost(String host, String property, String value) {
        SVNConfigFile userConfig = new SVNConfigFile(new File(this.myConfigDirectory, "servers"));
        String groupName = SvnAuthenticationManager.getGroupName(userConfig.getProperties("groups"), host);
        if (groupName != null) {
            userConfig.setPropertyValue(groupName, property, value, true);
        } else {
            SVNConfigFile systemConfig = new SVNConfigFile(new File(SVNFileUtil.getSystemConfigurationDirectory(), "servers"));
            String systemGroupName = SvnAuthenticationManager.getGroupName(systemConfig.getProperties("groups"), host);
            if (systemGroupName != null) {
                systemConfig.setPropertyValue(systemGroupName, property, value, true);
            } else {
                userConfig.setPropertyValue("global", property, value, true);
            }
        }
    }

    private boolean isTurned(String value) {
        return value == null || "yes".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
    }

    public boolean authCredsOn(SVNURL url) {
        return !Boolean.FALSE.equals(this.isAuthStorageEnabledMy(url)) && this.isTurned(this.getConfigFile().getPropertyValue("auth", "store-auth-creds"));
    }

    @Nullable
    protected Boolean isAuthStorageEnabledMy(SVNURL url) {
        String host = url != null ? url.getHost() : null;
        Map properties = this.getHostProperties(host);
        String storeAuthCreds = (String)properties.get("store-auth-creds");
        if (storeAuthCreds == null) {
            return null;
        }
        return "yes".equalsIgnoreCase(storeAuthCreds) || "on".equalsIgnoreCase(storeAuthCreds) || "true".equalsIgnoreCase(storeAuthCreds);
    }

    public void saveCredentialsIfAllowed(final SVNAuthentication auth, String kind, final String realm, Runnable saveRunnable) {
        final SVNURL url = auth.getURL();
        String storeCredentials = this.getConfigFile().getPropertyValue("auth", "store-auth-creds");
        if (Boolean.FALSE.equals(this.isAuthStorageEnabledMy(url)) || !this.isTurned(storeCredentials)) {
            this.myInteraction.warnOnAuthStorageDisabled(url);
            return;
        }
        boolean passwordWillBeSaved = true;
        boolean passwordStorageEnabled = this.isStorePasswords(url);
        if (!"svn.ssl.client-passphrase".equals(kind) && !passwordStorageEnabled) {
            this.myInteraction.warnOnPasswordStorageDisabled(url);
            passwordWillBeSaved = false;
        }
        if ("svn.ssl.client-passphrase".equals(kind) && !this.isStoreSSLClientCertificatePassphrases(url)) {
            this.myInteraction.warnOnSSLPassphraseStorageDisabled(url);
            passwordWillBeSaved = false;
        }
        if (!(!passwordWillBeSaved || SystemInfo.isWindows && SVNJNAUtil.isWinCryptEnabled())) {
            try {
                if ("svn.ssl.client-passphrase".equals(kind)) {
                    if (!this.isStorePlainTextPassphrases(realm, auth)) {
                        this.promptAndSaveWhenWeLackEncryption(saveRunnable, new Getter<Boolean>(){

                            public Boolean get() {
                                return SvnAuthenticationManager.this.myInteraction.promptForSSLPlaintextPassphraseSaving(url, realm, ((SVNSSLAuthentication)auth).getCertificateFile());
                            }
                        });
                        return;
                    }
                } else if (!this.isStorePlainTextPasswords(realm, auth)) {
                    this.promptAndSaveWhenWeLackEncryption(saveRunnable, new Getter<Boolean>(){

                        public Boolean get() {
                            return SvnAuthenticationManager.this.myInteraction.promptForPlaintextPasswordSaving(url, realm);
                        }
                    });
                    return;
                }
            }
            catch (SVNException e) {
                LOG.info((Throwable)e);
                return;
            }
        }
        saveRunnable.run();
    }

    protected boolean isStorePlainTextPasswords(String realm, SVNAuthentication auth) throws SVNException {
        return Boolean.TRUE.equals(this.myPlainTextAllowed.get(Thread.currentThread())) || super.isStorePlainTextPasswords(realm, auth);
    }

    protected boolean isStorePlainTextPassphrases(String realm, SVNAuthentication auth) throws SVNException {
        return Boolean.TRUE.equals(this.myPlainTextAllowed.get(Thread.currentThread())) || super.isStorePlainTextPassphrases(realm, auth);
    }

    private ModalityState getCurrent() {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return ModalityState.current();
        }
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        if (pi == null) {
            return ModalityState.defaultModalityState();
        }
        return pi.getModalityState();
    }

    private void promptAndSaveWhenWeLackEncryption(final Runnable saveRunnable, final Getter<Boolean> prompt) {
        final Boolean[] saveOnce = new Boolean[1];
        final Runnable actualSave = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread currentThread = Thread.currentThread();
                SvnAuthenticationManager.this.myPlainTextAllowed.put(currentThread, Boolean.TRUE.equals(saveOnce[0]));
                try {
                    saveRunnable.run();
                }
                finally {
                    SvnAuthenticationManager.this.myPlainTextAllowed.remove(currentThread);
                }
            }
        };
        if (this.myInteraction.promptInAwt()) {
            new AbstractCalledLater(this.myProject, this.getCurrent()){

                public void run() {
                    saveOnce[0] = Boolean.TRUE.equals(prompt.get());
                    ApplicationManager.getApplication().executeOnPooledThread(actualSave);
                }
            }.callMe();
        } else {
            saveOnce[0] = Boolean.TRUE.equals(prompt.get());
            actualSave.run();
        }
    }

    private boolean askToStoreUnencrypted(String title, String message) {
        int answer = Messages.showYesNoDialog((Project)this.myProject, (String)message, (String)title, (Icon)Messages.getQuestionIcon());
        return answer == 0;
    }

    public void setInteraction(SvnAuthenticationInteraction interaction) {
        this.myInteraction = interaction;
    }

    private static class MySvnAuthenticationInteraction
    implements SvnAuthenticationInteraction {
        private final Project myProject;

        private MySvnAuthenticationInteraction(Project project) {
            this.myProject = project;
        }

        @Override
        public void warnOnAuthStorageDisabled(SVNURL url) {
            ChangesViewBalloonProblemNotifier.showMe((Project)this.myProject, (String)"Cannot store credentials: forbidden by \"store-auth-creds=no\"", (MessageType)MessageType.ERROR);
        }

        @Override
        public void warnOnPasswordStorageDisabled(SVNURL url) {
            ChangesViewBalloonProblemNotifier.showMe((Project)this.myProject, (String)"Cannot store password: forbidden by \"store-passwords=no\"", (MessageType)MessageType.ERROR);
        }

        @Override
        public void warnOnSSLPassphraseStorageDisabled(SVNURL url) {
            ChangesViewBalloonProblemNotifier.showMe((Project)this.myProject, (String)"Cannot store passphrase: forbidden by \"store-ssl-client-cert-pp=no\"", (MessageType)MessageType.ERROR);
        }

        @Override
        public boolean promptForPlaintextPasswordSaving(SVNURL url, String realm) {
            int answer = Messages.showYesNoDialog((Project)this.myProject, (String)String.format("Your password for authentication realm:\n%s\ncan only be stored to disk unencrypted. Would you like to store it in plaintext?", realm), (String)"Store the password in plaintext?", (Icon)Messages.getQuestionIcon());
            return answer == 0;
        }

        @Override
        public boolean promptInAwt() {
            return true;
        }

        @Override
        public boolean promptForSSLPlaintextPassphraseSaving(SVNURL url, String realm, File certificateFile) {
            int answer = Messages.showYesNoDialog((Project)this.myProject, (String)String.format("Your passphrase for client certificate:\n%s\ncan only be stored to disk unencrypted. Would you like to store it in plaintext?", certificateFile.getPath()), (String)"Store the passphrase in plaintext?", (Icon)Messages.getQuestionIcon());
            return answer == 0;
        }
    }

    private static class MySimpleProxyManager
    implements ISVNProxyManager {
        protected String myProxyHost;
        private final String myProxyPort;
        protected String myProxyUser;
        protected String myProxyPassword;

        public MySimpleProxyManager(String host, String port, String user, String password) {
            this.myProxyHost = host;
            this.myProxyPort = port == null ? "3128" : port;
            this.myProxyUser = user;
            this.myProxyPassword = password;
        }

        public String getProxyHost() {
            return this.myProxyHost;
        }

        public int getProxyPort() {
            try {
                return Integer.parseInt(this.myProxyPort);
            }
            catch (NumberFormatException numberFormatException) {
                return 3128;
            }
        }

        public String getProxyUserName() {
            return this.myProxyUser;
        }

        public String getProxyPassword() {
            return this.myProxyPassword;
        }

        public void acknowledgeProxyContext(boolean accepted, SVNErrorMessage errorMessage) {
        }
    }

    private static class MyPromptingProxyManager
    extends MySimpleProxyManager {
        private static final String ourPrompt = "Proxy authentication";

        private MyPromptingProxyManager(String host, String port) {
            super(host, port, null, null);
        }

        @Override
        public String getProxyUserName() {
            if (this.myProxyUser != null) {
                return this.myProxyUser;
            }
            HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
            if (httpConfigurable.PROXY_AUTHENTICATION && !httpConfigurable.KEEP_PROXY_PASSWORD) {
                httpConfigurable.getPromptedAuthentication(this.myProxyHost, ourPrompt);
            }
            this.myProxyUser = httpConfigurable.PROXY_LOGIN;
            return this.myProxyUser;
        }

        @Override
        public String getProxyPassword() {
            if (this.myProxyPassword != null) {
                return this.myProxyPassword;
            }
            HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
            if (httpConfigurable.PROXY_AUTHENTICATION && !httpConfigurable.KEEP_PROXY_PASSWORD) {
                httpConfigurable.getPromptedAuthentication(this.myProxyUser, ourPrompt);
            }
            this.myProxyPassword = httpConfigurable.getPlainProxyPassword();
            return this.myProxyPassword;
        }
    }

    private class PersistentAuthenticationProviderProxy
    implements ISVNAuthenticationProvider,
    DefaultSVNAuthenticationManager.IPersistentAuthenticationProvider {
        private final ISVNAuthenticationProvider myDelegate;
        private final File myAuthDir;
        private Project myProject;
        private static final int maxAttempts = 10;

        private PersistentAuthenticationProviderProxy(ISVNAuthenticationProvider delegate, File authDir) {
            this.myDelegate = delegate;
            this.myAuthDir = authDir;
        }

        public void setProject(Project project) {
            this.myProject = project;
        }

        public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
            SVNAuthentication svnAuthentication = this.myDelegate.requestClientAuthentication(kind, url, realm, errorMessage, previousAuth, authMayBeStored);
            ((SvnAuthenticationListener)SvnAuthenticationManager.this.myListener.getMulticaster()).requested(ProviderType.persistent, url, realm, kind, svnAuthentication == null);
            return svnAuthentication;
        }

        public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
            return 1;
        }

        public void saveAuthentication(final SVNAuthentication auth, String kind, final String realm) throws SVNException {
            Boolean fromInteractive = (Boolean)ourJustEntered.get();
            ourJustEntered.set(null);
            if (!Boolean.TRUE.equals(fromInteractive)) {
                return;
            }
            final String actualKind = auth.getKind();
            Runnable actualSave = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    File dir = new File(PersistentAuthenticationProviderProxy.this.myAuthDir, actualKind);
                    String fileName = SVNFileUtil.computeChecksum((String)realm);
                    File authFile = new File(dir, fileName);
                    ((SvnAuthenticationListener)SvnAuthenticationManager.this.myListener.getMulticaster()).actualSaveWillBeTried(ProviderType.persistent, auth.getURL(), realm, actualKind, !Boolean.FALSE.equals(SvnAuthenticationManager.this.myPlainTextAllowed.get(Thread.currentThread())));
                    try {
                        ((DefaultSVNAuthenticationManager.IPersistentAuthenticationProvider)PersistentAuthenticationProviderProxy.this.myDelegate).saveAuthentication(auth, actualKind, realm);
                    }
                    catch (SVNException e) {
                        if (PersistentAuthenticationProviderProxy.this.myProject != null) {
                            ApplicationManager.getApplication().invokeLater((Runnable)new ChangesViewBalloonProblemNotifier(PersistentAuthenticationProviderProxy.this.myProject, "<b>Problem when storing Subversion credentials:</b>&nbsp;" + e.getMessage(), MessageType.ERROR));
                        }
                    }
                    finally {
                        PersistentAuthenticationProviderProxy.this.setWriteable(authFile);
                    }
                }
            };
            if ("svn.username".equals(actualKind)) {
                actualSave.run();
                return;
            }
            if (!auth.isStorageAllowed()) {
                return;
            }
            SvnAuthenticationManager.this.saveCredentialsIfAllowed(auth, actualKind, realm, actualSave);
        }

        private void setWriteable(File file) {
            if (!file.exists()) {
                return;
            }
            if (file.getParentFile() == null) {
                return;
            }
            for (int i = 0; i < 10; ++i) {
                File parent = file.getParentFile();
                try {
                    File tempFile = File.createTempFile("123", "1", parent);
                    FileUtil.delete((File)tempFile);
                    if (!file.renameTo(tempFile) || !file.createNewFile()) continue;
                    FileUtil.copy((File)tempFile, (File)file);
                    FileUtil.delete((File)tempFile);
                    return;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }
}

