/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopy;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class RootsToWorkingCopies
implements VcsListener {
    private final Object myLock;
    private final Map<VirtualFile, WorkingCopy> myRootMapping;
    private final Set<VirtualFile> myUnversioned;
    private final BackgroundTaskQueue myQueue;
    private final Project myProject;

    public RootsToWorkingCopies(Project project) {
        this.myProject = project;
        this.myQueue = new BackgroundTaskQueue(project, "SVN VCS roots authorization checker");
        this.myLock = new Object();
        this.myRootMapping = new HashMap<VirtualFile, WorkingCopy>();
        this.myUnversioned = new HashSet<VirtualFile>();
    }

    public void addRoot(final VirtualFile root) {
        this.myQueue.run(new Task.Backgroundable(this.myProject, "Looking for '" + root.getPath() + "' working copy root", false, BackgroundFromStartOption.getInstance()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/RootsToWorkingCopies$1.run must not be null");
                }
                RootsToWorkingCopies.this.calculateRoot(root);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public WorkingCopy getMatchingCopy(SVNURL url) {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        VirtualFile[] roots = ProjectLevelVcsManager.getInstance((Project)this.myProject).getRootsUnderVcs((AbstractVcs)SvnVcs.getInstance(this.myProject));
        Object object = this.myLock;
        synchronized (object) {
            for (VirtualFile root : roots) {
                WorkingCopy wcRoot = this.getWcRoot(root);
                if (wcRoot == null) continue;
                SVNURL common = SVNURLUtil.getCommonURLAncestor((SVNURL)wcRoot.getUrl(), (SVNURL)url);
                if (!wcRoot.getUrl().equals((Object)common) && !url.equals((Object)common)) continue;
                return wcRoot;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public WorkingCopy getWcRoot(VirtualFile root) {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        Object object = this.myLock;
        synchronized (object) {
            if (this.myUnversioned.contains(root)) {
                return null;
            }
            WorkingCopy existing = this.myRootMapping.get(root);
            if (existing != null) {
                return existing;
            }
        }
        return this.calculateRoot(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private WorkingCopy calculateRoot(VirtualFile root) {
        WorkingCopy workingCopy;
        block11: {
            workingCopy = null;
            try {
                File workingCopyRoot = SVNWCUtil.getWorkingCopyRoot((File)new File(root.getPath()), (boolean)true);
                if (workingCopyRoot == null) break block11;
                SVNWCAccess wcAccess = SVNWCAccess.newInstance(null);
                try {
                    wcAccess.probeOpen(workingCopyRoot, false, 0);
                    SVNEntry entry = wcAccess.getVersionedEntry(workingCopyRoot, false);
                    SVNURL url = entry.getSVNURL();
                    if (url != null) {
                        workingCopy = new WorkingCopy(workingCopyRoot, url);
                    }
                }
                finally {
                    wcAccess.close();
                }
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
        }
        Object object = this.myLock;
        synchronized (object) {
            if (workingCopy == null) {
                this.myRootMapping.remove(root);
                this.myUnversioned.add(root);
            } else {
                this.myUnversioned.remove(root);
                this.myRootMapping.put(root, workingCopy);
            }
        }
        return workingCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.myLock;
        synchronized (object) {
            this.myRootMapping.clear();
            this.myUnversioned.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void directoryMappingChanged() {
        SvnVcs svnVcs = SvnVcs.getInstance(this.myProject);
        svnVcs.getAuthNotifier().clear();
        VirtualFile[] roots = ProjectLevelVcsManager.getInstance((Project)this.myProject).getRootsUnderVcs((AbstractVcs)svnVcs);
        Object object = this.myLock;
        synchronized (object) {
            this.clear();
            for (VirtualFile root : roots) {
                this.addRoot(root);
            }
        }
    }
}

