/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.refactoring;

import com.intellij.codeInsight.completion.simple.SimpleLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagRenameDialog
extends RefactoringDialog {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.refactoring.XmlTagRenameDialog");
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"rename.title");
    private final PsiElement myElement;
    private final Editor myEditor;
    private JLabel myTitleLabel;
    private NameSuggestionsField myNameSuggestionsField;
    private String myHelpID;
    private final XmlTag myTag;
    private NameSuggestionsField.DataChanged myNameChangedListener;

    public XmlTagRenameDialog(@NotNull Editor editor, @NotNull PsiElement element, @NotNull XmlTag tag) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/refactoring/XmlTagRenameDialog.<init> must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/refactoring/XmlTagRenameDialog.<init> must not be null");
        }
        if (tag == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xml/refactoring/XmlTagRenameDialog.<init> must not be null");
        }
        super(element.getProject(), true);
        this.myEditor = editor;
        this.myElement = element;
        this.myTag = tag;
        this.setTitle(REFACTORING_NAME);
        this.createNewNameComponent();
        this.init();
        this.myTitleLabel.setText(XmlBundle.message((String)"rename.current.tag", (Object[])new Object[]{XmlTagRenameDialog.getFullName(tag)}));
        this.validateButtons();
    }

    protected void dispose() {
        this.myNameSuggestionsField.removeDataChangedListener(this.myNameChangedListener);
        super.dispose();
    }

    @Override
    protected boolean hasHelpAction() {
        return false;
    }

    private static String getFullName(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/refactoring/XmlTagRenameDialog.getFullName must not be null");
        }
        String name = UsageViewUtil.getDescriptiveName((PsiElement)tag);
        return (UsageViewUtil.getType((PsiElement)tag) + " " + name).trim();
    }

    public static void renameXmlTag(Editor editor, @NotNull PsiElement element, @NotNull XmlTag tag) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/refactoring/XmlTagRenameDialog.renameXmlTag must not be null");
        }
        if (tag == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xml/refactoring/XmlTagRenameDialog.renameXmlTag must not be null");
        }
        XmlTagRenameDialog dialog = new XmlTagRenameDialog(editor, element, tag);
        dialog.show();
    }

    private void createNewNameComponent() {
        this.myNameSuggestionsField = new NameSuggestionsField(new String[]{this.myTag.getName()}, this.myProject, (FileType)FileTypes.PLAIN_TEXT, this.myEditor);
        this.myNameChangedListener = new NameSuggestionsField.DataChanged(){

            @Override
            public void dataChanged() {
                XmlTagRenameDialog.this.validateButtons();
            }
        };
        this.myNameSuggestionsField.addDataChangedListener(this.myNameChangedListener);
        this.myNameSuggestionsField.getComponent().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XmlTagRenameDialog.this.completeVariable(XmlTagRenameDialog.this.myNameSuggestionsField.getEditor());
            }
        }, KeyStroke.getKeyStroke(32, 2), 2);
    }

    private void completeVariable(Editor editor) {
        String prefix = this.myNameSuggestionsField.getEnteredName();
        LinkedHashSet<SimpleLookupItem<Object>> set = new LinkedHashSet<SimpleLookupItem<Object>>();
        PsiReference reference = this.myTag.getReference();
        if (reference != null) {
            Object[] variants;
            for (Object variant : variants = reference.getVariants()) {
                set.add(new SimpleLookupItem<Object>(variant));
            }
            LookupElement[] lookupItems = set.toArray(new LookupElement[set.size()]);
            editor.getCaretModel().moveToOffset(prefix.length());
            editor.getSelectionModel().removeSelection();
            LookupManager.getInstance(this.getProject()).showLookup(editor, lookupItems, prefix);
        }
    }

    @Override
    protected void doAction() {
        LOG.assertTrue(this.myElement.isValid());
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            XmlTagRenameDialog.this.myTag.setName(XmlTagRenameDialog.this.getNewName());
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
            }
        }, RefactoringBundle.message((String)"rename.title"), null);
        this.close(0);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameSuggestionsField.getFocusableComponent();
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createCompoundBorder(IdeBorderFactory.createBorder(), BorderFactory.createEmptyBorder(4, 8, 4, 8)));
        this.myTitleLabel = new JLabel();
        panel.add(this.myTitleLabel);
        panel.add(Box.createVerticalStrut(8));
        panel.add(this.myNameSuggestionsField.getComponent());
        return panel;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.myHelpID);
    }

    public String getNewName() {
        return this.myNameSuggestionsField.getEnteredName().trim();
    }

    @Override
    protected void validateButtons() {
        super.validateButtons();
        this.getPreviewAction().setEnabled(false);
    }

    @Override
    protected boolean areButtonsValid() {
        String newName = this.getNewName();
        return !StringUtil.containsAnyChar((String)newName, (String)"\t ;*'\"\\/,()^&<>={}");
    }
}

