/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.xml.breadcrumbs.BreadcrumbsXmlWrapper;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BreadcrumbsLoaderComponent
extends AbstractProjectComponent {
    private static final Key<Object> BREADCRUMBS_SUITABLE_FILE = new Key("breadcrumbs.suitable.file");

    public BreadcrumbsLoaderComponent(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent.<init> must not be null");
        }
        super(project);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("HtmlBreadcrumbsComponent" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/breadcrumbs/BreadcrumbsLoaderComponent.getComponentName must not return null");
        }
        return "HtmlBreadcrumbsComponent";
    }

    public void initComponent() {
        MyFileEditorManagerListener listener = new MyFileEditorManagerListener();
        FileEditorManager.getInstance((Project)this.myProject).addFileEditorManagerListener((FileEditorManagerListener)listener, (Disposable)this.myProject);
    }

    private static boolean isEnabled() {
        return WebEditorOptions.getInstance().isBreadcrumbsEnabled();
    }

    private static class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(final FileEditorManager source, VirtualFile file) {
            if (BreadcrumbsLoaderComponent.isEnabled() && MyFileEditorManagerListener.isSuitable(source.getProject(), file)) {
                FileEditor[] fileEditors;
                for (final FileEditor each : fileEditors = source.getEditors(file)) {
                    if (!(each instanceof TextEditor)) continue;
                    BreadcrumbsXmlWrapper wrapper = new BreadcrumbsXmlWrapper(((TextEditor)each).getEditor());
                    final JComponent c = wrapper.getComponent();
                    source.addTopComponent(each, c);
                    Disposer.register((Disposable)each, (Disposable)wrapper);
                    Disposer.register((Disposable)each, (Disposable)new Disposable(){

                        public void dispose() {
                            source.removeTopComponent(each, c);
                        }
                    });
                }
            }
        }

        private static boolean isSuitable(Project project, VirtualFile file) {
            if (file instanceof HttpVirtualFile) {
                return false;
            }
            FileViewProvider psiFile = PsiManager.getInstance((Project)project).findViewProvider(file);
            return psiFile != null && (BreadcrumbsXmlWrapper.findInfoProvider(psiFile) != null || file.getUserData(BREADCRUMBS_SUITABLE_FILE) != null);
        }

        public void fileClosed(FileEditorManager source, VirtualFile file) {
        }

        public void selectionChanged(FileEditorManagerEvent event) {
        }
    }
}

