/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ReflectionCache;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.Implementation;
import gnu.trove.THashMap;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

class ImplementationClassCache
extends ConcurrentFactoryMap<Class<? extends DomElement>, Class<? extends DomElement>> {
    private static final Comparator<Class<? extends DomElement>> CLASS_COMPARATOR = new Comparator<Class<? extends DomElement>>(){

        @Override
        public int compare(Class<? extends DomElement> o1, Class<? extends DomElement> o2) {
            if (o1.isAssignableFrom(o2)) {
                return 1;
            }
            if (o2.isAssignableFrom(o1)) {
                return -1;
            }
            if (o1.equals(o2)) {
                return 0;
            }
            throw new AssertionError((Object)("Incompatible implementation classes: " + o1 + " & " + o2));
        }
    };
    private final Map<Class<? extends DomElement>, Class<? extends DomElement>> myImplementationClasses = new THashMap();

    ImplementationClassCache() {
    }

    @Nullable
    protected Class<? extends DomElement> create(Class<? extends DomElement> concreteInterface) {
        TreeSet<Class<? extends DomElement>> set = new TreeSet<Class<? extends DomElement>>(CLASS_COMPARATOR);
        this.findImplementationClassDFS(concreteInterface, set);
        if (!set.isEmpty()) {
            return set.first();
        }
        Implementation implementation = (Implementation)DomReflectionUtil.findAnnotationDFS(concreteInterface, Implementation.class);
        return implementation == null ? null : implementation.value();
    }

    private void findImplementationClassDFS(Class concreteInterface, SortedSet<Class<? extends DomElement>> results) {
        Class<? extends DomElement> aClass = this.myImplementationClasses.get(concreteInterface);
        if (aClass != null) {
            results.add(aClass);
        } else {
            for (Class aClass1 : ReflectionCache.getInterfaces((Class)concreteInterface)) {
                this.findImplementationClassDFS(aClass1, results);
            }
        }
    }

    public final void registerImplementation(final Class<? extends DomElement> domElementClass, Class<? extends DomElement> implementationClass, Disposable parentDisposable) {
        this.myImplementationClasses.put(domElementClass, implementationClass);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    ImplementationClassCache.this.myImplementationClasses.remove(domElementClass);
                }
            });
        }
        super.clear();
    }
}

