/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.LightColors;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorSharedConfigurationManager;
import com.intellij.ui.tabs.FileColorsModel;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FileColors", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public class FileColorManagerImpl
extends FileColorManager
implements PersistentStateComponent<Element> {
    private boolean myEnabled;
    private FileColorsModel myModel;
    private FileColorSharedConfigurationManager mySharedConfigurationManager;
    private Project myProject;
    private boolean myEnabledForTabs;
    private static Map<String, Color> ourDefaultColors = new LinkedHashMap();

    public FileColorManagerImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/FileColorManagerImpl.<init> must not be null");
        }
        this.myEnabled = true;
        this.myEnabledForTabs = true;
        this.myProject = project;
        this.myModel = new FileColorsModel(project);
    }

    private void initSharedConfigurations() {
        if (this.mySharedConfigurationManager == null) {
            this.mySharedConfigurationManager = (FileColorSharedConfigurationManager)ServiceManager.getService((Project)this.myProject, FileColorSharedConfigurationManager.class);
        }
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public void setEnabledForTabs(boolean b) {
        this.myEnabledForTabs = b;
    }

    public boolean isEnabledForTabs() {
        return this.myEnabledForTabs;
    }

    public Element getState(boolean shared) {
        Element element = new Element("state");
        if (!shared) {
            element.setAttribute("enabled", Boolean.toString(this.myEnabled));
            element.setAttribute("enabledForTabs", Boolean.toString(this.myEnabledForTabs));
        }
        this.myModel.save(element, shared);
        return element;
    }

    @Nullable
    public Color getColor(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/FileColorManagerImpl.getColor must not be null");
        }
        return ourDefaultColors.get(name);
    }

    public static String toString(Color color) {
        return Integer.toHexString(color.getRGB() & 0xFFFFFF | 0x1000000).substring(1);
    }

    public static Color fromString(String hex) throws NumberFormatException {
        return Color.decode(String.format("#%s", hex));
    }

    public Element getState() {
        this.initSharedConfigurations();
        return this.getState(false);
    }

    void loadState(Element state, boolean shared) {
        if (!shared) {
            String enabled = state.getAttributeValue("enabled");
            this.myEnabled = enabled == null ? true : Boolean.valueOf(enabled);
            String enabledForTabs = state.getAttributeValue("enabledForTabs");
            this.myEnabledForTabs = enabledForTabs == null ? false : Boolean.valueOf(enabledForTabs);
        }
        this.myModel.load(state, shared);
    }

    public Collection<String> getColorNames() {
        Set<String> names = ourDefaultColors.keySet();
        ArrayList<String> sorted = new ArrayList<String>(names);
        Collections.sort(sorted);
        return sorted;
    }

    public void loadState(Element state) {
        this.initSharedConfigurations();
        this.loadState(state, false);
    }

    public boolean isColored(@NotNull String scopeName, boolean shared) {
        if (scopeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/FileColorManagerImpl.isColored must not be null");
        }
        return this.myModel.isColored(scopeName, shared);
    }

    @Nullable
    public Color getRendererBackground(VirtualFile file) {
        return this.getRendererBackground(PsiManager.getInstance((Project)this.myProject).findFile(file));
    }

    @Nullable
    public Color getRendererBackground(PsiFile file) {
        Color fileColor;
        if (file == null) {
            return null;
        }
        if (this.isEnabled() && (fileColor = this.getFileColor(file)) != null) {
            return fileColor;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        return FileEditorManager.getInstance((Project)this.myProject).isFileOpen(vFile) ? LightColors.SLIGHTLY_GREEN : null;
    }

    @Nullable
    public Color getFileColor(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/FileColorManagerImpl.getFileColor must not be null");
        }
        String colorName = this.myModel.getColor(file);
        return colorName == null ? null : ourDefaultColors.get(colorName);
    }

    public boolean isShared(@NotNull String scopeName) {
        if (scopeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/FileColorManagerImpl.isShared must not be null");
        }
        return this.myModel.isShared(scopeName);
    }

    FileColorsModel getModel() {
        return this.myModel;
    }

    boolean isShared(FileColorConfiguration configuration) {
        return this.myModel.isShared(configuration);
    }

    public Project getProject() {
        return this.myProject;
    }

    public List<FileColorConfiguration> getLocalConfigurations() {
        return this.myModel.getLocalConfigurations();
    }

    public List<FileColorConfiguration> getSharedConfigurations() {
        return this.myModel.getSharedConfigurations();
    }

    static {
        ourDefaultColors.put("Blue", new Color(215, 237, 243));
        ourDefaultColors.put("Green", new Color(228, 241, 209));
        ourDefaultColors.put("Orange", new Color(246, 224, 202));
        ourDefaultColors.put("Rose", new Color(242, 206, 202));
        ourDefaultColors.put("Violet", new Color(222, 213, 241));
        ourDefaultColors.put("Yellow", new Color(247, 241, 203));
    }
}

