/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.tabs;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class PinToolwindowTabAction
extends ToggleAction
implements DumbAware {
    public static final String ACTION_NAME = "PinToolwindowTab";
    private static final Icon ICON = IconLoader.getIcon((String)"/general/pin_tab.png");

    public static AnAction getPinAction() {
        return ActionManager.getInstance().getAction(ACTION_NAME);
    }

    public PinToolwindowTabAction() {
        super("Pin Tab", "Pin tool window tab", ICON);
    }

    @Nullable
    private static Content getContextContent(AnActionEvent event) {
        ContentManager contentManager;
        ToolWindow window = (ToolWindow)PlatformDataKeys.TOOL_WINDOW.getData(event.getDataContext());
        if (window != null && (contentManager = window.getContentManager()) != null) {
            return contentManager.getSelectedContent();
        }
        return null;
    }

    public boolean isSelected(AnActionEvent event) {
        Content content = PinToolwindowTabAction.getContextContent(event);
        return content != null && content.isPinned();
    }

    public void setSelected(AnActionEvent event, boolean flag) {
        Content content = PinToolwindowTabAction.getContextContent(event);
        if (content != null) {
            content.setPinned(flag);
        }
    }

    public void update(AnActionEvent event) {
        boolean enabled;
        super.update(event);
        Presentation presentation = event.getPresentation();
        Content content = PinToolwindowTabAction.getContextContent(event);
        boolean bl = enabled = content != null && content.isPinnable();
        if (enabled) {
            presentation.setIcon("TabbedPanePopup".equals(event.getPlace()) || "ToolwindowPopup".equals(event.getPlace()) ? null : ICON);
        }
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled);
    }
}

