/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.mock.MockApplication;
import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.MutablePicoContainer;

public abstract class PlatformLiteFixture
extends UsefulTestCase {
    protected MockProject myProject;

    protected void setUp() throws Exception {
        super.setUp();
        Extensions.cleanRootArea((Disposable)this.getTestRootDisposable());
    }

    public static MockApplication getApplication() {
        return (MockApplication)ApplicationManager.getApplication();
    }

    public void initApplication() {
        if (ApplicationManager.getApplication() instanceof MockApplication) {
            return;
        }
        ApplicationManagerEx.setApplication(this.disposeOnTearDown(new MockApplication()), this.getTestRootDisposable());
        PlatformLiteFixture.getApplication().registerService(EncodingManager.class, EncodingManagerImpl.class);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        PlatformLiteFixture.clearFields((Object)this);
        this.myProject = null;
    }

    protected <T> void registerExtension(ExtensionPointName<T> extensionPointName, @NotNull T t) {
        if (t == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/PlatformLiteFixture.registerExtension must not be null");
        }
        this.registerExtension(Extensions.getRootArea(), extensionPointName, t);
    }

    public <T> void registerExtension(ExtensionsArea area, ExtensionPointName<T> name, T t) {
        this.registerExtensionPoint(area, name, t.getClass());
        PlatformTestUtil.registerExtension(area, name, t, this.myTestRootDisposable);
    }

    protected <T> void registerExtensionPoint(ExtensionPointName<T> extensionPointName, Class<T> aClass) {
        this.registerExtensionPoint(Extensions.getRootArea(), extensionPointName, aClass);
    }

    protected <T> void registerExtensionPoint(ExtensionsArea area, ExtensionPointName<T> extensionPointName, Class<? extends T> aClass) {
        String name = extensionPointName.getName();
        if (!area.hasExtensionPoint(name)) {
            area.registerExtensionPoint(name, aClass.getName());
        }
    }

    protected void registerComponentImplementation(MutablePicoContainer container, Class<?> key, Class<?> implementation) {
        container.unregisterComponent(key);
        container.registerComponentImplementation(key, implementation);
    }

    protected <T> void registerComponentInstance(MutablePicoContainer container, Class<T> key, T implementation) {
        container.unregisterComponent(key);
        container.registerComponentInstance(key, implementation);
    }
}

