/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.occurences;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.occurences.BaseOccurenceManager;
import com.intellij.refactoring.util.occurences.OccurenceFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public class ExpressionOccurenceManager
extends BaseOccurenceManager {
    private PsiExpression myMainOccurence;
    private final PsiElement myScope;
    private final boolean myMaintainStaticContext;

    public ExpressionOccurenceManager(PsiExpression mainOccurence, PsiElement scope, OccurenceFilter filter) {
        this(mainOccurence, scope, filter, false);
    }

    public ExpressionOccurenceManager(PsiExpression mainOccurence, PsiElement scope, OccurenceFilter filter, boolean maintainStaticContext) {
        super(filter);
        this.myMainOccurence = mainOccurence;
        this.myScope = scope;
        this.myMaintainStaticContext = maintainStaticContext;
    }

    @Override
    protected PsiExpression[] defaultOccurences() {
        return new PsiExpression[]{this.myMainOccurence};
    }

    public PsiExpression getMainOccurence() {
        return this.myMainOccurence;
    }

    @Override
    protected PsiExpression[] findOccurences() {
        if ("null".equals(this.myMainOccurence.getText())) {
            return this.defaultOccurences();
        }
        if (this.myFilter != null && !this.myFilter.isOK(this.myMainOccurence)) {
            return this.defaultOccurences();
        }
        PsiExpression[] expressionOccurrences = this.findExpressionOccurrences();
        PsiClass scopeClass = (PsiClass)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myScope, (Class[])new Class[]{PsiClass.class});
        if (this.myMaintainStaticContext && expressionOccurrences.length > 1 && !RefactoringUtil.isInStaticContext((PsiElement)this.myMainOccurence, scopeClass)) {
            ArrayList<PsiExpression> expressions = new ArrayList<PsiExpression>(Arrays.asList(expressionOccurrences));
            Iterator<PsiExpression> iterator = expressions.iterator();
            while (iterator.hasNext()) {
                PsiExpression expression = iterator.next();
                if (!RefactoringUtil.isInStaticContext((PsiElement)expression, scopeClass)) continue;
                iterator.remove();
            }
            return expressions.toArray(new PsiExpression[expressions.size()]);
        }
        return expressionOccurrences;
    }

    public PsiElement getScope() {
        return this.myScope;
    }

    public PsiExpression[] findExpressionOccurrences() {
        if (this.myMainOccurence instanceof PsiLiteralExpression && !this.myMainOccurence.isPhysical()) {
            FindManager findManager = FindManager.getInstance((Project)this.getScope().getProject());
            FindModel findModel = (FindModel)findManager.getFindInFileModel().clone();
            findModel.setCaseSensitive(true);
            String value = StringUtil.stripQuotesAroundValue((String)this.myMainOccurence.getText());
            if (value.length() > 0) {
                findModel.setStringToFind(value);
                ArrayList<PsiExpression> results = new ArrayList<PsiExpression>();
                PsiFile file = this.getScope().getContainingFile();
                String text = this.getScope().getText();
                int offset = this.getScope().getTextRange().getStartOffset();
                FindResult result = findManager.findString((CharSequence)text, 0, findModel);
                HashSet<PsiLiteralExpression> literals = new HashSet<PsiLiteralExpression>();
                while (result.isStringFound()) {
                    PsiExpression expression;
                    int startOffset = offset + result.getStartOffset();
                    int endOffset = result.getEndOffset();
                    PsiLiteralExpression literalExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(startOffset), PsiLiteralExpression.class);
                    if (literalExpression != null && !literals.contains(literalExpression) && (expression = IntroduceVariableBase.getSelectedExpression(file.getProject(), file, startOffset, offset + endOffset)) != null) {
                        results.add(expression);
                        literals.add(literalExpression);
                    }
                    result = findManager.findString((CharSequence)text, endOffset, findModel);
                }
                return results.toArray(new PsiExpression[results.size()]);
            }
        }
        return CodeInsightUtil.findExpressionOccurrences(this.myScope, this.myMainOccurence);
    }
}

