/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassHandler;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class MoveJavaClassHandler
implements MoveClassHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveClassesOrPackages.MoveJavaClassHandler");

    @Override
    public PsiClass doMoveClass(@NotNull PsiClass aClass, @NotNull PsiDirectory moveDestination) throws IncorrectOperationException {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/move/moveClassesOrPackages/MoveJavaClassHandler.doMoveClass must not be null");
        }
        if (moveDestination == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/move/moveClassesOrPackages/MoveJavaClassHandler.doMoveClass must not be null");
        }
        PsiFile file = aClass.getContainingFile();
        PsiPackage newPackage = JavaDirectoryService.getInstance().getPackage(moveDestination);
        PsiClass newClass = null;
        if (file instanceof PsiJavaFile && ((PsiJavaFile)file).getClasses().length > 1) {
            PsiDocComment createdDocComment;
            MoveJavaClassHandler.correctSelfReferences(aClass, newPackage);
            PsiClass created = JavaDirectoryService.getInstance().createClass(moveDestination, aClass.getName());
            if (aClass.getDocComment() == null && (createdDocComment = created.getDocComment()) != null) {
                aClass.addAfter((PsiElement)createdDocComment, null);
            }
            newClass = (PsiClass)created.replace((PsiElement)aClass);
            MoveJavaClassHandler.correctOldClassReferences(newClass, aClass);
            aClass.delete();
        } else if (file instanceof PsiJavaFile && !moveDestination.equals(file.getContainingDirectory()) && moveDestination.findFile(file.getName()) != null) {
            MoveJavaClassHandler.correctSelfReferences(aClass, newPackage);
            PsiFile newFile = moveDestination.findFile(file.getName());
            LOG.assertTrue(newFile != null);
            newClass = (PsiClass)newFile.add((PsiElement)aClass);
            MoveJavaClassHandler.correctOldClassReferences(newClass, aClass);
            aClass.delete();
        }
        return newClass;
    }

    private static void correctOldClassReferences(final PsiClass newClass, final PsiClass oldClass) {
        final HashSet importsToDelete = new HashSet();
        newClass.getContainingFile().accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                if (reference.isReferenceTo((PsiElement)oldClass)) {
                    PsiImportStatementBase importStatement = (PsiImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiImportStatementBase.class);
                    if (importStatement != null) {
                        importsToDelete.add(importStatement);
                        return;
                    }
                    try {
                        reference.bindToElement((PsiElement)newClass);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
                super.visitReferenceElement(reference);
            }
        });
        for (PsiImportStatementBase importStatement : importsToDelete) {
            importStatement.delete();
        }
    }

    private static void correctSelfReferences(final PsiClass aClass, final PsiPackage newContainingPackage) {
        final PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(aClass.getContainingFile().getContainingDirectory());
        if (aPackage != null) {
            aClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                    PsiElement qualifier;
                    if (reference.isQualified() && reference.isReferenceTo((PsiElement)aClass) && (qualifier = reference.getQualifier()) instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)qualifier).isReferenceTo((PsiElement)aPackage)) {
                        try {
                            ((PsiJavaCodeReferenceElement)qualifier).bindToElement((PsiElement)newContainingPackage);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                    super.visitReferenceElement(reference);
                }
            });
        }
    }

    @Override
    public String getName(PsiClass clazz) {
        PsiFile file = clazz.getContainingFile();
        if (!(file instanceof PsiJavaFile)) {
            return null;
        }
        return ((PsiJavaFile)file).getClasses().length > 1 ? clazz.getName() + "." + StdFileTypes.JAVA.getDefaultExtension() : file.getName();
    }
}

