/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.migration.MigrationMapEntry;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EditMigrationEntryDialog
extends DialogWrapper {
    private JRadioButton myRbPackage;
    private JRadioButton myRbClass;
    private JTextField myOldNameField;
    private JTextField myNewNameField;
    private final Project myProject;

    public EditMigrationEntryDialog(Project project) {
        super(project, true);
        this.myProject = project;
        this.setTitle(RefactoringBundle.message((String)"edit.migration.entry.title"));
        this.setHorizontalStretch(1.2f);
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myOldNameField;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        panel.setBorder(IdeBorderFactory.createBorder());
        gbConstraints.insets = new Insets(4, 4, 4, 4);
        gbConstraints.weighty = 1.0;
        gbConstraints.gridwidth = -1;
        gbConstraints.fill = 1;
        gbConstraints.weightx = 0.0;
        this.myRbPackage = new JRadioButton(RefactoringBundle.message((String)"migration.entry.package"));
        panel.add((Component)this.myRbPackage, gbConstraints);
        gbConstraints.gridwidth = -1;
        gbConstraints.fill = 1;
        gbConstraints.weightx = 0.0;
        this.myRbClass = new JRadioButton(RefactoringBundle.message((String)"migration.entry.class"));
        panel.add((Component)this.myRbClass, gbConstraints);
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        panel.add((Component)new JPanel(), gbConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myRbPackage);
        buttonGroup.add(this.myRbClass);
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = -1;
        gbConstraints.fill = 3;
        JLabel oldNamePrompt = new JLabel(RefactoringBundle.message((String)"migration.entry.old.name"));
        panel.add((Component)oldNamePrompt, gbConstraints);
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        this.myOldNameField = new JTextField();
        panel.add((Component)this.myOldNameField, gbConstraints);
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = -1;
        gbConstraints.fill = 3;
        JLabel newNamePrompt = new JLabel(RefactoringBundle.message((String)"migration.entry.new.name"));
        panel.add((Component)newNamePrompt, gbConstraints);
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        this.myNewNameField = new JTextField();
        panel.setPreferredSize(new Dimension(300, panel.getPreferredSize().height));
        panel.add((Component)this.myNewNameField, gbConstraints);
        DocumentAdapter documentListener = new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                EditMigrationEntryDialog.this.validateOKButton();
            }
        };
        this.myOldNameField.getDocument().addDocumentListener((DocumentListener)documentListener);
        this.myNewNameField.getDocument().addDocumentListener((DocumentListener)documentListener);
        return panel;
    }

    private void validateOKButton() {
        boolean isEnabled = true;
        String text = this.myOldNameField.getText();
        text = text.trim();
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        if (!JavaPsiFacade.getInstance((Project)manager.getProject()).getNameHelper().isQualifiedName(text)) {
            isEnabled = false;
        }
        text = this.myNewNameField.getText();
        text = text.trim();
        if (!JavaPsiFacade.getInstance((Project)manager.getProject()).getNameHelper().isQualifiedName(text)) {
            isEnabled = false;
        }
        this.setOKActionEnabled(isEnabled);
    }

    public void setEntry(MigrationMapEntry entry) {
        this.myOldNameField.setText(entry.getOldName());
        this.myNewNameField.setText(entry.getNewName());
        this.myRbPackage.setSelected(entry.getType() == 0);
        this.myRbClass.setSelected(entry.getType() == 1);
        this.validateOKButton();
    }

    public void updateEntry(MigrationMapEntry entry) {
        entry.setOldName(this.myOldNameField.getText().trim());
        entry.setNewName(this.myNewNameField.getText().trim());
        if (this.myRbPackage.isSelected()) {
            entry.setType(0);
            entry.setRecursive(true);
        } else {
            entry.setType(1);
        }
    }
}

