/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineViewDescriptor;
import com.intellij.refactoring.inline.ReferencedElementsCollector;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

class InlineConstantFieldProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.inline.InlineConstantFieldProcessor");
    private PsiField myField;
    private final PsiReferenceExpression myRefExpr;
    private final boolean myInlineThisOnly;

    InlineConstantFieldProcessor(PsiField field, Project project, PsiReferenceExpression ref, boolean isInlineThisOnly) {
        super(project);
        this.myField = field;
        this.myRefExpr = ref;
        this.myInlineThisOnly = isInlineThisOnly;
    }

    @Override
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        return new InlineViewDescriptor((PsiElement)this.myField);
    }

    @Override
    protected boolean isPreviewUsages(UsageInfo[] usages) {
        if (super.isPreviewUsages(usages)) {
            return true;
        }
        for (UsageInfo info : usages) {
            if (!(info instanceof UsageFromJavaDoc)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        UsageInfo[] usageInfoArray;
        if (this.myInlineThisOnly) {
            usageInfoArray = new UsageInfo[]{new UsageInfo((PsiQualifiedReference)this.myRefExpr)};
            if (usageInfoArray == null) throw new IllegalStateException("@NotNull method com/intellij/refactoring/inline/InlineConstantFieldProcessor.findUsages must not return null");
            return usageInfoArray;
        }
        PsiReference[] refs = (PsiReference[])ReferencesSearch.search((PsiElement)this.myField, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (boolean)false).toArray((Object[])new PsiReference[0]);
        UsageInfo[] infos = new UsageInfo[refs.length];
        for (int i = 0; i < refs.length; ++i) {
            PsiElement element = refs[i].getElement();
            UsageInfo info = new UsageInfo(element);
            if (!(element instanceof PsiExpression) && PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class) == null) {
                info = new UsageFromJavaDoc(element);
            }
            infos[i] = info;
        }
        usageInfoArray = infos;
        if (infos != null) return usageInfoArray;
        throw new IllegalStateException("@NotNull method com/intellij/refactoring/inline/InlineConstantFieldProcessor.findUsages must not return null");
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
        LOG.assertTrue(elements.length == 1 && elements[0] instanceof PsiField);
        this.myField = (PsiField)elements[0];
    }

    @Override
    protected void performRefactoring(UsageInfo[] usages) {
        PsiExpression initializer = this.myField.getInitializer();
        LOG.assertTrue(initializer != null);
        PsiConstantEvaluationHelper evalHelper = JavaPsiFacade.getInstance((Project)this.myField.getProject()).getConstantEvaluationHelper();
        initializer = InlineConstantFieldProcessor.normalize((PsiExpression)initializer.copy());
        for (UsageInfo info : usages) {
            if (info instanceof UsageFromJavaDoc) continue;
            PsiElement element = info.getElement();
            try {
                if (element instanceof PsiExpression) {
                    this.inlineExpressionUsage((PsiExpression)element, evalHelper, initializer);
                    continue;
                }
                PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class);
                LOG.assertTrue(importStaticStatement != null, (Object)element.getText());
                importStaticStatement.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (!this.myInlineThisOnly) {
            try {
                this.myField.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void inlineExpressionUsage(PsiExpression expr, PsiConstantEvaluationHelper evalHelper, PsiExpression initializer1) throws IncorrectOperationException {
        PsiExpression qExpression;
        PsiType type;
        PsiArrayAccessExpression arrayAccess;
        Object value;
        while (expr.getParent() instanceof PsiArrayAccessExpression && (value = evalHelper.computeConstantExpression((PsiElement)(arrayAccess = (PsiArrayAccessExpression)expr.getParent()).getIndexExpression())) instanceof Integer) {
            int intValue = (Integer)value;
            if (!(initializer1 instanceof PsiNewExpression)) break;
            PsiExpression[] arrayInitializers = ((PsiNewExpression)initializer1).getArrayInitializer().getInitializers();
            if (0 > intValue || intValue >= arrayInitializers.length) break;
            expr = (PsiExpression)expr.getParent();
            initializer1 = InlineConstantFieldProcessor.normalize(arrayInitializers[intValue]);
        }
        if (initializer1 instanceof PsiArrayInitializerExpression && (type = expr.getType()) != null) {
            initializer1 = (PsiExpression)initializer1.replace((PsiElement)((PsiNewExpression)JavaPsiFacade.getInstance((Project)expr.getProject()).getElementFactory().createExpressionFromText("new " + type.getCanonicalText() + initializer1.getText(), (PsiElement)initializer1)));
        }
        this.myField.normalizeDeclaration();
        ChangeContextUtil.encodeContextInfo((PsiElement)initializer1, true);
        if (expr instanceof PsiReferenceExpression && (qExpression = ((PsiReferenceExpression)expr).getQualifierExpression()) != null) {
            PsiReferenceExpression referenceExpression;
            if (initializer1 instanceof PsiMethodCallExpression) {
                PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)initializer1).getMethodExpression();
                if (methodExpression.getQualifierExpression() == null) {
                    methodExpression.setQualifierExpression(qExpression);
                }
            } else if (initializer1 instanceof PsiReferenceExpression && (referenceExpression = (PsiReferenceExpression)initializer1).getQualifierExpression() == null) {
                referenceExpression.setQualifierExpression(qExpression);
            }
        }
        PsiElement element = expr.replace((PsiElement)initializer1);
        ChangeContextUtil.decodeContextInfo(element, null, null);
    }

    private static PsiExpression normalize(PsiExpression expression) {
        if (expression instanceof PsiArrayInitializerExpression) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expression.getProject()).getElementFactory();
            try {
                PsiType type = expression.getType();
                if (type != null) {
                    String typeString = type.getCanonicalText();
                    PsiNewExpression result = (PsiNewExpression)factory.createExpressionFromText("new " + typeString + "{}", (PsiElement)expression);
                    result.getArrayInitializer().replace((PsiElement)expression);
                    return result;
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return expression;
            }
        }
        return expression;
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"inline.field.command", (Object[])new Object[]{UsageViewUtil.getDescriptiveName((PsiElement)this.myField)});
    }

    @Override
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        ReferencedElementsCollector collector = new ReferencedElementsCollector();
        PsiExpression initializer = this.myField.getInitializer();
        LOG.assertTrue(initializer != null);
        initializer.accept((PsiElementVisitor)collector);
        HashSet<PsiMember> referencedWithVisibility = collector.myReferencedMembers;
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)this.myField.getProject()).getResolveHelper();
        for (UsageInfo info : usagesIn) {
            PsiElement element = info.getElement();
            if (element instanceof PsiExpression && InlineConstantFieldProcessor.isAccessedForWriting((PsiExpression)element)) {
                String message = RefactoringBundle.message((String)"0.is.used.for.writing.in.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myField, true), RefactoringUIUtil.getDescription(ConflictsUtil.getContainer(element), true)});
                conflicts.putValue((Object)element, (Object)message);
            }
            for (PsiMember member : referencedWithVisibility) {
                if (resolveHelper.isAccessible(member, element, null)) continue;
                String message = RefactoringBundle.message((String)"0.will.not.be.accessible.from.1.after.inlining", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, true), RefactoringUIUtil.getDescription(ConflictsUtil.getContainer(element), true)});
                conflicts.putValue((Object)member, (Object)message);
            }
        }
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts);
    }

    private static boolean isAccessedForWriting(PsiExpression expr) {
        while (expr.getParent() instanceof PsiArrayAccessExpression) {
            expr = (PsiExpression)expr.getParent();
        }
        return PsiUtil.isAccessedForWriting((PsiExpression)expr);
    }

    private static class UsageFromJavaDoc
    extends UsageInfo {
        private UsageFromJavaDoc(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/inline/InlineConstantFieldProcessor$UsageFromJavaDoc.<init> must not be null");
            }
            super(element, true);
        }
    }
}

