/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractSuperclass;

import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.memberPullUp.PullUpHelper;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Map;

public class ExtractSuperClassUtil {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.refactoring.extractSuperclass.ExtractSuperClassUtil");

    private ExtractSuperClassUtil() {
    }

    public static PsiClass extractSuperClass(Project project, PsiDirectory targetDirectory, String superclassName, PsiClass subclass, MemberInfo[] selectedMemberInfos, DocCommentPolicy javaDocPolicy) throws IncorrectOperationException {
        PsiClass superclass = JavaDirectoryService.getInstance().createClass(targetDirectory, superclassName);
        PsiModifierList superClassModifierList = superclass.getModifierList();
        assert (superClassModifierList != null);
        superClassModifierList.setModifierProperty("final", false);
        PsiReferenceList subClassExtends = subclass.getExtendsList();
        assert (subClassExtends != null) : subclass;
        ExtractSuperClassUtil.copyPsiReferenceList(subClassExtends, superclass.getExtendsList());
        PsiMethod[] constructors = ExtractSuperClassUtil.getCalledBaseConstructors(subclass);
        if (constructors.length > 0) {
            ExtractSuperClassUtil.createConstructorsByPattern(project, superclass, constructors);
        }
        ExtractSuperClassUtil.clearPsiReferenceList(subclass.getExtendsList());
        PsiJavaCodeReferenceElement ref = ExtractSuperClassUtil.createExtendingReference(superclass, subclass, selectedMemberInfos);
        subclass.getExtendsList().add((PsiElement)ref);
        PullUpHelper pullUpHelper = new PullUpHelper(subclass, superclass, selectedMemberInfos, javaDocPolicy);
        pullUpHelper.moveMembersToBase();
        pullUpHelper.moveFieldInitializations();
        Collection<MethodSignature> toImplement = OverrideImplementUtil.getMethodSignaturesToImplement(superclass);
        if (!toImplement.isEmpty()) {
            superClassModifierList.setModifierProperty("abstract", true);
        }
        return superclass;
    }

    private static void createConstructorsByPattern(Project project, PsiClass superclass, PsiMethod[] patternConstructors) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        for (PsiMethod baseConstructor : patternConstructors) {
            PsiMethod constructor = (PsiMethod)superclass.add((PsiElement)factory.createConstructor());
            PsiParameterList paramList = constructor.getParameterList();
            PsiParameter[] baseParams = baseConstructor.getParameterList().getParameters();
            StringBuilder superCallText = new StringBuilder();
            superCallText.append("super(");
            PsiClass baseClass = baseConstructor.getContainingClass();
            LOG.assertTrue(baseClass != null);
            PsiSubstitutor classSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)superclass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            for (int i = 0; i < baseParams.length; ++i) {
                PsiParameter baseParam = baseParams[i];
                PsiParameter newParam = (PsiParameter)paramList.add((PsiElement)factory.createParameter(baseParam.getName(), classSubstitutor.substitute(baseParam.getType())));
                if (i > 0) {
                    superCallText.append(",");
                }
                superCallText.append(newParam.getName());
            }
            superCallText.append(");");
            PsiStatement statement = factory.createStatementFromText(superCallText.toString(), null);
            statement = (PsiStatement)styleManager.reformat((PsiElement)statement);
            PsiCodeBlock body = constructor.getBody();
            assert (body != null);
            body.add((PsiElement)statement);
            constructor.getThrowsList().replace((PsiElement)baseConstructor.getThrowsList());
        }
    }

    private static PsiMethod[] getCalledBaseConstructors(PsiClass subclass) {
        PsiMethod[] constructors;
        java.util.HashSet<PsiMethod> baseConstructors = new java.util.HashSet<PsiMethod>();
        for (PsiMethod constructor : constructors = subclass.getConstructors()) {
            PsiMethod baseConstructor;
            PsiReferenceExpression calledMethod;
            String text;
            PsiExpression expression;
            PsiStatement first;
            PsiStatement[] statements;
            PsiCodeBlock body = constructor.getBody();
            if (body == null || (statements = body.getStatements()).length <= 0 || !((first = statements[0]) instanceof PsiExpressionStatement) || !((expression = ((PsiExpressionStatement)first).getExpression()) instanceof PsiMethodCallExpression) || !"super".equals(text = (calledMethod = ((PsiMethodCallExpression)expression).getMethodExpression()).getText()) || (baseConstructor = (PsiMethod)calledMethod.resolve()) == null) continue;
            baseConstructors.add(baseConstructor);
        }
        return baseConstructors.toArray(new PsiMethod[baseConstructors.size()]);
    }

    private static void clearPsiReferenceList(PsiReferenceList refList) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] refs;
        for (PsiJavaCodeReferenceElement ref : refs = refList.getReferenceElements()) {
            ref.delete();
        }
    }

    private static void copyPsiReferenceList(PsiReferenceList sourceList, PsiReferenceList destinationList) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] refs;
        ExtractSuperClassUtil.clearPsiReferenceList(destinationList);
        for (PsiJavaCodeReferenceElement ref : refs = sourceList.getReferenceElements()) {
            destinationList.add((PsiElement)ref);
        }
    }

    public static PsiJavaCodeReferenceElement createExtendingReference(PsiClass superClass, PsiClass derivedClass, MemberInfo[] selectedMembers) throws IncorrectOperationException {
        PsiManager manager = derivedClass.getManager();
        HashSet movedElements = new HashSet();
        for (MemberInfo info : selectedMembers) {
            movedElements.add(info.getMember());
        }
        PsiTypeParameterList typeParameterList = RefactoringUtil.createTypeParameterListWithUsedTypeParameters(movedElements.toArray(new PsiElement[movedElements.size()]));
        PsiTypeParameterList originalTypeParameterList = superClass.getTypeParameterList();
        assert (originalTypeParameterList != null);
        PsiTypeParameterList newList = typeParameterList != null ? (PsiTypeParameterList)originalTypeParameterList.replace((PsiElement)typeParameterList) : originalTypeParameterList;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        HashMap substitutionMap = new HashMap();
        for (PsiTypeParameter parameter : newList.getTypeParameters()) {
            substitutionMap.put(parameter, factory.createType((PsiClass)ExtractSuperClassUtil.findTypeParameterInDerived(derivedClass, parameter.getName())));
        }
        PsiClassType type = factory.createType(superClass, factory.createSubstitutor((Map)substitutionMap));
        return factory.createReferenceElementByType(type);
    }

    public static PsiTypeParameter findTypeParameterInDerived(PsiClass aClass, String name) {
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass)) {
            if (!name.equals(typeParameter.getName())) continue;
            return typeParameter;
        }
        LOG.error("Cannot find type parameter");
        return null;
    }
}

