/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiSuperExpressionImpl
extends ExpressionPsiElement
implements PsiSuperExpression,
Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiSuperExpressionImpl");

    public PsiSuperExpressionImpl() {
        super(SUPER_EXPRESSION);
    }

    public PsiJavaCodeReferenceElement getQualifier() {
        return (PsiJavaCodeReferenceElement)this.findChildByRoleAsPsiElement(54);
    }

    public PsiType getType() {
        PsiJavaCodeReferenceElement qualifier = this.getQualifier();
        if (qualifier != null) {
            PsiClass aClass = (PsiClass)qualifier.resolve();
            if (aClass == null) {
                return null;
            }
            return this.getSuperType(aClass);
        }
        for (PsiElement scope = this.getContext(); scope != null; scope = scope.getContext()) {
            PsiType fragmentSuperType;
            if (scope instanceof PsiClass) {
                PsiClass aClass = (PsiClass)scope;
                return this.getSuperType(aClass);
            }
            if (scope instanceof PsiExpressionList && scope.getParent() instanceof PsiAnonymousClass) {
                scope = scope.getParent();
                continue;
            }
            if (!(scope instanceof JavaCodeFragment) || (fragmentSuperType = ((JavaCodeFragment)scope).getSuperType()) == null) continue;
            return fragmentSuperType;
        }
        return null;
    }

    private PsiType getSuperType(PsiClass aClass) {
        if (aClass.isInterface()) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
            return facade.getElementFactory().createType(facade.findClass("java.lang.Object", this.getResolveScope()));
        }
        if (aClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)aClass).getBaseClassType();
            PsiClass psiClass = baseClassType.resolve();
            if (psiClass != null && !psiClass.isInterface()) {
                return baseClassType;
            }
            return PsiType.getJavaLangObject((PsiManager)this.getManager(), (GlobalSearchScope)this.getResolveScope());
        }
        if ("java.lang.Object".equals(aClass.getQualifiedName())) {
            return null;
        }
        PsiClassType[] superTypes = aClass.getExtendsListTypes();
        if (superTypes.length == 0) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
            PsiClass javaLangObject = facade.findClass("java.lang.Object", this.getResolveScope());
            if (javaLangObject != null) {
                return facade.getElementFactory().createType(javaLangObject);
            }
            return null;
        }
        return superTypes[0];
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 54: {
                if (this.getFirstChildNode().getElementType() == JAVA_CODE_REFERENCE) {
                    return this.getFirstChildNode();
                }
                return null;
            }
            case 55: {
                return this.findChildByType(DOT);
            }
            case 96: 
        }
        return this.getLastChildNode();
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JAVA_CODE_REFERENCE) {
            return 54;
        }
        if (i == DOT) {
            return 55;
        }
        if (i == SUPER_KEYWORD) {
            return 96;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiSuperExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitSuperExpression((PsiSuperExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiSuperExpression:" + this.getText();
    }
}

