/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.injected.editor.VirtualFileWindowImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.IdentitySmartPointer;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.LeafPatcher;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiHostRegistrarImpl
implements MultiHostRegistrar {
    List<Pair<Place, PsiFile>> result;
    private Language myLanguage;
    private List<LiteralTextEscaper<? extends PsiLanguageInjectionHost>> escapers;
    private List<PsiLanguageInjectionHost.Shred> shreds;
    private StringBuilder outChars;
    private boolean isOneLineEditor;
    private boolean cleared;
    private final Project myProject;
    private final PsiManager myPsiManager;
    private DocumentEx myHostDocument;
    private VirtualFile myHostVirtualFile;
    private final PsiElement myContextElement;
    private final PsiFile myHostPsiFile;
    private static final Key<ASTNode> TREE_HARD_REF = Key.create((String)"TREE_HARD_REF");

    MultiHostRegistrarImpl(@NotNull Project project, @NotNull PsiFile hostPsiFile, @NotNull PsiElement contextElement) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl.<init> must not be null");
        }
        if (hostPsiFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl.<init> must not be null");
        }
        if (contextElement == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl.<init> must not be null");
        }
        this.myProject = project;
        this.myContextElement = contextElement;
        this.myHostPsiFile = PsiUtilBase.getTemplateLanguageFile((PsiElement)hostPsiFile);
        this.myPsiManager = this.myHostPsiFile.getManager();
        this.cleared = true;
    }

    @NotNull
    public MultiHostRegistrar startInjecting(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl.startInjecting must not be null");
        }
        this.escapers = new SmartList();
        this.shreds = new SmartList();
        this.outChars = new StringBuilder();
        if (!this.cleared) {
            this.clear();
            throw new IllegalStateException("Seems you haven't called doneInjecting()");
        }
        if (LanguageParserDefinitions.INSTANCE.forLanguage(language) == null) {
            throw new UnsupportedOperationException("Cannot inject language '" + language + "' since its getParserDefinition() returns null");
        }
        this.myLanguage = language;
        FileViewProvider viewProvider = this.myHostPsiFile.getViewProvider();
        this.myHostVirtualFile = viewProvider.getVirtualFile();
        this.myHostDocument = (DocumentEx)viewProvider.getDocument();
        assert (this.myHostDocument != null) : this.myHostPsiFile + "; " + viewProvider;
        MultiHostRegistrarImpl multiHostRegistrarImpl = this;
        if (multiHostRegistrarImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl.startInjecting must not return null");
        }
        return multiHostRegistrarImpl;
    }

    private void clear() {
        this.escapers.clear();
        this.shreds.clear();
        this.outChars.setLength(0);
        this.isOneLineEditor = false;
        this.myLanguage = null;
        this.cleared = true;
    }

    @NotNull
    public MultiHostRegistrar addPlace(@NonNls @Nullable String prefix, @NonNls @Nullable String suffix, @NotNull PsiLanguageInjectionHost host, @NotNull TextRange rangeInsideHost) {
        if (host == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl.addPlace must not be null");
        }
        if (rangeInsideHost == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl.addPlace must not be null");
        }
        ProperTextRange.assertProperRange((TextRange)rangeInsideHost);
        PsiFile containingFile = PsiUtilBase.getTemplateLanguageFile((PsiElement)host);
        assert (containingFile == this.myHostPsiFile) : this.exceptionContext("Trying to inject into foreign file: " + containingFile);
        TextRange hostTextRange = host.getTextRange();
        if (!hostTextRange.contains(rangeInsideHost.shiftRight(hostTextRange.getStartOffset()))) {
            this.clear();
            throw new IllegalArgumentException("rangeInsideHost must lie within host text range. rangeInsideHost:" + rangeInsideHost + "; host textRange:" + hostTextRange);
        }
        if (this.myLanguage == null) {
            this.clear();
            throw new IllegalStateException("Seems you haven't called startInjecting()");
        }
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = "";
        }
        this.cleared = false;
        int startOffset = this.outChars.length();
        this.outChars.append(prefix);
        LiteralTextEscaper textEscaper = host.createLiteralTextEscaper();
        this.escapers.add((LiteralTextEscaper<? extends PsiLanguageInjectionHost>)textEscaper);
        this.isOneLineEditor |= textEscaper.isOneLine();
        TextRange relevantRange = textEscaper.getRelevantTextRange().intersection(rangeInsideHost);
        if (relevantRange == null) {
            relevantRange = TextRange.from((int)textEscaper.getRelevantTextRange().getStartOffset(), (int)0);
        } else {
            int before = this.outChars.length();
            boolean result = textEscaper.decode(relevantRange, this.outChars);
            int after = this.outChars.length();
            assert (after >= before) : "Escaper " + textEscaper + "(" + textEscaper.getClass() + ") must not mangle char buffer";
            if (!result) {
                int offsetInHost = textEscaper.getOffsetInHost(this.outChars.length() - startOffset, rangeInsideHost);
                relevantRange = relevantRange.intersection((TextRange)new ProperTextRange(0, offsetInHost));
            }
        }
        this.outChars.append(suffix);
        int endOffset = this.outChars.length();
        TextRange relevantRangeInHost = relevantRange.shiftRight(hostTextRange.getStartOffset());
        RangeMarker relevantMarker = this.myHostDocument.createRangeMarker(relevantRangeInHost);
        relevantMarker.setGreedyToLeft(true);
        relevantMarker.setGreedyToRight(true);
        this.shreds.add(new PsiLanguageInjectionHost.Shred(host, relevantMarker, prefix, suffix, (TextRange)new ProperTextRange(startOffset, endOffset)));
        MultiHostRegistrarImpl multiHostRegistrarImpl = this;
        if (multiHostRegistrarImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl.addPlace must not return null");
        }
        return multiHostRegistrarImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneInjecting() {
        try {
            DocumentImpl decodedDocument;
            if (this.shreds.isEmpty()) {
                throw new IllegalStateException("Seems you haven't called addPlace()");
            }
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            assert (ArrayUtil.indexOf((Object[])documentManager.getUncommittedDocuments(), (Object)this.myHostDocument) == -1) : "document is uncommitted: " + this.myHostDocument;
            assert (this.myHostPsiFile.getText().equals(this.myHostDocument.getText())) : "host text mismatch";
            Place place = new Place(this.shreds);
            DocumentWindowImpl documentWindow = new DocumentWindowImpl(this.myHostDocument, this.isOneLineEditor, place);
            VirtualFileWindowImpl virtualFile = new VirtualFileWindowImpl(this.myHostVirtualFile, documentWindow, this.myLanguage, this.outChars);
            this.myLanguage = LanguageSubstitutors.INSTANCE.substituteLanguage(this.myLanguage, (VirtualFile)virtualFile, this.myProject);
            virtualFile.setLanguage(this.myLanguage);
            if (StringUtil.indexOf((CharSequence)this.outChars, (char)'\r') == -1) {
                decodedDocument = new DocumentImpl(this.outChars);
            } else {
                decodedDocument = new DocumentImpl(true);
                decodedDocument.setAcceptSlashR(true);
                decodedDocument.replaceString(0, 0, this.outChars);
            }
            FileDocumentManagerImpl.registerDocument(decodedDocument, (VirtualFile)virtualFile);
            InjectedFileViewProvider viewProvider = new InjectedFileViewProvider(this.myPsiManager, virtualFile, place, documentWindow, this.myLanguage);
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.myLanguage);
            assert (parserDefinition != null) : "Parser definition for language " + this.myLanguage + " is null";
            PsiFile psiFile = parserDefinition.createFile((FileViewProvider)viewProvider);
            SmartPsiElementPointer<PsiLanguageInjectionHost> pointer = MultiHostRegistrarImpl.createHostSmartPointer(this.shreds.get((int)0).host);
            Object object = PsiLock.LOCK;
            synchronized (object) {
                boolean mergeHappened;
                ASTNode parsedNode = MultiHostRegistrarImpl.keepTreeFromChameleoningBack(psiFile);
                assert (parsedNode instanceof FileElement) : "Parsed to " + parsedNode + " instead of FileElement";
                String documentText = documentWindow.getText();
                assert (this.outChars.toString().equals(parsedNode.getText())) : this.exceptionContext("Before patch: doc:\n'" + documentText + "'\n---PSI:\n'" + parsedNode.getText() + "'\n---chars:\n'" + this.outChars + "'");
                try {
                    MultiHostRegistrarImpl.patchLeafs(parsedNode, this.escapers, place);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw new RuntimeException(this.exceptionContext("Patch error"), e);
                }
                assert (parsedNode.getText().equals(documentText)) : this.exceptionContext("After patch: doc:\n'" + documentText + "'\n---PSI:\n'" + parsedNode.getText() + "'\n---chars:\n'" + this.outChars + "'");
                virtualFile.setContent(null, documentWindow.getText(), false);
                MultiHostRegistrarImpl.cacheEverything(place, documentWindow, viewProvider, psiFile, pointer);
                PsiFile cachedPsiFile = documentManager.getCachedPsiFile((Document)documentWindow);
                assert (cachedPsiFile == psiFile) : "Cached psi :" + cachedPsiFile + " instead of " + psiFile;
                assert (place.isValid());
                assert (viewProvider.isValid());
                PsiFile newFile = MultiHostRegistrarImpl.registerDocument(documentWindow, psiFile, place, this.myHostPsiFile, documentManager);
                boolean bl = mergeHappened = newFile != psiFile;
                if (mergeHappened) {
                    InjectedLanguageUtil.clearCaches(psiFile);
                    psiFile = newFile;
                    viewProvider = (InjectedFileViewProvider)psiFile.getViewProvider();
                    documentWindow = (DocumentWindowImpl)viewProvider.getDocument();
                    virtualFile = (VirtualFileWindowImpl)viewProvider.getVirtualFile();
                    MultiHostRegistrarImpl.cacheEverything(place, documentWindow, viewProvider, psiFile, pointer);
                }
                assert (psiFile.isValid());
                assert (place.isValid());
                assert (viewProvider.isValid());
                try {
                    List<Trinity<IElementType, PsiLanguageInjectionHost, TextRange>> tokens = MultiHostRegistrarImpl.obtainHighlightTokensFromLexer(this.myLanguage, this.outChars, this.escapers, place, virtualFile, this.myProject);
                    psiFile.putUserData(InjectedLanguageUtil.HIGHLIGHT_TOKENS, tokens);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw new RuntimeException(this.exceptionContext("Obtaining tokens error"), e);
                }
                this.addToResults(place, psiFile);
                this.assertEverythingIsAllright(documentManager, documentWindow, psiFile);
            }
        }
        finally {
            this.clear();
        }
    }

    private static void cacheEverything(Place place, DocumentWindowImpl documentWindow, InjectedFileViewProvider viewProvider, PsiFile psiFile, SmartPsiElementPointer<PsiLanguageInjectionHost> pointer) {
        FileDocumentManagerImpl.registerDocument(documentWindow, viewProvider.getVirtualFile());
        viewProvider.forceCachedPsi(psiFile);
        psiFile.putUserData(FileContextUtil.INJECTED_IN_ELEMENT, pointer);
        PsiDocumentManagerImpl.cachePsi(documentWindow, psiFile);
        MultiHostRegistrarImpl.keepTreeFromChameleoningBack(psiFile);
        viewProvider.setShreds(place);
    }

    @NonNls
    private String exceptionContext(@NonNls String msg) {
        return msg + ".\n" + this.myLanguage + ";\n " + "Host file: " + this.myHostPsiFile + " in '" + this.myHostVirtualFile.getPresentableUrl() + "'\n" + "Context element " + this.myContextElement.getTextRange() + ": '" + this.myContextElement + "'; " + "Ranges: " + this.shreds;
    }

    private static ASTNode keepTreeFromChameleoningBack(PsiFile psiFile) {
        psiFile.getFirstChild();
        ASTNode node = psiFile.getNode();
        assert (!TreeUtil.isCollapsedChameleon(node)) : "Chameleon " + node + " is collapsed";
        psiFile.putUserData(TREE_HARD_REF, (Object)node);
        return node;
    }

    private void assertEverythingIsAllright(PsiDocumentManager documentManager, DocumentWindowImpl documentWindow, PsiFile psiFile) {
        boolean isAncestor = false;
        for (PsiLanguageInjectionHost.Shred shred : this.shreds) {
            PsiLanguageInjectionHost host = shred.host;
            isAncestor |= PsiTreeUtil.isAncestor((PsiElement)this.myContextElement, (PsiElement)host, (boolean)false);
        }
        assert (isAncestor) : this.exceptionContext(this.myContextElement + " must be the parent of at least one of injection hosts");
        InjectedFileViewProvider injectedFileViewProvider = (InjectedFileViewProvider)psiFile.getViewProvider();
        assert (injectedFileViewProvider.isValid()) : "Invalid view provider: " + (Object)((Object)injectedFileViewProvider);
        assert (documentWindow.getText().equals(psiFile.getText())) : "Document window text mismatch";
        assert (injectedFileViewProvider.getDocument() == documentWindow) : "Provider document mismatch";
        assert (documentManager.getCachedDocument(psiFile) == documentWindow) : "Cached document mismatch";
        assert (psiFile.getVirtualFile() == injectedFileViewProvider.getVirtualFile()) : "Virtual file mismatch: " + psiFile.getVirtualFile() + "; " + injectedFileViewProvider.getVirtualFile();
        PsiDocumentManagerImpl.checkConsistency(psiFile, documentWindow);
    }

    void addToResults(Place place, PsiFile psiFile) {
        if (this.result == null) {
            this.result = new SmartList();
        }
        this.result.add((Pair<Place, PsiFile>)Pair.create((Object)((Object)place), (Object)psiFile));
    }

    private static <T extends PsiLanguageInjectionHost> SmartPsiElementPointer<T> createHostSmartPointer(T host) {
        return host.isPhysical() ? SmartPointerManager.getInstance((Project)host.getProject()).createSmartPsiElementPointer(host) : new IdentitySmartPointer(host);
    }

    private static void patchLeafs(ASTNode parsedNode, List<LiteralTextEscaper<? extends PsiLanguageInjectionHost>> escapers, Place shreds) {
        LeafPatcher patcher = new LeafPatcher(shreds, escapers);
        ((TreeElement)parsedNode).acceptTree(patcher);
        String nodeText = parsedNode.getText();
        assert (nodeText.equals(patcher.catLeafs.toString())) : "Malformed PSI structure: leaf texts do not add up to the whole file text.\nFile text (from tree)  :'" + nodeText + "'" + "\nFile text (from PSI)   :'" + parsedNode.getPsi().getText() + "'" + "\nLeaf texts concatenated:'" + patcher.catLeafs + "';" + "\nFile root: " + parsedNode + "\nLanguage: " + parsedNode.getPsi().getLanguage() + "\nHost file: " + ((PsiLanguageInjectionHost.Shred)shreds.get((int)0)).host.getContainingFile().getVirtualFile();
        for (Map.Entry<LeafElement, String> entry : patcher.newTexts.entrySet()) {
            LeafElement leaf = entry.getKey();
            String newText = entry.getValue();
            leaf.rawReplaceWithText(newText);
        }
        ((TreeElement)parsedNode).acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            protected void visitNode(TreeElement element) {
                element.clearCaches();
                super.visitNode(element);
            }
        });
    }

    private static PsiFile registerDocument(DocumentWindowImpl documentWindow, PsiFile injectedPsi, Place shreds, PsiFile hostPsiFile, PsiDocumentManager documentManager) {
        DocumentEx hostDocument = documentWindow.getDelegate();
        List<DocumentWindow> injected = InjectedLanguageUtil.getCachedInjectedDocuments(hostPsiFile);
        for (int i = injected.size() - 1; i >= 0; --i) {
            FileViewProvider viewProvider;
            DocumentWindowImpl oldDocument = (DocumentWindowImpl)injected.get(i);
            final PsiFileImpl oldFile = (PsiFileImpl)documentManager.getCachedPsiFile((Document)oldDocument);
            if (oldFile == null || !oldFile.isValid() || !((viewProvider = oldFile.getViewProvider()) instanceof InjectedFileViewProvider) || ((InjectedFileViewProvider)viewProvider).isDisposed()) {
                injected.remove(i);
                Disposer.dispose((Disposable)oldDocument);
                continue;
            }
            InjectedFileViewProvider oldViewProvider = (InjectedFileViewProvider)viewProvider;
            final ASTNode injectedNode = injectedPsi.getNode();
            final ASTNode oldFileNode = oldFile.getNode();
            assert (injectedNode != null) : "New node is null";
            assert (oldFileNode != null) : "Old node is null";
            if (!oldDocument.areRangesEqual(documentWindow)) continue;
            if (oldFile.getFileType() != injectedPsi.getFileType() || oldFile.getLanguage() != injectedPsi.getLanguage()) {
                injected.remove(i);
                Disposer.dispose((Disposable)oldDocument);
                continue;
            }
            oldFile.putUserData(FileContextUtil.INJECTED_IN_ELEMENT, injectedPsi.getUserData(FileContextUtil.INJECTED_IN_ELEMENT));
            assert (shreds.isValid());
            oldViewProvider.performNonPhysically(new Runnable(){

                @Override
                public void run() {
                    BlockSupportImpl.mergeTrees(oldFile, oldFileNode, injectedNode);
                }
            });
            assert (shreds.isValid());
            return oldFile;
        }
        injected.add(documentWindow);
        MultiHostRegistrarImpl.cacheInjectedRegion(documentWindow, hostDocument);
        return injectedPsi;
    }

    private static void cacheInjectedRegion(DocumentWindowImpl documentWindow, DocumentEx hostDocument) {
        List<RangeMarker> injectedRegions = InjectedLanguageUtil.getCachedInjectedRegions(hostDocument);
        RangeMarker newMarker = documentWindow.getHostRanges()[0];
        TextRange newRange = InjectedLanguageUtil.toTextRange(newMarker);
        for (int i = 0; i < injectedRegions.size(); ++i) {
            RangeMarker stored = injectedRegions.get(i);
            TextRange storedRange = InjectedLanguageUtil.toTextRange(stored);
            if (storedRange.intersects(newRange)) {
                injectedRegions.set(i, newMarker);
                break;
            }
            if (storedRange.getStartOffset() <= newRange.getEndOffset()) continue;
            injectedRegions.add(i, newMarker);
            break;
        }
        if (injectedRegions.isEmpty() || newRange.getStartOffset() > injectedRegions.get(injectedRegions.size() - 1).getEndOffset()) {
            injectedRegions.add(newMarker);
        }
    }

    private static List<Trinity<IElementType, PsiLanguageInjectionHost, TextRange>> obtainHighlightTokensFromLexer(Language language, StringBuilder outChars, List<LiteralTextEscaper<? extends PsiLanguageInjectionHost>> escapers, Place shreds, VirtualFileWindow virtualFile, Project project) {
        ArrayList<Trinity<IElementType, PsiLanguageInjectionHost, TextRange>> tokens = new ArrayList<Trinity<IElementType, PsiLanguageInjectionHost, TextRange>>(10);
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)((VirtualFile)virtualFile));
        Lexer lexer = syntaxHighlighter.getHighlightingLexer();
        lexer.start((CharSequence)outChars);
        int hostNum = -1;
        int prevHostEndOffset = 0;
        PsiLanguageInjectionHost host = null;
        LiteralTextEscaper<? extends PsiLanguageInjectionHost> escaper = null;
        int prefixLength = 0;
        int suffixLength = 0;
        TextRange rangeInsideHost = null;
        int shredEndOffset = -1;
        IElementType tokenType = lexer.getTokenType();
        while (tokenType != null) {
            ProperTextRange range = new ProperTextRange(lexer.getTokenStart(), lexer.getTokenEnd());
            while (range != null && !range.isEmpty()) {
                if (range.getStartOffset() >= shredEndOffset) {
                    shredEndOffset = ((PsiLanguageInjectionHost.Shred)shreds.get((int)(++hostNum))).range.getEndOffset();
                    prevHostEndOffset = range.getStartOffset();
                    host = ((PsiLanguageInjectionHost.Shred)shreds.get((int)hostNum)).host;
                    escaper = escapers.get(hostNum);
                    rangeInsideHost = ((PsiLanguageInjectionHost.Shred)shreds.get(hostNum)).getRangeInsideHost();
                    prefixLength = ((PsiLanguageInjectionHost.Shred)shreds.get((int)hostNum)).prefix.length();
                    suffixLength = ((PsiLanguageInjectionHost.Shred)shreds.get((int)hostNum)).suffix.length();
                }
                if (range.getStartOffset() < prevHostEndOffset + prefixLength) {
                    range = new TextRange(prevHostEndOffset + prefixLength, range.getEndOffset());
                }
                TextRange spilled = null;
                if (range.getEndOffset() >= shredEndOffset - suffixLength) {
                    spilled = new TextRange(shredEndOffset, range.getEndOffset());
                    range = new TextRange(range.getStartOffset(), shredEndOffset);
                }
                if (!range.isEmpty()) {
                    int end;
                    int start = escaper.getOffsetInHost(range.getStartOffset() - prevHostEndOffset - prefixLength, rangeInsideHost);
                    if (start == -1) {
                        start = rangeInsideHost.getStartOffset();
                    }
                    if ((end = escaper.getOffsetInHost(range.getEndOffset() - prevHostEndOffset - prefixLength, rangeInsideHost)) == -1) {
                        end = rangeInsideHost.getEndOffset();
                        prevHostEndOffset = shredEndOffset;
                    }
                    ProperTextRange rangeInHost = new ProperTextRange(start, end);
                    tokens.add((Trinity<IElementType, PsiLanguageInjectionHost, TextRange>)Trinity.create((Object)tokenType, (Object)host, (Object)rangeInHost));
                }
                range = spilled;
            }
            lexer.advance();
            tokenType = lexer.getTokenType();
        }
        return tokens;
    }
}

