/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.lang.injection.ConcatenationAwareInjector;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiParameterizedCachedValue;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaConcatenationInjectorManager
implements ProjectComponent,
ModificationTracker {
    public static final ExtensionPointName<ConcatenationAwareInjector> CONCATENATION_INJECTOR_EP_NAME = ExtensionPointName.create((String)"com.intellij.concatenationAwareInjector");
    private final AtomicReference<MultiHostInjector> myRegisteredConcatenationAdapter = new AtomicReference();
    private final InjectedLanguageManager myInjectedLanguageManager;
    private volatile long myModificationCounter;
    private static final ConcatenationPsiCachedValueProvider CONCATENATION_PSI_CACHED_VALUE_PROVIDER = new ConcatenationPsiCachedValueProvider();
    private static final Key<ParameterizedCachedValue<MultiHostRegistrarImpl, PsiElement>> INJECTED_PSI_IN_CONCATENATION = Key.create((String)"INJECTED_PSI_IN_CONCATENATION");
    private final Concatenation2InjectorAdapter myConcatenation2InjectorAdapter = new Concatenation2InjectorAdapter();
    private final List<ConcatenationAwareInjector> myConcatenationInjectors = ContainerUtil.createEmptyCOWList();

    public JavaConcatenationInjectorManager(Project project, InjectedLanguageManager injectedLanguageManager, PsiManagerEx psiManagerEx) {
        this.myInjectedLanguageManager = injectedLanguageManager;
        ExtensionPoint concatPoint = Extensions.getArea((AreaInstance)project).getExtensionPoint(CONCATENATION_INJECTOR_EP_NAME);
        concatPoint.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ConcatenationAwareInjector>(){

            public void extensionAdded(ConcatenationAwareInjector injector, @Nullable PluginDescriptor pluginDescriptor) {
                JavaConcatenationInjectorManager.this.registerConcatenationInjector(injector);
            }

            public void extensionRemoved(ConcatenationAwareInjector injector, @Nullable PluginDescriptor pluginDescriptor) {
                JavaConcatenationInjectorManager.this.unregisterConcatenationInjector(injector);
            }
        });
        psiManagerEx.registerRunnableToRunOnAnyChange(new Runnable(){

            @Override
            public void run() {
                JavaConcatenationInjectorManager.this.myModificationCounter++;
            }
        });
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("JavaConcatenationInjectorManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager.getComponentName must not return null");
        }
        return "JavaConcatenationInjectorManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public static JavaConcatenationInjectorManager getInstance(Project project) {
        return (JavaConcatenationInjectorManager)project.getComponent(JavaConcatenationInjectorManager.class);
    }

    public long getModificationCount() {
        return this.myModificationCounter;
    }

    private static void collectOperands(PsiElement expression, List<PsiElement> operands) {
        if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            JavaConcatenationInjectorManager.collectOperands((PsiElement)binaryExpression.getLOperand(), operands);
            JavaConcatenationInjectorManager.collectOperands((PsiElement)binaryExpression.getROperand(), operands);
        } else if (expression != null) {
            operands.add(expression);
        }
    }

    public void registerConcatenationInjector(@NotNull ConcatenationAwareInjector injector) {
        if (injector == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager.registerConcatenationInjector must not be null");
        }
        this.myConcatenationInjectors.add(injector);
        this.concatenationInjectorsChanged();
    }

    public boolean unregisterConcatenationInjector(@NotNull ConcatenationAwareInjector injector) {
        if (injector == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager.unregisterConcatenationInjector must not be null");
        }
        boolean removed = this.myConcatenationInjectors.remove(injector);
        this.concatenationInjectorsChanged();
        return removed;
    }

    private void concatenationInjectorsChanged() {
        ++this.myModificationCounter;
        if (this.myConcatenationInjectors.isEmpty()) {
            MultiHostInjector prev = this.myRegisteredConcatenationAdapter.getAndSet(null);
            if (prev != null) {
                this.myInjectedLanguageManager.unregisterMultiHostInjector(prev);
            }
        } else if (this.myRegisteredConcatenationAdapter.compareAndSet(null, this.myConcatenation2InjectorAdapter)) {
            this.myInjectedLanguageManager.registerMultiHostInjector((MultiHostInjector)this.myConcatenation2InjectorAdapter);
        }
    }

    private class Concatenation2InjectorAdapter
    implements MultiHostInjector {
        private Concatenation2InjectorAdapter() {
        }

        public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
            CachedValueProvider.Result<MultiHostRegistrarImpl> res;
            if (registrar == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager$Concatenation2InjectorAdapter.getLanguagesToInject must not be null");
            }
            if (context == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager$Concatenation2InjectorAdapter.getLanguagesToInject must not be null");
            }
            if (JavaConcatenationInjectorManager.this.myConcatenationInjectors.isEmpty()) {
                return;
            }
            ParameterizedCachedValue cachedValue = (ParameterizedCachedValue)context.getUserData(INJECTED_PSI_IN_CONCATENATION);
            MultiHostRegistrarImpl result = cachedValue == null ? ((res = CONCATENATION_PSI_CACHED_VALUE_PROVIDER.compute(context)) == null ? null : (MultiHostRegistrarImpl)res.getValue()) : (MultiHostRegistrarImpl)cachedValue.getValue((Object)context);
            if (result != null && result.result != null) {
                for (Pair<Place, PsiFile> pair : result.result) {
                    ((MultiHostRegistrarImpl)registrar).addToResults((Place)((Object)pair.first), (PsiFile)pair.second);
                }
            }
        }

        @NotNull
        public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
            List<Class> list = Arrays.asList(PsiLiteralExpression.class);
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager$Concatenation2InjectorAdapter.elementsToInjectIn must not return null");
            }
            return list;
        }
    }

    private static class ConcatenationPsiCachedValueProvider
    implements ParameterizedCachedValueProvider<MultiHostRegistrarImpl, PsiElement> {
        private ConcatenationPsiCachedValueProvider() {
        }

        public CachedValueProvider.Result<MultiHostRegistrarImpl> compute(PsiElement context) {
            PsiElement anchor;
            PsiElement[] operands;
            PsiElement element = context;
            PsiElement parent = context.getParent();
            while (parent instanceof PsiBinaryExpression && ((PsiBinaryExpression)parent).getOperationSign().getTokenType() == JavaTokenType.PLUS || parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getOperationSign().getTokenType() == JavaTokenType.PLUSEQ || parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != element || parent instanceof PsiTypeCastExpression || parent instanceof PsiParenthesizedExpression) {
                element = parent;
                parent = parent.getParent();
            }
            if (element instanceof PsiBinaryExpression || element instanceof PsiAssignmentExpression) {
                ArrayList operandList = new ArrayList();
                JavaConcatenationInjectorManager.collectOperands(element, operandList);
                operands = operandList.toArray(new PsiElement[operandList.size()]);
                anchor = element;
            } else {
                operands = new PsiElement[]{context};
                anchor = context;
            }
            Project project = context.getProject();
            MultiHostRegistrarImpl registrar = new MultiHostRegistrarImpl(project, context.getContainingFile(), anchor);
            JavaConcatenationInjectorManager concatenationInjectorManager = JavaConcatenationInjectorManager.getInstance(project);
            for (ConcatenationAwareInjector concatenationInjector : concatenationInjectorManager.myConcatenationInjectors) {
                concatenationInjector.getLanguagesToInject((MultiHostRegistrar)registrar, operands);
            }
            CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)registrar, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, concatenationInjectorManager});
            if (registrar.result != null) {
                ParameterizedCachedValue cachedValue = CachedValuesManager.getManager((Project)context.getProject()).createParameterizedCachedValue((ParameterizedCachedValueProvider)this, false);
                ((PsiParameterizedCachedValue)cachedValue).setValue(result);
                for (PsiElement operand : operands) {
                    operand.putUserData(INJECTED_PSI_IN_CONCATENATION, (Object)cachedValue);
                }
                anchor.putUserData(INJECTED_PSI_IN_CONCATENATION, (Object)cachedValue);
                context.putUserData(INJECTED_PSI_IN_CONCATENATION, (Object)cachedValue);
            }
            return result;
        }
    }
}

