/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleFacadeImpl
extends CodeStyleFacade {
    private final Project myProject;

    public CodeStyleFacadeImpl() {
        this(null);
    }

    public CodeStyleFacadeImpl(Project project) {
        this.myProject = project;
    }

    public int getIndentSize(FileType fileType) {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).getIndentSize(fileType);
    }

    @Nullable
    public String getLineIndent(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeStyleFacadeImpl.getLineIndent must not be null");
        }
        if (this.myProject == null) {
            return null;
        }
        return CodeStyleManager.getInstance((Project)this.myProject).getLineIndent(editor);
    }

    public String getLineSeparator() {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).getLineSeparator();
    }

    public boolean projectUsesOwnSettings() {
        return this.myProject != null && CodeStyleSettingsManager.getInstance((Project)this.myProject).USE_PER_PROJECT_SETTINGS;
    }

    public boolean isUnsuitableCodestyleConfigurable(Configurable c) {
        return false;
    }

    public int getRightMargin() {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).RIGHT_MARGIN;
    }

    public int getTabSize(FileType fileType) {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).getTabSize(fileType);
    }

    public boolean isSmartTabs(FileType fileType) {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).isSmartTabs(fileType);
    }

    public boolean useTabCharacter(FileType fileType) {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject).useTabCharacter(fileType);
    }
}

